/*
 * Decompiled with CFR 0.152.
 */
package org.xdat.workerThreads;

import java.io.IOException;
import java.util.HashMap;
import javax.swing.JOptionPane;
import javax.swing.ProgressMonitor;
import javax.swing.SwingWorker;
import org.xdat.Main;
import org.xdat.chart.ParallelCoordinatesChart;
import org.xdat.data.ClusterSet;
import org.xdat.data.DataSheet;
import org.xdat.exceptions.InconsistentDataException;
import org.xdat.gui.frames.ChartFrame;

public class DataSheetUpdateThread
extends SwingWorker {
    private String pathToInputFile;
    private boolean dataHasHeaders;
    private Main mainWindow;
    private ProgressMonitor progressMonitor;

    public DataSheetUpdateThread(String pathToInputFile, boolean dataHasHeaders, Main mainWindow, ProgressMonitor progressMonitor) {
        this.pathToInputFile = pathToInputFile;
        this.dataHasHeaders = dataHasHeaders;
        this.mainWindow = mainWindow;
        this.progressMonitor = progressMonitor;
    }

    public Object doInBackground() {
        try {
            HashMap<ChartFrame, double[]> upperFilterValues = new HashMap<ChartFrame, double[]>();
            HashMap<ChartFrame, double[]> lowerFilterValues = new HashMap<ChartFrame, double[]>();
            for (int i = 0; i < this.mainWindow.getChartFrameCount(); ++i) {
                ChartFrame f = this.mainWindow.getChartFrame(i);
                if (!f.getChart().getClass().equals(ParallelCoordinatesChart.class)) continue;
                ParallelCoordinatesChart c = (ParallelCoordinatesChart)f.getChart();
                double[] ufValues = new double[c.getAxisCount()];
                double[] lfValues = new double[c.getAxisCount()];
                for (int a = 0; a < c.getAxisCount(); ++a) {
                    ufValues[a] = c.getAxis(a).getUpperFilter().getValue();
                    lfValues[a] = c.getAxis(a).getLowerFilter().getValue();
                }
                upperFilterValues.put(f, ufValues);
                lowerFilterValues.put(f, lfValues);
            }
            DataSheet dataSheet = this.mainWindow.getDataSheet();
            ClusterSet clusterSet = this.mainWindow.getCurrentClusterSet();
            dataSheet.updateData(this.pathToInputFile, this.dataHasHeaders, this.progressMonitor, clusterSet);
            for (int i = 0; i < this.mainWindow.getChartFrameCount(); ++i) {
                ChartFrame f = this.mainWindow.getChartFrame(i);
                if (!f.getChart().getClass().equals(ParallelCoordinatesChart.class)) continue;
                ParallelCoordinatesChart c = (ParallelCoordinatesChart)f.getChart();
                double[] ufValues = (double[])upperFilterValues.get(f);
                double[] lfValues = (double[])lowerFilterValues.get(f);
                for (int a = 0; a < c.getAxisCount(); ++a) {
                    c.getAxis(a).getUpperFilter().setValue(ufValues[a], dataSheet);
                    c.getAxis(a).getLowerFilter().setValue(lfValues[a], dataSheet);
                }
            }
        }
        catch (IOException e) {
            JOptionPane.showMessageDialog(this.mainWindow, "Error on updating data from file:\n " + e.getMessage(), "Update Data", 0);
        }
        catch (InconsistentDataException e1) {
            JOptionPane.showMessageDialog(this.mainWindow, e1.getMessage() + "\nThe previous state will be restored.", "Update Data", 0);
        }
        this.progressMonitor.close();
        return null;
    }
}

