/*
 * Decompiled with CFR 0.152.
 */
package org.xdat.workerThreads;

import java.io.IOException;
import javax.swing.JOptionPane;
import javax.swing.ProgressMonitor;
import javax.swing.SwingWorker;
import org.xdat.Main;
import org.xdat.data.ClusterSet;
import org.xdat.data.DataSheet;

public class DataSheetCreationThread
extends SwingWorker {
    private String pathToInputFile;
    private boolean dataHasHeaders;
    private Main mainWindow;
    private ProgressMonitor progressMonitor;

    public DataSheetCreationThread(String pathToInputFile, boolean dataHasHeaders, Main mainWindow, ProgressMonitor progressMonitor) {
        this.pathToInputFile = pathToInputFile;
        this.dataHasHeaders = dataHasHeaders;
        this.mainWindow = mainWindow;
        this.progressMonitor = progressMonitor;
    }

    public Object doInBackground() {
        try {
            DataSheet dataSheet = new DataSheet(this.pathToInputFile, this.dataHasHeaders, this.mainWindow, this.progressMonitor);
            ClusterSet clusterSet = new ClusterSet(dataSheet);
            if (this.progressMonitor.isCanceled()) {
                this.mainWindow.repaint();
            } else {
                this.mainWindow.setDataSheet(dataSheet);
                this.mainWindow.setCurrentClusterSet(clusterSet);
                this.mainWindow.getMainMenuBar().setItemsRequiringDataSheetEnabled(true);
            }
        }
        catch (IOException e) {
            JOptionPane.showMessageDialog(this.mainWindow, "Error on importing data from file:\n " + e.getMessage(), "Import Data", 0);
        }
        this.progressMonitor.close();
        return null;
    }
}

