/*
 * Decompiled with CFR 0.152.
 */
package org.xdat.settings;

import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import java.util.function.Function;
import org.xdat.settings.Setting;

public class SettingsTransaction {
    private final List<Setting<?>> changedSettings = new ArrayList();
    private final Set<Runnable> handlers = new LinkedHashSet<Runnable>();

    public void execute(Collection<Function<SettingsTransaction, Boolean>> tasks) {
        boolean changed = false;
        for (Function<SettingsTransaction, Boolean> applyAction : tasks) {
            changed |= applyAction.apply(this).booleanValue();
        }
        if (changed) {
            this.runHandlers();
        }
    }

    public void handleOnce(Runnable handler) {
        this.handlers.add(handler);
    }

    void addChanged(Setting<?> setting) {
        this.changedSettings.add(setting);
    }

    private void runHandlers() {
        if (this.isChanged()) {
            for (Runnable handler : this.handlers) {
                handler.run();
            }
        }
    }

    private boolean isChanged() {
        return !this.changedSettings.isEmpty();
    }
}

