/*
 * Decompiled with CFR 0.152.
 */
package org.xdat.settings;

import java.awt.Color;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.xdat.settings.BooleanSetting;
import org.xdat.settings.ColorSetting;
import org.xdat.settings.DoubleSetting;
import org.xdat.settings.IntegerSetting;
import org.xdat.settings.Key;
import org.xdat.settings.MultipleChoiceSetting;
import org.xdat.settings.Setting;
import org.xdat.settings.SettingsTransaction;
import org.xdat.settings.StringSetting;

public class SettingsGroup
implements Serializable {
    static final long serialVersionUID = 1L;
    private final Map<Key, Setting<?>> settingsMap;

    private SettingsGroup(Collection<Setting<?>> settings) {
        LinkedHashMap m = new LinkedHashMap();
        for (Setting<?> setting : settings) {
            m.put(setting.getKey(), setting);
        }
        this.settingsMap = Collections.unmodifiableMap(m);
    }

    public Map<Key, Setting<?>> getSettings() {
        return this.settingsMap;
    }

    public void applyAllAsDefault() {
        for (Setting<?> setting : this.getSettings().values()) {
            setting.setCurrentToDefault();
        }
    }

    public Setting<?> getSetting(Key key) {
        Setting<?> setting = this.settingsMap.get((Object)key);
        if (setting == null) {
            throw new IllegalArgumentException("No setting stored under key " + (Object)((Object)key));
        }
        return setting;
    }

    public BooleanSetting getBooleanSetting(Key key) {
        return (BooleanSetting)this.getSetting(key);
    }

    public ColorSetting getColorSetting(Key key) {
        return (ColorSetting)this.getSetting(key);
    }

    public MultipleChoiceSetting getMultipleChoiceSetting(Key key) {
        return (MultipleChoiceSetting)this.getSetting(key);
    }

    public DoubleSetting getDoubleSetting(Key key) {
        return (DoubleSetting)this.getSetting(key);
    }

    public IntegerSetting getIntegerSetting(Key key) {
        return (IntegerSetting)this.getSetting(key);
    }

    public StringSetting getStringSetting(Key key) {
        return (StringSetting)this.getSetting(key);
    }

    public boolean getBoolean(Key key) {
        return (Boolean)this.getBooleanSetting(key).get();
    }

    public Color getColor(Key key) {
        return (Color)this.getColorSetting(key).get();
    }

    public Integer getInteger(Key key) {
        return (Integer)this.getIntegerSetting(key).get();
    }

    public Double getDouble(Key key) {
        return (Double)this.getDoubleSetting(key).get();
    }

    public String getString(Key key) {
        return (String)this.getStringSetting(key).get();
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public void resetToDefault() {
        SettingsTransaction transaction = new SettingsTransaction();
        transaction.execute(this.settingsMap.values().stream().map(s -> s::resetToDefault).collect(Collectors.toList()));
    }

    public void initTransientData() {
        this.settingsMap.values().forEach(Setting::initTransientData);
    }

    public static class Builder {
        private boolean built = false;
        private List<Setting<?>> settings = new ArrayList();

        private Builder() {
        }

        public <T> Builder addSetting(Setting<T> setting) {
            this.throwIfBuilt();
            this.settings.add(setting);
            return this;
        }

        public SettingsGroup build() {
            this.throwIfBuilt();
            this.built = true;
            return new SettingsGroup(this.settings);
        }

        private void throwIfBuilt() {
            if (this.built) {
                throw new IllegalStateException("already built!");
            }
        }
    }
}

