/*
 * Decompiled with CFR 0.152.
 */
package org.xdat.settings;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.UUID;
import org.jetbrains.annotations.Nullable;
import org.xdat.gui.panels.EnabledCondition;
import org.xdat.settings.Key;
import org.xdat.settings.SettingsListener;
import org.xdat.settings.SettingsTransaction;
import org.xdat.settings.SettingsType;

public abstract class Setting<T>
implements Serializable {
    static final long serialVersionUID = 1L;
    private final String uniqueId = UUID.randomUUID().toString();
    private final Key key;
    private final T hardCodedDefault;
    private T currentValue;
    private final String title;
    private final SettingsType type;
    private transient List<SettingsListener<T>> listeners;
    @Nullable
    private EnabledCondition<?, T> enabledCondition;

    Setting(String title, T hardCodedDefault, SettingsType type, Key key) {
        this.title = title;
        this.type = type;
        this.key = key;
        this.hardCodedDefault = hardCodedDefault;
        this.currentValue = this.getDefault();
        this.initTransientData();
    }

    public String getUniqueId() {
        return this.uniqueId;
    }

    public void addListener(SettingsListener<T> l) {
        this.listeners.add(l);
    }

    public void setCurrentToDefault() {
        this.setDefault(this.currentValue);
    }

    abstract T getDefaultImpl(Key var1, T var2);

    abstract void setDefaultImpl(Key var1, T var2);

    public void setDefault(T defaultValue) {
        if (this.key == null) {
            return;
        }
        this.setDefaultImpl(this.key, defaultValue);
    }

    public T getDefault() {
        if (this.key == null) {
            return this.hardCodedDefault;
        }
        return this.getDefaultImpl(this.key, this.hardCodedDefault);
    }

    public T get() {
        return this.currentValue;
    }

    public boolean set(T value) {
        return this.set(value, null);
    }

    public boolean set(T value, @Nullable SettingsTransaction transaction) {
        if (Objects.equals(value, this.currentValue)) {
            return false;
        }
        this.currentValue = value;
        if (transaction != null) {
            transaction.addChanged(this);
        }
        this.listeners.forEach(l -> l.onValueChanged(this, transaction));
        return true;
    }

    public String getTitle() {
        return this.title;
    }

    public SettingsType getType() {
        return this.type;
    }

    public Key getKey() {
        return this.key;
    }

    public void initTransientData() {
        this.listeners = new ArrayList<SettingsListener<T>>();
    }

    public boolean resetToDefault(@Nullable SettingsTransaction t) {
        return this.set(this.getDefault(), t);
    }

    public void setEnabledCondition(@Nullable EnabledCondition<?, T> enabledCondition) {
        this.enabledCondition = enabledCondition;
    }

    public Optional<EnabledCondition<?, T>> getEnabledCondition() {
        return Optional.ofNullable(this.enabledCondition);
    }
}

