/*
 * Decompiled with CFR 0.152.
 */
package org.xdat.gui.tables;

import javax.swing.table.AbstractTableModel;
import org.xdat.data.DataSheet;
import org.xdat.data.Design;

public class DataSheetTableModel
extends AbstractTableModel {
    private final DataSheet dataSheet;

    public DataSheetTableModel(DataSheet dataSheet) {
        this.dataSheet = dataSheet;
    }

    @Override
    public Class<?> getColumnClass(int arg0) {
        return String.class;
    }

    @Override
    public int getColumnCount() {
        return this.dataSheet.getParameterCount();
    }

    @Override
    public int getRowCount() {
        return this.dataSheet.getDesignCount();
    }

    @Override
    public String getColumnName(int columnIndex) {
        return this.dataSheet.getParameter(columnIndex).getName();
    }

    @Override
    public Object getValueAt(int rowIndex, int columnIndex) {
        Design design = this.dataSheet.getDesign(rowIndex);
        if (columnIndex == 0) {
            return design.getId();
        }
        return design.getStringValue(this.dataSheet.getParameter(columnIndex - 1));
    }

    @Override
    public void setValueAt(Object arg0, int rowIndex, int columnIndex) {
        this.dataSheet.setValueAt(arg0, rowIndex, columnIndex);
        this.fireTableCellUpdated(rowIndex, columnIndex);
    }

    @Override
    public boolean isCellEditable(int rowIndex, int columnIndex) {
        return columnIndex != 0;
    }
}

