/*
 * Decompiled with CFR 0.152.
 */
package org.xdat.gui.tables;

import java.util.Collection;
import javax.swing.table.DefaultTableColumnModel;
import javax.swing.table.TableColumn;
import org.xdat.Main;
import org.xdat.chart.Chart;
import org.xdat.chart.ParallelCoordinatesChart;

public class DataSheetTableColumnModel
extends DefaultTableColumnModel {
    private final Main mainWindow;

    public DataSheetTableColumnModel(Main mainWindow) {
        this.mainWindow = mainWindow;
        this.setColumnMargin(1);
    }

    @Override
    public boolean getColumnSelectionAllowed() {
        return false;
    }

    @Override
    public void moveColumn(int src, int tar) {
        if (src != 0 && tar != 0) {
            super.moveColumn(src, tar);
            if (src != tar) {
                this.mainWindow.getDataSheet().moveParameter(src - 1, tar - 1);
                for (int i = 0; i < this.getColumnCount(); ++i) {
                    this.getColumn(i).setModelIndex(i);
                }
                Collection<Chart> charts = this.mainWindow.getCurrentSession().getCharts();
                for (Chart chart : charts) {
                    if (!(chart instanceof ParallelCoordinatesChart)) continue;
                    ((ParallelCoordinatesChart)chart).moveAxis(src - 1, tar - 1);
                }
                this.mainWindow.repaintAllChartFrames();
            }
        }
    }

    @Override
    public void removeColumn(TableColumn arg0) {
    }
}

