/*
 * Decompiled with CFR 0.152.
 */
package org.xdat.gui.tables;

import java.awt.Color;
import java.util.LinkedList;
import java.util.List;
import java.util.stream.Collectors;
import javax.swing.JOptionPane;
import javax.swing.table.AbstractTableModel;
import org.xdat.data.Cluster;
import org.xdat.data.ClusterFactory;
import org.xdat.data.DataSheet;

public class ClusterTableModel
extends AbstractTableModel {
    private final List<Cluster> clustersBuffer = new LinkedList<Cluster>();
    private final ClusterFactory factory;

    public ClusterTableModel(List<Cluster> clusters, ClusterFactory factory) {
        this.factory = factory;
        this.clustersBuffer.addAll(clusters.stream().map(Cluster::duplicate).collect(Collectors.toList()));
    }

    @Override
    public int getRowCount() {
        return this.clustersBuffer.size();
    }

    @Override
    public String getColumnName(int columnIndex) {
        switch (columnIndex) {
            case 0: {
                return "Cluster";
            }
            case 1: {
                return "Color";
            }
            case 2: {
                return "Active";
            }
        }
        return null;
    }

    @Override
    public Class<?> getColumnClass(int columnIndex) {
        switch (columnIndex) {
            case 0: {
                return String.class;
            }
            case 1: {
                return Color.class;
            }
            case 2: {
                return Integer.class;
            }
            case 3: {
                return Boolean.class;
            }
        }
        return null;
    }

    @Override
    public int getColumnCount() {
        return 4;
    }

    @Override
    public Object getValueAt(int rowIndex, int columnIndex) {
        switch (columnIndex) {
            case 0: {
                return this.clustersBuffer.get(rowIndex).getName();
            }
            case 1: {
                return this.clustersBuffer.get(rowIndex).getActiveDesignColor(true);
            }
            case 2: {
                return this.clustersBuffer.get(rowIndex).getLineThickness();
            }
            case 3: {
                return this.clustersBuffer.get(rowIndex).isActive();
            }
        }
        return null;
    }

    @Override
    public void setValueAt(Object arg0, int rowIndex, int columnIndex) {
        switch (columnIndex) {
            case 0: {
                if (this.isNameUnique(arg0.toString(), rowIndex)) {
                    this.clustersBuffer.get(rowIndex).setName(arg0.toString());
                    break;
                }
                JOptionPane.showMessageDialog(null, "This name is not unique. Please choose a different name.", "Rename Cluster", 1);
                break;
            }
            case 1: {
                this.clustersBuffer.get(rowIndex).setActiveDesignColor((Color)arg0);
                break;
            }
            case 2: {
                try {
                    int thickness = Integer.parseInt(arg0.toString());
                    if (thickness < 0 || thickness > 10) {
                        throw new NumberFormatException();
                    }
                    this.clustersBuffer.get(rowIndex).setLineThickness(thickness);
                }
                catch (NumberFormatException e) {
                    JOptionPane.showMessageDialog(null, "Invalid input. Values must be integers between 0 and 10.", "Invalid Input", 0);
                }
                break;
            }
            case 3: {
                this.clustersBuffer.get(rowIndex).setActive(Boolean.parseBoolean(arg0.toString()));
            }
        }
        this.fireTableCellUpdated(rowIndex, columnIndex);
    }

    @Override
    public boolean isCellEditable(int rowIndex, int columnIndex) {
        return true;
    }

    public void addCluster() {
        Cluster newCluster = this.factory.newCluster(this.clustersBuffer);
        this.clustersBuffer.add(newCluster);
        int index = this.clustersBuffer.size() - 1;
        this.fireTableRowsInserted(index, index);
    }

    public void removeCluster(int i) {
        this.clustersBuffer.remove(i);
        this.fireTableRowsDeleted(i, i);
    }

    private boolean isNameUnique(String name, int exception) {
        boolean unique = true;
        for (int i = 0; i < this.clustersBuffer.size(); ++i) {
            if (!name.equals(this.clustersBuffer.get(i).getName()) || i == exception) continue;
            unique = false;
            break;
        }
        return unique;
    }

    public List<Cluster> getClustersBuffer() {
        return this.clustersBuffer;
    }

    public void applyBuffer(List<Cluster> clusters, DataSheet dataSheet) {
        int i;
        for (i = clusters.size() - 1; i >= 0; --i) {
            boolean clusterRemoved = true;
            for (int j = this.clustersBuffer.size() - 1; j >= 0; --j) {
                if (clusters.get(i).getUniqueId() != this.clustersBuffer.get(j).getUniqueId()) continue;
                clusterRemoved = false;
                this.clustersBuffer.remove(j).copySettingsTo(clusters.get(i));
                break;
            }
            if (!clusterRemoved) continue;
            Cluster c = clusters.remove(i);
            for (int j = 0; j < dataSheet.getDesignCount(); ++j) {
                if (!c.equals(dataSheet.getDesign(j).getCluster())) continue;
                dataSheet.getDesign(j).setCluster(null);
            }
        }
        for (i = 0; i < this.clustersBuffer.size(); ++i) {
            clusters.add(this.clustersBuffer.get(i).duplicate());
        }
    }
}

