/*
 * Decompiled with CFR 0.152.
 */
package org.xdat.gui.panels;

import java.awt.BorderLayout;
import java.awt.Component;
import javax.swing.JPanel;
import org.xdat.Main;
import org.xdat.chart.Chart;
import org.xdat.data.DatasheetListener;
import org.xdat.gui.controls.CustomButton;
import org.xdat.gui.frames.ChartFrame;
import org.xdat.gui.panels.ChartPanel;

public abstract class SidebarPanel
extends JPanel {
    private final Main mainWindow;
    private final ChartFrame chartFrame;
    private final ChartPanel chartPanel;
    private final JPanel contentPanel;
    private final JPanel headerPanel;
    private final Chart chart;
    private boolean maximized = true;
    private final Runnable onClosed;

    SidebarPanel(Main mainWindow, ChartFrame chartFrame, ChartPanel chartPanel, Chart chart) {
        this.mainWindow = mainWindow;
        this.chartFrame = chartFrame;
        this.chartPanel = chartPanel;
        this.chart = chart;
        this.headerPanel = new JPanel();
        this.contentPanel = new JPanel();
        this.initialize();
        DatasheetListener listener = new DatasheetListener(){

            @Override
            public void onClustersChanged() {
                SidebarPanel.this.updateView();
            }

            @Override
            public void onDataPanelUpdateRequired() {
            }

            @Override
            public void onDataChanged(boolean[] autoFitRequired, boolean[] filterResetRequired, boolean[] applyFiltersRequired, boolean parametersChanged) {
            }
        };
        mainWindow.addDataSheetSubListener(listener);
        this.onClosed = () -> mainWindow.removeDataSheetSubListener(listener);
        this.updateView();
    }

    private void updateView() {
        this.buildHeaderPanel();
        this.setLayout(new BorderLayout());
        this.add((Component)this.headerPanel, "North");
        this.contentPanel.removeAll();
        if (this.maximized) {
            this.buildPanel(this.contentPanel);
            this.add((Component)this.contentPanel, "Center");
        }
        this.chartFrame.validate();
        this.chartFrame.repaint();
    }

    private void buildHeaderPanel() {
        this.headerPanel.removeAll();
        this.headerPanel.setLayout(new BorderLayout());
        CustomButton toggleButton = this.maximized ? new CustomButton("Collapse", "images/minimize.png", "images/minimize_pressed.png", "Collapse") : new CustomButton("Expand", "images/maximize.png", "images/maximize_pressed.png", "Expand");
        this.headerPanel.add((Component)toggleButton, "West");
        toggleButton.addActionListener(e -> {
            this.maximized = !this.maximized;
            this.updateView();
        });
    }

    public Main getMainWindow() {
        return this.mainWindow;
    }

    public Chart getChart() {
        return this.chart;
    }

    public ChartPanel getChartPanel() {
        return this.chartPanel;
    }

    public ChartFrame getChartFrame() {
        return this.chartFrame;
    }

    protected abstract void buildPanel(JPanel var1);

    protected abstract void initialize();

    public void onClosed() {
        this.onClosed.run();
    }
}

