/*
 * Decompiled with CFR 0.152.
 */
package org.xdat.gui.panels;

import java.awt.Color;
import java.awt.FlowLayout;
import java.awt.GridLayout;
import java.awt.LayoutManager;
import java.util.List;
import javax.swing.JCheckBox;
import javax.swing.JColorChooser;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JSpinner;
import javax.swing.JTextField;
import org.jetbrains.annotations.Nullable;
import org.xdat.gui.controls.ColorChoiceButton;
import org.xdat.gui.controls.MinMaxSpinnerModel;
import org.xdat.gui.controls.RightAlignedSpinner;
import org.xdat.gui.panels.SettingComponents;
import org.xdat.gui.panels.SettingControlPanel;
import org.xdat.gui.panels.SettingsControlListener;
import org.xdat.settings.BooleanSetting;
import org.xdat.settings.ColorSetting;
import org.xdat.settings.DoubleSetting;
import org.xdat.settings.Formatting;
import org.xdat.settings.IntegerSetting;
import org.xdat.settings.MultipleChoiceSetting;
import org.xdat.settings.Setting;
import org.xdat.settings.SettingsTransaction;
import org.xdat.settings.SettingsType;

public class SettingsPanelFactory {
    private SettingsPanelFactory() {
        throw new IllegalStateException("No instance for you!");
    }

    public static <T> SettingComponents standaloneFrom(Setting<T> setting) {
        return SettingsPanelFactory.from(setting, null);
    }

    static <T> SettingComponents from(Setting<T> setting, @Nullable SettingsControlListener settingsControlListener) {
        SettingsType type = setting.getType();
        JLabel label = new JLabel(setting.getTitle());
        switch (type) {
            case BOOLEAN: {
                return new SettingComponents<Boolean>(label, SettingsPanelFactory.buildBooleanControl((BooleanSetting)setting, settingsControlListener));
            }
            case INTEGER: {
                return new SettingComponents<Integer>(label, SettingsPanelFactory.buildIntegerControl((IntegerSetting)setting, settingsControlListener));
            }
            case DOUBLE: {
                return new SettingComponents<Double>(label, SettingsPanelFactory.buildDoubleControl((DoubleSetting)setting, settingsControlListener));
            }
            case STRING: {
                throw new IllegalStateException("Setting type " + (Object)((Object)type) + " not yet implemented!");
            }
            case COLOR: {
                return new SettingComponents<Color>(label, SettingsPanelFactory.buildColorControl((ColorSetting)setting, settingsControlListener));
            }
            case MULTIPLE_CHOICE: {
                return new SettingComponents<String>(label, SettingsPanelFactory.buildMultipleChoiceControl((MultipleChoiceSetting)setting, settingsControlListener));
            }
        }
        throw new IllegalStateException("Unknown setting type " + (Object)((Object)type));
    }

    private static SettingControlPanel<Boolean> buildBooleanControl(final BooleanSetting setting, @Nullable SettingsControlListener settingsControlListener) {
        final JCheckBox checkBox = new JCheckBox();
        SettingControlPanel<Boolean> outer = new SettingControlPanel<Boolean>((LayoutManager)new FlowLayout(1)){

            @Override
            public boolean applyValue(@Nullable SettingsTransaction transaction) {
                return setting.set(checkBox.isSelected(), transaction);
            }

            @Override
            public void setEnabled(boolean enabled) {
                checkBox.setEnabled(enabled);
            }

            @Override
            protected void setCurrentValue(Boolean value) {
                checkBox.setSelected(value);
            }
        };
        checkBox.setSelected((Boolean)setting.get());
        outer.add(checkBox);
        checkBox.addActionListener(actionEvent -> {
            if (settingsControlListener == null) {
                outer.applyValue(null);
            } else {
                settingsControlListener.onLinkedSettingsControlUpdated(setting, checkBox.isSelected());
            }
        });
        return outer;
    }

    private static SettingControlPanel<Integer> buildIntegerControl(final IntegerSetting setting, @Nullable SettingsControlListener settingsControlListener) {
        final RightAlignedSpinner spinner = new RightAlignedSpinner(new MinMaxSpinnerModel(setting.getMin(), setting.getMax()));
        ((JSpinner.DefaultEditor)spinner.getEditor()).getTextField().setHorizontalAlignment(4);
        SettingControlPanel<Integer> outer = new SettingControlPanel<Integer>((LayoutManager)new GridLayout(1, 1)){

            @Override
            public boolean applyValue(SettingsTransaction transaction) {
                return setting.set((Integer)spinner.getValue(), transaction);
            }

            @Override
            public void setEnabled(boolean enabled) {
                spinner.setEnabled(enabled);
            }

            @Override
            protected void setCurrentValue(Integer value) {
                spinner.setValue(value);
            }
        };
        spinner.setValue(setting.get());
        outer.add(spinner);
        spinner.addChangeListener(actionEvent -> {
            if (settingsControlListener == null) {
                outer.applyValue(null);
            } else {
                settingsControlListener.onLinkedSettingsControlUpdated(setting, (Integer)spinner.getValue());
            }
        });
        return outer;
    }

    private static SettingControlPanel<Double> buildDoubleControl(final DoubleSetting setting, @Nullable SettingsControlListener settingsControlListener) {
        final JTextField textField = new JTextField();
        SettingControlPanel<Double> outer = new SettingControlPanel<Double>((LayoutManager)new GridLayout(1, 1)){

            @Override
            public boolean applyValue(SettingsTransaction transaction) {
                String text = textField.getText();
                double previous = (Double)setting.get();
                try {
                    double d = Double.parseDouble(text);
                    setting.set(d, transaction);
                    return d != previous;
                }
                catch (NumberFormatException e) {
                    textField.setText(Formatting.formatDouble(previous, (Integer)setting.getDigitCountSetting().get()));
                    return false;
                }
            }

            @Override
            public void setEnabled(boolean enabled) {
                textField.setEnabled(enabled);
            }

            @Override
            protected void setCurrentValue(Double value) {
                textField.setText(Formatting.formatDouble(value, (Integer)setting.getDigitCountSetting().get()));
            }
        };
        textField.setText(String.valueOf(Formatting.formatDouble((Double)setting.get(), (Integer)setting.getDigitCountSetting().get())));
        outer.add(textField);
        textField.addActionListener(actionEvent -> {
            if (settingsControlListener == null) {
                outer.applyValue(null);
            } else {
                try {
                    double d = Double.parseDouble(textField.getText());
                    settingsControlListener.onLinkedSettingsControlUpdated(setting, d);
                }
                catch (NumberFormatException numberFormatException) {
                    // empty catch block
                }
            }
        });
        return outer;
    }

    private static SettingControlPanel<Color> buildColorControl(final ColorSetting setting, @Nullable SettingsControlListener settingsControlListener) {
        final ColorChoiceButton colorChoiceButton = new ColorChoiceButton((Color)setting.get());
        SettingControlPanel<Color> outer = new SettingControlPanel<Color>((LayoutManager)new FlowLayout(1)){

            @Override
            public boolean applyValue(SettingsTransaction transaction) {
                return setting.set(colorChoiceButton.getCurrentColor(), transaction);
            }

            @Override
            public void setEnabled(boolean enabled) {
                colorChoiceButton.setEnabled(enabled);
            }

            @Override
            protected void setCurrentValue(Color value) {
                colorChoiceButton.setCurrentColor(value);
            }
        };
        colorChoiceButton.addActionListener(actionCommand -> {
            Color newColor = JColorChooser.showDialog(outer, setting.getTitle(), colorChoiceButton.getCurrentColor());
            if (newColor != null) {
                colorChoiceButton.setCurrentColor(newColor);
                if (settingsControlListener == null) {
                    outer.applyValue(null);
                } else {
                    settingsControlListener.onLinkedSettingsControlUpdated(setting, newColor);
                }
            }
        });
        outer.add(colorChoiceButton);
        return outer;
    }

    private static SettingControlPanel<String> buildMultipleChoiceControl(final MultipleChoiceSetting setting, @Nullable SettingsControlListener settingsControlListener) {
        List<String> options = setting.getOptions();
        final JComboBox<String> comboBox = new JComboBox<String>(options.toArray(new String[0]));
        comboBox.setSelectedItem(setting.get());
        SettingControlPanel<String> outer = new SettingControlPanel<String>((LayoutManager)new FlowLayout(1)){

            @Override
            public boolean applyValue(SettingsTransaction transaction) {
                @Nullable String selectedItem = (String)comboBox.getSelectedItem();
                if (selectedItem != null) {
                    return setting.set(selectedItem, transaction);
                }
                return false;
            }

            @Override
            public void setEnabled(boolean enabled) {
                comboBox.setEnabled(enabled);
            }

            @Override
            protected void setCurrentValue(String value) {
                comboBox.setSelectedItem(value);
            }
        };
        outer.add(comboBox);
        comboBox.addActionListener(actionEvent -> {
            if (settingsControlListener == null) {
                outer.applyValue(null);
            } else {
                @Nullable String selectedItem = (String)comboBox.getSelectedItem();
                if (selectedItem != null) {
                    settingsControlListener.onLinkedSettingsControlUpdated(setting, selectedItem);
                }
            }
        });
        return outer;
    }
}

