/*
 * Decompiled with CFR 0.152.
 */
package org.xdat.gui.panels;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.GridLayout;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import org.xdat.gui.panels.PaddedPanel;
import org.xdat.gui.panels.SettingComponents;
import org.xdat.gui.panels.SettingsControlListener;
import org.xdat.gui.panels.SettingsPanelFactory;
import org.xdat.settings.Key;
import org.xdat.settings.Setting;
import org.xdat.settings.SettingsGroup;
import org.xdat.settings.SettingsTransaction;

public class SettingsGroupPanel
extends PaddedPanel {
    private final List<Function<SettingsTransaction, Boolean>> applyActions;
    private SettingsGroup settingsGroup;
    private final Map<Key, SettingComponents> map = new LinkedHashMap<Key, SettingComponents>();

    public SettingsGroupPanel(SettingsGroup settingsGroup) {
        super(5);
        this.settingsGroup = settingsGroup;
        this.applyActions = new ArrayList<Function<SettingsTransaction, Boolean>>();
        this.setLayout(new BorderLayout());
        PaddedPanel labelPanel = new PaddedPanel(0, 5, 0, 0);
        labelPanel.setLayout(new GridLayout(0, 1));
        PaddedPanel controlsPanel = new PaddedPanel(0, 0, 0, 5);
        controlsPanel.setLayout(new GridLayout(0, 1));
        this.add((Component)labelPanel, "Center");
        this.add((Component)controlsPanel, "East");
        final ArrayList<SettingComponents> allComponents = new ArrayList<SettingComponents>();
        SettingsControlListener listener = new SettingsControlListener(){

            @Override
            public <T> void onLinkedSettingsControlUpdated(Setting<T> sourceSetting, T currentControlValue) {
                for (SettingComponents settingComponents : allComponents) {
                    settingComponents.onLinkedSettingsControlUpdated(sourceSetting, currentControlValue);
                }
            }
        };
        for (Setting<?> setting : settingsGroup.getSettings().values()) {
            SettingComponents settingComponents = SettingsPanelFactory.from(setting, listener);
            setting.getEnabledCondition().ifPresent(settingComponents::setEnabledWhen);
            allComponents.add(settingComponents);
            this.map.put(setting.getKey(), settingComponents);
            labelPanel.add(settingComponents.getLabel());
            controlsPanel.add(settingComponents.getControl());
            this.applyActions.add(transaction -> settingComponents.getControl().applyValue((SettingsTransaction)transaction));
        }
    }

    public void applyAll() {
        new SettingsTransaction().execute(this.applyActions);
    }

    public void applyAllAsDefault() {
        this.settingsGroup.applyAllAsDefault();
    }

    public SettingComponents getComponents(Key key) {
        return this.map.get((Object)key);
    }
}

