/*
 * Decompiled with CFR 0.152.
 */
package org.xdat.gui.panels;

import java.awt.LayoutManager;
import java.util.Objects;
import javax.swing.JPanel;
import org.jetbrains.annotations.Nullable;
import org.xdat.gui.panels.EnabledCondition;
import org.xdat.settings.Setting;
import org.xdat.settings.SettingsTransaction;

public abstract class SettingControlPanel<K>
extends JPanel {
    @Nullable
    private EnabledCondition<?, K> enabledCondition = null;

    public SettingControlPanel(LayoutManager layoutManager, boolean b) {
        super(layoutManager, b);
    }

    public SettingControlPanel(LayoutManager layoutManager) {
        super(layoutManager);
    }

    public SettingControlPanel(boolean b) {
        super(b);
    }

    public SettingControlPanel() {
    }

    public abstract boolean applyValue(SettingsTransaction var1);

    @Override
    public abstract void setEnabled(boolean var1);

    public <T> void onLinkedSettingsControlUpdated(Setting<T> sourceSetting, T currentControlValue) {
        this.checkEnabled(sourceSetting, currentControlValue);
    }

    private <T> void checkEnabled(Setting<T> sourceSetting, T currentValue) {
        if (this.enabledCondition == null) {
            return;
        }
        if (Objects.equals(sourceSetting.getUniqueId(), this.enabledCondition.getEnablingSetting().getUniqueId())) {
            boolean enabled = Objects.equals(this.enabledCondition.getEnablingValue(), currentValue);
            this.setEnabled(enabled);
            if (!enabled) {
                this.setCurrentValue(this.enabledCondition.getDisabledValue());
            }
        }
    }

    protected abstract void setCurrentValue(K var1);

    public <T> void setEnabledWhen(EnabledCondition<T, K> enabledCondition) {
        this.enabledCondition = enabledCondition;
        enabledCondition.getEnablingSetting().addListener((source, transaction) -> this.checkEnabled(source, source.get()));
        this.checkEnabled(enabledCondition.getEnablingSetting(), enabledCondition.getEnablingSetting().get());
    }
}

