/*
 * Decompiled with CFR 0.152.
 */
package org.xdat.gui.panels;

import java.awt.Color;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.geom.AffineTransform;
import org.jetbrains.annotations.Nullable;
import org.xdat.Main;
import org.xdat.chart.ParallelCoordinatesChart;
import org.xdat.chart.ScatterChart2D;
import org.xdat.chart.ScatterPlot2D;
import org.xdat.data.AxisType;
import org.xdat.data.Cluster;
import org.xdat.data.DataSheet;
import org.xdat.data.Design;
import org.xdat.data.Parameter;
import org.xdat.gui.panels.ChartPanel;

public class ScatterChart2DPanel
extends ChartPanel {
    static final long serialVersionUID = 1L;
    private final Main mainWindow;
    private int yAxisOffset = 0;

    public ScatterChart2DPanel(Main mainWindow, ScatterChart2D chart) {
        super(chart);
        this.mainWindow = mainWindow;
    }

    @Override
    public void paintComponent(Graphics g) {
        super.paintComponent(g);
        ScatterChart2D chart = (ScatterChart2D)this.getChart();
        ScatterPlot2D plot = chart.getScatterPlot2D();
        if (chart.getScatterPlot2D().isShowDecorations()) {
            g.setFont(new Font("SansSerif", 0, plot.getTicLabelFontSize(AxisType.Y)));
            this.yAxisOffset = plot.getParameterForAxis(AxisType.Y).getLongestTicLabelStringLength(g.getFontMetrics(), "%4.3f", this.mainWindow.getDataSheet());
        }
        if (this.mainWindow.getDataSheet().getParameterCount() > 0) {
            if (!this.mainWindow.getDataSheet().parameterExists(chart.getScatterPlot2D().getParameterForAxis(AxisType.X))) {
                chart.getScatterPlot2D().setParameterForAxis(AxisType.X, this.mainWindow.getDataSheet().getParameter(0));
            }
            if (!this.mainWindow.getDataSheet().parameterExists(chart.getScatterPlot2D().getParameterForAxis(AxisType.Y))) {
                chart.getScatterPlot2D().setParameterForAxis(AxisType.Y, this.mainWindow.getDataSheet().getParameter(0));
            }
            this.drawDesigns(g, chart);
        }
        if (chart.getScatterPlot2D().isShowDecorations()) {
            this.drawAxes(g, chart, plot);
        }
    }

    public void drawDesigns(Graphics g, ScatterChart2D chart) {
        int delta;
        int i;
        ScatterPlot2D plot = chart.getScatterPlot2D();
        Parameter paramX = plot.getParameterForAxis(AxisType.X);
        Parameter paramY = plot.getParameterForAxis(AxisType.Y);
        if (paramX == null || paramY == null) {
            return;
        }
        DataSheet dataSheet = chart.getDataSheet();
        double[] xValues = new double[dataSheet.getDesignCount()];
        double[] yValues = new double[dataSheet.getDesignCount()];
        double minX = chart.getScatterPlot2D().getMin(AxisType.X);
        double maxX = chart.getScatterPlot2D().getMax(AxisType.X);
        double minY = chart.getScatterPlot2D().getMin(AxisType.Y);
        double maxY = chart.getScatterPlot2D().getMax(AxisType.Y);
        boolean useAlpha = chart.isUseAlpha();
        for (i = 0; i < dataSheet.getDesignCount(); ++i) {
            xValues[i] = dataSheet.getDesign(i).getDoubleValue(paramX);
            yValues[i] = dataSheet.getDesign(i).getDoubleValue(paramY);
        }
        if (chart.isAutoFit(AxisType.X)) {
            minX = Double.POSITIVE_INFINITY;
            maxX = Double.NEGATIVE_INFINITY;
            for (i = 0; i < dataSheet.getDesignCount(); ++i) {
                xValues[i] = dataSheet.getDesign(i).getDoubleValue(paramX);
                if (xValues[i] > maxX) {
                    maxX = xValues[i];
                }
                if (!(xValues[i] < minX)) continue;
                minX = xValues[i];
            }
            chart.getScatterPlot2D().setMax(AxisType.X, maxX);
            chart.getScatterPlot2D().setMin(AxisType.X, minX);
        }
        if (chart.isAutoFit(AxisType.Y)) {
            minY = Double.POSITIVE_INFINITY;
            maxY = Double.NEGATIVE_INFINITY;
            for (i = 0; i < dataSheet.getDesignCount(); ++i) {
                yValues[i] = dataSheet.getDesign(i).getDoubleValue(paramY);
                if (yValues[i] > maxY) {
                    maxY = yValues[i];
                }
                if (!(yValues[i] < minY)) continue;
                minY = yValues[i];
            }
            chart.getScatterPlot2D().setMax(AxisType.Y, maxY);
            chart.getScatterPlot2D().setMin(AxisType.Y, minY);
        }
        double xRange = maxX - minX;
        double yRange = maxY - minY;
        int plotWidth = chart.getWidth() - chart.getScatterPlot2D().getPlotAreaDistanceToLeft(this.yAxisOffset) - chart.getScatterPlot2D().getPlotAreaDistanceToRight();
        int plotHeight = chart.getHeight() - chart.getScatterPlot2D().getPlotAreaDistanceToTop() - chart.getScatterPlot2D().getPlotAreaDistanceToBottom();
        int xOrig = chart.getScatterPlot2D().getPlotAreaDistanceToLeft(this.yAxisOffset) - chart.getScatterPlot2D().getDotRadius();
        int yOrig = chart.getHeight() - chart.getScatterPlot2D().getPlotAreaDistanceToBottom() - chart.getScatterPlot2D().getDotRadius();
        if (!paramX.isNumeric()) {
            delta = (int)(0.5 * (double)plotWidth / (double)(paramX.getDiscreteLevelCount() + 1));
            plotWidth -= 2 * delta;
            xOrig += delta;
        }
        if (!paramY.isNumeric()) {
            delta = (int)(0.5 * (double)plotHeight / (double)(paramY.getDiscreteLevelCount() + 1));
            plotHeight -= 2 * delta;
            yOrig -= delta;
        }
        int ovalDiameter = 2 * chart.getScatterPlot2D().getDotRadius();
        boolean isXConstant = xRange == 0.0;
        int constantX = (int)((double)xOrig + 0.5 * (double)plotWidth);
        boolean isYConstant = yRange == 0.0;
        int constantY = (int)((double)yOrig - 0.5 * (double)plotHeight);
        switch (chart.getScatterPlot2D().getDisplayedDesignSelectionMode()) {
            case 2: {
                @Nullable ParallelCoordinatesChart parallelChart = chart.getScatterPlot2D().getParallelCoordinatesChartForFiltering();
                if (parallelChart != null) {
                    Color activeDesignColor = parallelChart.getActiveDesignColor();
                    Color activeDesignColorNoAlpha = parallelChart.getActiveDesignColorNoAlpha();
                    Color filteredDesignColor = parallelChart.getFilteredDesignColor();
                    Color filteredDesignColorNoAlpha = parallelChart.getFilteredDesignColorNoAlpha();
                    for (int i2 = 0; i2 < dataSheet.getDesignCount(); ++i2) {
                        Design design = dataSheet.getDesign(i2);
                        @Nullable Cluster cluster = design.getCluster();
                        if (cluster != null && !cluster.isActive() || !design.isActive(parallelChart)) continue;
                        int x = xOrig + (int)((xValues[i2] - minX) * (double)plotWidth / xRange);
                        int y = yOrig - (int)((yValues[i2] - minY) * (double)plotHeight / yRange);
                        if (isXConstant) {
                            x = constantX;
                        }
                        if (isYConstant) {
                            y = constantY;
                        }
                        if (design.isSelected()) {
                            g.setColor(chart.getScatterPlot2D().getSelectedDesignColor());
                        } else if (design.hasGradientColor()) {
                            g.setColor(parallelChart.getDesignColor(design, true, useAlpha, activeDesignColor, activeDesignColorNoAlpha, filteredDesignColor, filteredDesignColorNoAlpha));
                        } else {
                            g.setColor(chart.getScatterPlot2D().getDesignColor(design));
                        }
                        g.fillOval(x, y, ovalDiameter, ovalDiameter);
                    }
                    break;
                }
            }
            case 0: {
                for (int i3 = 0; i3 < dataSheet.getDesignCount(); ++i3) {
                    Design design = dataSheet.getDesign(i3);
                    Cluster cluster = design.getCluster();
                    if (cluster != null && !cluster.isActive()) continue;
                    int x = xOrig + (int)((xValues[i3] - minX) * (double)plotWidth / xRange);
                    int y = yOrig - (int)((yValues[i3] - minY) * (double)plotHeight / yRange);
                    if (isXConstant) {
                        x = constantX;
                    }
                    if (isYConstant) {
                        y = constantY;
                    }
                    g.setColor(chart.getScatterPlot2D().getDesignColor(dataSheet.getDesign(i3)));
                    if (dataSheet.getDesign(i3).isSelected()) {
                        g.setColor(chart.getScatterPlot2D().getSelectedDesignColor());
                    } else {
                        g.setColor(chart.getScatterPlot2D().getDesignColor(dataSheet.getDesign(i3)));
                    }
                    g.fillOval(x, y, ovalDiameter, ovalDiameter);
                }
                break;
            }
            case 1: {
                for (int i4 = 0; i4 < dataSheet.getDesignCount(); ++i4) {
                    if (!dataSheet.getDesign(i4).isSelected()) continue;
                    int x = xOrig + (int)((xValues[i4] - minX) * (double)plotWidth / xRange);
                    int y = yOrig - (int)((yValues[i4] - minY) * (double)plotHeight / yRange);
                    if (isXConstant) {
                        x = constantX;
                    }
                    if (isYConstant) {
                        y = constantY;
                    }
                    g.setColor(chart.getScatterPlot2D().getDesignColor(dataSheet.getDesign(i4)));
                    g.fillOval(x, y, ovalDiameter, ovalDiameter);
                }
                break;
            }
        }
    }

    public void drawAxes(Graphics g, ScatterChart2D chart, ScatterPlot2D plot) {
        g.setColor(chart.getBackGroundColor());
        g.fillRect(0, 0, chart.getWidth(), plot.getPlotAreaDistanceToTop());
        g.fillRect(0, 0, plot.getPlotAreaDistanceToLeft(this.yAxisOffset), chart.getHeight());
        g.fillRect(0, chart.getHeight() - plot.getPlotAreaDistanceToBottom(), chart.getWidth(), chart.getHeight());
        g.fillRect(chart.getWidth() - plot.getPlotAreaDistanceToRight(), 0, plot.getPlotAreaDistanceToRight(), chart.getHeight());
        g.setColor(plot.getDecorationsColor());
        int x1 = plot.getPlotAreaDistanceToLeft(this.yAxisOffset);
        int y1 = chart.getHeight() - plot.getPlotAreaDistanceToBottom();
        int x2 = plot.getPlotAreaDistanceToLeft(this.yAxisOffset);
        int y2 = plot.getPlotAreaDistanceToTop();
        g.drawLine(x1, y1, x2, y2);
        if (!plot.getParameterForAxis(AxisType.Y).isNumeric()) {
            int delta = (int)(0.5 * (double)(y1 - y2) / (double)(plot.getParameterForAxis(AxisType.Y).getDiscreteLevelCount() + 1));
            y1 -= delta;
            y2 += delta;
        }
        int ticCountY = plot.getParameterForAxis(AxisType.Y).isNumeric() ? (plot.getMin(AxisType.Y) == plot.getMax(AxisType.Y) ? 1 : plot.getTicCount(AxisType.Y)) : plot.getParameterForAxis(AxisType.Y).getDiscreteLevelCount();
        g.setFont(new Font("SansSerif", 0, plot.getTicLabelFontSize(AxisType.Y)));
        if (ticCountY == 1) {
            int y = (int)(0.5 * (double)(y2 + y1));
            g.drawLine(x2, (int)(0.5 * (double)(y2 + y1)), x2 + plot.getTicSize(), y);
            String label = this.getTicLabel(AxisType.Y, plot, 0);
            int xOffset = g.getFontMetrics().stringWidth(label);
            g.drawString(label, x2 - xOffset - 10, y + (int)(0.5 * (double)plot.getTicLabelFontSize(AxisType.Y)));
        } else {
            int ticSpacingY = (int)((float)(y1 - y2) / (float)(ticCountY - 1));
            for (int i = 0; i < ticCountY; ++i) {
                int ticY = y1 - i * ticSpacingY;
                g.drawLine(x2, ticY, x2 + plot.getTicSize(), ticY);
                String label = this.getTicLabel(AxisType.Y, plot, i);
                int xOffset = g.getFontMetrics().stringWidth(label);
                g.drawString(label, x2 - xOffset - 10, ticY + (int)(0.5 * (double)plot.getTicLabelFontSize(AxisType.Y)));
            }
        }
        x1 = plot.getPlotAreaDistanceToLeft(this.yAxisOffset);
        y1 = chart.getHeight() - plot.getPlotAreaDistanceToBottom();
        x2 = chart.getWidth() - plot.getPlotAreaDistanceToRight();
        y2 = chart.getHeight() - plot.getPlotAreaDistanceToBottom();
        g.drawLine(x1, y1, x2, y2);
        if (!plot.getParameterForAxis(AxisType.X).isNumeric()) {
            int delta = (int)(0.5 * (double)(x2 - x1) / (double)(plot.getParameterForAxis(AxisType.X).getDiscreteLevelCount() + 1));
            x1 += delta;
            x2 -= delta;
        }
        int ticCountX = plot.getParameterForAxis(AxisType.X).isNumeric() ? (plot.getMin(AxisType.X) == plot.getMax(AxisType.X) ? 1 : plot.getTicCount(AxisType.X)) : plot.getParameterForAxis(AxisType.X).getDiscreteLevelCount();
        g.setFont(new Font("SansSerif", 0, plot.getTicLabelFontSize(AxisType.X)));
        if (ticCountX == 1) {
            int x = (int)(0.5 * (double)(x1 + x2));
            g.drawLine(x, y2, x, y2 - plot.getTicSize());
            String label = this.getTicLabel(AxisType.X, plot, 0);
            int xOffset = (int)(0.5 * (double)g.getFontMetrics().stringWidth(label));
            g.drawString(label, x - xOffset, y2 + 10 + plot.getTicLabelFontSize(AxisType.X));
        } else {
            int ticSpacingX = (int)((float)(x2 - x1) / (float)(ticCountX - 1));
            for (int i = 0; i < ticCountX; ++i) {
                int ticX = x1 + i * ticSpacingX;
                g.drawLine(ticX, y2, ticX, y2 - plot.getTicSize());
                String label = this.getTicLabel(AxisType.X, plot, i);
                int xOffset = (int)(0.5 * (double)g.getFontMetrics().stringWidth(label));
                g.drawString(label, ticX - xOffset, y2 + 10 + plot.getTicLabelFontSize(AxisType.X));
            }
        }
        String xParameterName = "";
        if (plot.getParameterForAxis(AxisType.X) != null) {
            xParameterName = plot.getParameterForAxis(AxisType.X).getName();
        }
        g.setFont(new Font("SansSerif", 0, plot.getAxisLabelFontSize(AxisType.X)));
        int slenX = g.getFontMetrics().stringWidth(xParameterName);
        g.drawString(xParameterName, (chart.getWidth() - slenX) / 2, chart.getHeight() - plot.getMargin() - 10);
        String yParameterName = "";
        if (plot.getParameterForAxis(AxisType.Y) != null) {
            yParameterName = plot.getParameterForAxis(AxisType.Y).getName();
        }
        g.setFont(new Font("SansSerif", 0, plot.getAxisLabelFontSize(AxisType.Y)));
        int slenY = g.getFontMetrics().stringWidth(yParameterName);
        Graphics2D g2D = (Graphics2D)g;
        AffineTransform fontAT = new AffineTransform();
        Font origFont = g2D.getFont();
        fontAT.rotate(-1.5707963267948966);
        Font theDerivedFont = origFont.deriveFont(fontAT);
        g2D.setFont(theDerivedFont);
        g2D.drawString(yParameterName, plot.getMargin() + 10 + plot.getAxisLabelFontSize(AxisType.Y), (chart.getHeight() + slenY) / 2);
        g2D.setFont(origFont);
    }

    private String getTicLabel(AxisType axisType, ScatterPlot2D plot, int ticIndex) {
        double value = plot.getMin(axisType) + (double)ticIndex * (plot.getMax(axisType) - plot.getMin(axisType)) / (double)(plot.getTicCount(axisType) - 1);
        Parameter parameterForAxis = plot.getParameterForAxis(axisType);
        if (parameterForAxis.isNumeric()) {
            return String.format(parameterForAxis.getTicLabelFormat(), value);
        }
        return parameterForAxis.getStringValueOf(ticIndex);
    }
}

