/*
 * Decompiled with CFR 0.152.
 */
package org.xdat.gui.panels;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.GridLayout;
import java.util.Vector;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSpinner;
import javax.swing.JTextField;
import org.xdat.Main;
import org.xdat.actionListeners.scatter2DChartSettings.Scatter2DChartAxisPanelActionListener;
import org.xdat.chart.ScatterChart2D;
import org.xdat.data.AxisType;
import org.xdat.data.Parameter;
import org.xdat.gui.controls.MinMaxSpinnerModel;
import org.xdat.gui.controls.RightAlignedSpinner;
import org.xdat.gui.frames.ChartFrame;
import org.xdat.gui.panels.SettingComponents;
import org.xdat.gui.panels.SettingsPanelFactory;
import org.xdat.gui.panels.TitledSubPanel;
import org.xdat.settings.Key;
import org.xdat.settings.SettingsGroup;

public class Scatter2DChartAxisPanel
extends JPanel {
    private final SettingsGroup settings;
    private final AxisType axisType;
    private final ScatterChart2D chart;
    private final JTextField axisMinTextField = new JTextField();
    private final JTextField axisMaxTextField = new JTextField();
    private final JSpinner ticCountSpinner = new RightAlignedSpinner(new MinMaxSpinnerModel(1, 500));
    private final JSpinner ticLabelDigitCountSpinner;
    private final JSpinner axisLabelFontSizeSpinner;
    private final JSpinner ticLabelFontSizeSpinner;
    private boolean updating = false;
    private final SettingComponents autoFitComp;

    public Scatter2DChartAxisPanel(Main mainWindow, ChartFrame chartFrame, ScatterChart2D chart, AxisType axisType) {
        this.chart = chart;
        this.axisType = axisType;
        this.settings = chart.getAxisSettings(axisType);
        Scatter2DChartAxisPanelActionListener cmd = new Scatter2DChartAxisPanelActionListener(mainWindow, chartFrame, chart, axisType);
        String title = axisType.getLabel();
        String selectedParam = chart.getScatterPlot2D().getParameterForAxis(axisType).getName();
        TitledSubPanel mainPanel = new TitledSubPanel(title);
        this.setLayout(new GridLayout(1, 1));
        this.add(mainPanel);
        mainPanel.setLayout(new BorderLayout());
        Vector<Parameter> parametersList = new Vector<Parameter>(mainWindow.getDataSheet().getParameters());
        JList<Parameter> parameterSelectionList = new JList<Parameter>(parametersList);
        parameterSelectionList.setVisibleRowCount(6);
        parameterSelectionList.setAutoscrolls(true);
        parameterSelectionList.setSelectionMode(0);
        parameterSelectionList.setSelectedValue(selectedParam, true);
        parameterSelectionList.addListSelectionListener(listSelectionEvent -> {
            Parameter selectedValue = (Parameter)parameterSelectionList.getSelectedValue();
            if (selectedValue != null) {
                chart.getScatterPlot2D().setParameterForAxis(axisType, selectedValue);
                this.currentParameterChanged();
                chartFrame.repaint();
            }
        });
        JScrollPane scrollPane = new JScrollPane(parameterSelectionList, 20, 30);
        mainPanel.add((Component)scrollPane, "North");
        this.autoFitComp = SettingsPanelFactory.standaloneFrom(this.settings.getBooleanSetting(Key.getScatterChartAutoFitAxis(axisType)));
        JPanel otherControlsPanel = new JPanel(new BorderLayout());
        JPanel labelPanel = new JPanel(new GridLayout(0, 1));
        JPanel controlsPanel = new JPanel(new GridLayout(0, 1));
        otherControlsPanel.add((Component)labelPanel, "West");
        otherControlsPanel.add((Component)controlsPanel, "Center");
        mainPanel.add((Component)otherControlsPanel, "Center");
        JComponent autoFitAxisLabel = this.autoFitComp.getLabel();
        JLabel axisMinLabel = new JLabel("Axis minimum   ");
        JLabel axisMaxLabel = new JLabel("Axis maximum   ");
        JLabel axisLabelFontSizeLabel = new JLabel("Axis Title Fontsize  ");
        JLabel nrOfTicsLabel = new JLabel("Number of Tics  ");
        JLabel ticLabelFontSizeLabel = new JLabel("Tic Label Font Size  ");
        JLabel ticLabelDigitCountLabel = new JLabel("Tic Label Digit Count  ");
        labelPanel.add(autoFitAxisLabel);
        labelPanel.add(axisMinLabel);
        labelPanel.add(axisMaxLabel);
        labelPanel.add(axisLabelFontSizeLabel);
        labelPanel.add(nrOfTicsLabel);
        labelPanel.add(ticLabelFontSizeLabel);
        labelPanel.add(ticLabelDigitCountLabel);
        this.axisLabelFontSizeSpinner = new RightAlignedSpinner(new MinMaxSpinnerModel(0, 100));
        this.axisLabelFontSizeSpinner.addChangeListener(changeEvent -> {
            if (this.updating) {
                return;
            }
            cmd.axisLabelFontsizeUpdated((Integer)this.axisLabelFontSizeSpinner.getValue());
        });
        this.ticCountSpinner.addChangeListener(changeEvent -> {
            if (this.updating) {
                return;
            }
            cmd.ticCountUpdated((Integer)this.ticCountSpinner.getValue());
        });
        this.ticLabelFontSizeSpinner = new RightAlignedSpinner(new MinMaxSpinnerModel(0, 100));
        this.ticLabelFontSizeSpinner.addChangeListener(changeEvent -> {
            if (this.updating) {
                return;
            }
            cmd.ticLabelFontsizeUpdated((Integer)this.ticLabelFontSizeSpinner.getValue());
        });
        this.ticLabelDigitCountSpinner = new RightAlignedSpinner(new MinMaxSpinnerModel(0, 20));
        controlsPanel.add(this.autoFitComp.getControl());
        controlsPanel.add(this.axisMinTextField);
        controlsPanel.add(this.axisMaxTextField);
        controlsPanel.add(this.axisLabelFontSizeSpinner);
        controlsPanel.add(this.ticCountSpinner);
        controlsPanel.add(this.ticLabelFontSizeSpinner);
        controlsPanel.add(this.ticLabelDigitCountSpinner);
        this.settings.getBooleanSetting(Key.getScatterChartAutoFitAxis(axisType)).addListener((source, transaction) -> {
            if (this.updating) {
                return;
            }
            boolean newState = (Boolean)source.get();
            this.updating = true;
            this.updateMinMaxFields();
            this.updating = false;
            if (newState) {
                this.chart.getScatterPlot2D().autofit(mainWindow.getDataSheet(), this.axisType);
            }
        });
        this.axisMinTextField.addActionListener(e -> {
            if (this.updating) {
                return;
            }
            cmd.minTextFieldUpdated(e);
        });
        this.axisMaxTextField.addActionListener(e -> {
            if (this.updating) {
                return;
            }
            cmd.maxTextFieldUpdated(e);
        });
        this.ticLabelDigitCountSpinner.addChangeListener(changeEvent -> {
            if (this.updating) {
                return;
            }
            cmd.ticLabelDigitCountUpdated((Integer)this.ticLabelDigitCountSpinner.getValue());
        });
        this.currentParameterChanged();
    }

    private void updateMinMaxFields() {
        boolean autoFit = this.settings.getBoolean(Key.getScatterChartAutoFitAxis(this.axisType));
        boolean numeric = this.chart.getScatterPlot2D().getParameterForAxis(this.axisType).isNumeric();
        this.axisMaxTextField.setEnabled(!autoFit && numeric);
        this.axisMinTextField.setEnabled(!autoFit && numeric);
        this.axisMaxTextField.setText(Double.toString(this.chart.getScatterPlot2D().getMax(this.axisType)));
        this.axisMinTextField.setText(Double.toString(this.chart.getScatterPlot2D().getMin(this.axisType)));
    }

    private void currentParameterChanged() {
        this.updating = true;
        Parameter parameter = this.chart.getScatterPlot2D().getParameterForAxis(this.axisType);
        boolean numeric = parameter.isNumeric();
        if (parameter.isNumeric()) {
            this.ticLabelDigitCountSpinner.setValue(parameter.getTicLabelDigitCount());
            this.ticLabelDigitCountSpinner.setEnabled(true);
        } else {
            this.ticLabelDigitCountSpinner.setValue(0);
            this.ticLabelDigitCountSpinner.setEnabled(false);
        }
        this.ticCountSpinner.setEnabled(numeric);
        this.ticCountSpinner.setValue(numeric ? this.chart.getScatterPlot2D().getTicCount(this.axisType) : 0);
        this.axisLabelFontSizeSpinner.setValue(this.chart.getScatterPlot2D().getAxisLabelFontSize(this.axisType));
        this.ticLabelFontSizeSpinner.setValue(this.chart.getScatterPlot2D().getTicLabelFontSize(this.axisType));
        this.updateMinMaxFields();
        this.autoFitComp.getControl().setEnabled(numeric);
        this.updating = false;
    }
}

