/*
 * Decompiled with CFR 0.152.
 */
package org.xdat.gui.panels;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.GridLayout;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Objects;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSlider;
import javax.swing.JTextField;
import org.jetbrains.annotations.Nullable;
import org.xdat.Main;
import org.xdat.actionListeners.chartFrames.ParallelChartSidebarActionListener;
import org.xdat.chart.ParallelCoordinatesChart;
import org.xdat.data.Cluster;
import org.xdat.data.ClusterListener;
import org.xdat.data.ClusterSet;
import org.xdat.gui.controls.ColorChoiceButton;
import org.xdat.gui.frames.ChartFrame;
import org.xdat.gui.panels.ChartPanel;
import org.xdat.gui.panels.ParallelCoordinatesChartPanel;
import org.xdat.gui.panels.SidebarPanel;
import org.xdat.settings.Key;

public class ParallelCoordinatesChartSidebarPanel
extends SidebarPanel {
    private static final Color CLUSTER_NAME_TEXT_FIELD_EDITING_COLOR = new Color(255, 205, 51);
    private static final Color CLUSTER_NAME_TEXT_FIELD_STANDARD_COLOR = new Color(230, 230, 230);
    private ParallelChartSidebarActionListener cmd;
    private ColorChoiceButton activeDesignColorButton;
    private JSlider activeDesignAlphaSlider;
    private JScrollPane clusterScrollPane;
    private JPanel clusterPanel;
    private Map<Cluster, JSlider> clusterAlphaSliders;
    private Map<Cluster, ClusterListener> clustersToListeners;
    private final Runnable closeHook;

    public ParallelCoordinatesChartSidebarPanel(Main mainWindow, ChartFrame chartFrame, ChartPanel chartPanel, ParallelCoordinatesChart chart) {
        super(mainWindow, chartFrame, chartPanel, chart);
        ClusterListener dispatchingClusterListener = new ClusterListener(){

            @Override
            public void onNameChanged(Cluster source) {
                @Nullable ClusterListener l = (ClusterListener)ParallelCoordinatesChartSidebarPanel.this.clustersToListeners.get(source);
                if (l != null) {
                    l.onNameChanged(source);
                }
            }

            @Override
            public void onColorChanged(Cluster source) {
                @Nullable ClusterListener l = (ClusterListener)ParallelCoordinatesChartSidebarPanel.this.clustersToListeners.get(source);
                if (l != null) {
                    l.onColorChanged(source);
                }
            }
        };
        mainWindow.getCurrentClusterSet().addClusterListener(dispatchingClusterListener);
        this.closeHook = () -> mainWindow.getCurrentClusterSet().removeClusterListener(dispatchingClusterListener);
    }

    @Override
    protected void buildPanel(JPanel parentPanel) {
        ParallelCoordinatesChart chart = (ParallelCoordinatesChart)this.getChart();
        parentPanel.setLayout(new BorderLayout());
        JPanel generalControlsPanel = new JPanel(new FlowLayout(3));
        generalControlsPanel.setPreferredSize(new Dimension(195, 140));
        parentPanel.add((Component)generalControlsPanel, "North");
        JPanel activeDesignColorButtonPanel = new JPanel(new FlowLayout(1));
        JLabel activeDesignColorLabel = new JLabel("Active Design Color");
        activeDesignColorButtonPanel.add(activeDesignColorLabel);
        this.activeDesignColorButton = new ColorChoiceButton(chart.getDefaultDesignColor(true, chart.isUseAlpha()), "Active Design Color");
        this.activeDesignColorButton.addActionListener(e -> this.cmd.changeActiveDesignColor(chart));
        activeDesignColorButtonPanel.add(this.activeDesignColorButton);
        chart.getChartSettingsGroup().getColorSetting(Key.ACTIVE_DESIGN_DEFAULT_COLOR).addListener((source, transaction) -> this.activeDesignColorButton.setCurrentColor((Color)source.get()));
        generalControlsPanel.add(activeDesignColorButtonPanel);
        JPanel activeDesignAlphaSliderLabelPanel = new JPanel(new FlowLayout(1));
        JPanel activeDesignAlphaSliderPanel = new JPanel(new FlowLayout(1));
        activeDesignAlphaSliderLabelPanel.setPreferredSize(new Dimension(180, 20));
        activeDesignAlphaSliderPanel.setPreferredSize(new Dimension(180, 30));
        generalControlsPanel.add(activeDesignAlphaSliderLabelPanel);
        generalControlsPanel.add(activeDesignAlphaSliderPanel);
        JLabel activeDesignAlphaLabel = new JLabel("Transparency");
        activeDesignAlphaSliderLabelPanel.add(activeDesignAlphaLabel);
        this.activeDesignAlphaSlider = new JSlider(0, 0, 255, 0);
        this.activeDesignAlphaSlider.addChangeListener(e -> this.cmd.setActiveDesignColorAlpha(this.activeDesignAlphaSlider, chart));
        this.activeDesignAlphaSlider.setName("activeDesignAlphaSlider");
        this.activeDesignAlphaSlider.setPreferredSize(new Dimension(120, 30));
        chart.getChartSettingsGroup().getBooleanSetting(Key.USE_ALPHA).addListener((source, transaction) -> {
            boolean enabled = (Boolean)source.get();
            this.setAlphaSlidersEnabled(enabled);
            chart.setUseAlpha(enabled);
        });
        activeDesignAlphaSliderPanel.add(this.activeDesignAlphaSlider);
        JPanel addClusterButtonPanel = new JPanel(new FlowLayout(1));
        addClusterButtonPanel.setPreferredSize(new Dimension(180, 35));
        JButton newClusterButton = new JButton("Add Cluster");
        newClusterButton.addActionListener(e -> this.cmd.addCluster());
        addClusterButtonPanel.add(newClusterButton);
        generalControlsPanel.add(addClusterButtonPanel);
        parentPanel.add((Component)this.clusterScrollPane, "Center");
        JPanel contentPanel = new JPanel(new FlowLayout(4));
        this.clusterScrollPane.setViewportView(contentPanel);
        this.clusterPanel = new JPanel(new GridLayout(0, 1));
        contentPanel.add(this.clusterPanel);
        this.activeDesignColorButton.setCurrentColor(chart.getDefaultDesignColor(true, chart.isUseAlpha()));
        if (chart.isUseAlpha()) {
            this.activeDesignAlphaSlider.setValue(chart.getDefaultDesignColor(true, chart.isUseAlpha()).getAlpha());
        } else {
            this.activeDesignAlphaSlider.setValue(255);
            this.activeDesignAlphaSlider.setEnabled(false);
        }
        this.linkColorButtonToSlider(this.activeDesignColorButton, this.activeDesignAlphaSlider);
        this.updateClusterList(this.getMainWindow().getCurrentClusterSet());
        this.validate();
    }

    public ColorChoiceButton getActiveDesignColorButton() {
        return this.activeDesignColorButton;
    }

    public JSlider getActiveDesignAlphaSlider() {
        return this.activeDesignAlphaSlider;
    }

    public JSlider getClusterAlphaSlider(Cluster cluster) {
        if (this.clusterAlphaSliders.containsKey(cluster)) {
            return this.clusterAlphaSliders.get(cluster);
        }
        return null;
    }

    public void updateClusterList(ClusterSet clusterSet) {
        int clusterCount = clusterSet.getClusterCount();
        this.clusterPanel.removeAll();
        this.clusterPanel.setLayout(new GridLayout(clusterCount, 1));
        this.clusterAlphaSliders.clear();
        for (int i = 0; i < clusterCount; ++i) {
            final Cluster cluster = clusterSet.getCluster(i);
            JPanel wrapperPanel = new JPanel(new GridLayout(5, 1));
            final JTextField clusterNameTextField = new JTextField();
            clusterNameTextField.setEditable(true);
            clusterNameTextField.setBackground(CLUSTER_NAME_TEXT_FIELD_STANDARD_COLOR);
            clusterNameTextField.setToolTipText("Click to edit cluster name");
            clusterNameTextField.addActionListener(event -> this.handleUpdatedClusterName(clusterNameTextField, cluster, event.getActionCommand()));
            clusterNameTextField.addFocusListener(new FocusListener(){

                @Override
                public void focusLost(FocusEvent arg0) {
                    clusterNameTextField.setBackground(CLUSTER_NAME_TEXT_FIELD_STANDARD_COLOR);
                    clusterNameTextField.setToolTipText("Click to edit cluster name");
                    ParallelCoordinatesChartSidebarPanel.this.handleUpdatedClusterName(clusterNameTextField, cluster, clusterNameTextField.getText());
                }

                @Override
                public void focusGained(FocusEvent arg0) {
                    clusterNameTextField.setBackground(CLUSTER_NAME_TEXT_FIELD_EDITING_COLOR);
                    clusterNameTextField.setToolTipText(null);
                }
            });
            wrapperPanel.add(clusterNameTextField);
            JPanel clusterButtonPanel = new JPanel(new BorderLayout());
            wrapperPanel.add(clusterButtonPanel);
            final ColorChoiceButton clusterColorButton = new ColorChoiceButton(cluster.getActiveDesignColor(true), "clusterColor", 20, 25);
            clusterColorButton.addActionListener(e -> this.cmd.changeClusterColor(clusterColorButton, cluster));
            clusterButtonPanel.add((Component)clusterColorButton, "West");
            final JButton removeClusterButton = new JButton("Remove");
            removeClusterButton.addActionListener(e -> this.cmd.removeCluster(cluster));
            clusterButtonPanel.add((Component)removeClusterButton, "Center");
            final JButton applyClusterButton = new JButton("Add Designs");
            applyClusterButton.setToolTipText("Add all currently filtered designs to cluster " + cluster.getName());
            applyClusterButton.addActionListener(e -> this.cmd.applySettings((ParallelCoordinatesChart)this.getChart(), cluster));
            clusterButtonPanel.add((Component)applyClusterButton, "East");
            JLabel clusterAlphaLabel = new JLabel("Transparency");
            wrapperPanel.add(clusterAlphaLabel);
            final JSlider clusterAlphaSlider = new JSlider(0, 0, 255, cluster.getActiveDesignColor(true).getAlpha());
            this.clusterAlphaSliders.put(cluster, clusterAlphaSlider);
            clusterAlphaSlider.setPreferredSize(new Dimension(150, 10));
            clusterAlphaSlider.addChangeListener(e -> this.cmd.setClusterAlpha(clusterAlphaSlider, cluster));
            wrapperPanel.add(clusterAlphaSlider);
            this.linkColorButtonToSlider(clusterColorButton, clusterAlphaSlider);
            final JCheckBox clusterActiveCheckbox = new JCheckBox("Active");
            clusterActiveCheckbox.addActionListener(e -> this.cmd.toggleClusterActive(clusterActiveCheckbox, cluster));
            clusterActiveCheckbox.setSelected(cluster.isActive());
            wrapperPanel.add(clusterActiveCheckbox);
            this.updateElementNames(cluster.getName(), clusterNameTextField, clusterColorButton, removeClusterButton, applyClusterButton, clusterAlphaSlider, clusterActiveCheckbox);
            this.clustersToListeners.put(cluster, new ClusterListener(){

                @Override
                public void onNameChanged(Cluster source) {
                    ParallelCoordinatesChartSidebarPanel.this.updateElementNames(source.getName(), clusterNameTextField, clusterColorButton, removeClusterButton, applyClusterButton, clusterAlphaSlider, clusterActiveCheckbox);
                    ParallelCoordinatesChartSidebarPanel.this.revalidate();
                    ParallelCoordinatesChartSidebarPanel.this.repaint();
                }

                @Override
                public void onColorChanged(Cluster source) {
                    ParallelCoordinatesChartSidebarPanel.this.updateElementColor(clusterColorButton, source.getActiveDesignColor(ParallelCoordinatesChartSidebarPanel.this.getChart().isUseAlpha()));
                    ParallelCoordinatesChartSidebarPanel.this.revalidate();
                    ParallelCoordinatesChartSidebarPanel.this.repaint();
                }
            });
            this.clusterPanel.add(wrapperPanel);
        }
        this.revalidate();
        this.repaint();
    }

    private void linkColorButtonToSlider(ColorChoiceButton colorButton, JSlider clusterAlphaSlider) {
        clusterAlphaSlider.addChangeListener(event -> {
            int value = Math.min(clusterAlphaSlider.getValue(), 255);
            colorButton.setAlpha(value);
        });
    }

    private void updateElementNames(String name, JTextField clusterNameLabel, JButton clusterColorButton, JButton removeClusterButton, JButton applyClusterButton, JSlider clusterAlphaSlider, JCheckBox clusterActiveCheckbox) {
        if (!clusterNameLabel.getText().equals(name)) {
            clusterNameLabel.setText(name);
        }
        clusterColorButton.setName(name);
        removeClusterButton.setName(name);
        applyClusterButton.setName(name);
        clusterAlphaSlider.setName(name);
        clusterActiveCheckbox.setName(name);
    }

    private void updateElementColor(ColorChoiceButton clusterColorButton, Color color) {
        clusterColorButton.setCurrentColor(color);
    }

    private void handleUpdatedClusterName(JTextField source, Cluster cluster, String newName) {
        if (newName == null || newName.isEmpty()) {
            JOptionPane.showMessageDialog(this, "Invalid cluster name: \"" + newName + "\"", "Error on renaming cluster", 0);
            source.setText(cluster.getName());
        }
        if (Objects.equals(newName, cluster.getName())) {
            return;
        }
        cluster.setName(newName);
    }

    @Override
    protected void initialize() {
        this.clusterScrollPane = new JScrollPane();
        this.clusterScrollPane.setVerticalScrollBarPolicy(20);
        this.clustersToListeners = new HashMap<Cluster, ClusterListener>();
        this.clusterAlphaSliders = new LinkedHashMap<Cluster, JSlider>(10);
        this.cmd = new ParallelChartSidebarActionListener(this.getMainWindow(), this, (ParallelCoordinatesChartPanel)this.getChartPanel(), this.getMainWindow().getClusterFactory());
    }

    public void setAlphaSlidersEnabled(boolean enabled) {
        this.activeDesignAlphaSlider.setEnabled(enabled);
        for (JSlider slider : this.clusterAlphaSliders.values()) {
            slider.setEnabled(enabled);
        }
    }

    @Override
    public void onClosed() {
        super.onClosed();
        this.closeHook.run();
    }
}

