/*
 * Decompiled with CFR 0.152.
 */
package org.xdat.gui.panels;

import java.awt.Color;
import java.awt.Cursor;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Polygon;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.awt.event.MouseWheelEvent;
import java.awt.event.MouseWheelListener;
import java.awt.image.BufferedImage;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Optional;
import org.apache.batik.svggen.SVGGraphics2D;
import org.jetbrains.annotations.Nullable;
import org.xdat.Main;
import org.xdat.chart.Axis;
import org.xdat.chart.Filter;
import org.xdat.chart.ParallelCoordinatesChart;
import org.xdat.data.Cluster;
import org.xdat.data.DataSheet;
import org.xdat.data.Design;
import org.xdat.data.Parameter;
import org.xdat.gui.frames.ChartFrame;
import org.xdat.gui.menus.parallelCoordinatesChart.ParallelCoordinatesContextMenu;
import org.xdat.gui.panels.ChartPanel;
import org.xdat.gui.tables.DataSheetTableColumnModel;

public class ParallelCoordinatesChartPanel
extends ChartPanel
implements MouseMotionListener,
MouseListener,
MouseWheelListener {
    static final long serialVersionUID = 5L;
    private final Main mainWindow;
    private final ChartFrame chartFrame;
    private final ParallelCoordinatesChart chart;
    private BufferedImage bufferedImage;
    private Filter draggedFilter;
    private Axis draggedAxis;
    private int dragStartX;
    private int dragStartY;
    private int dragCurrentX;
    private int dragOffsetY;
    private boolean dragSelecting = false;
    private final HashSet<Integer> hoverList;
    private final Map<int[], HashSet<Integer>> lineMap;

    public ParallelCoordinatesChartPanel(Main mainWindow, ChartFrame chartFrame, ParallelCoordinatesChart chart) {
        super(chart);
        this.mainWindow = mainWindow;
        this.chartFrame = chartFrame;
        this.chart = chart;
        this.addMouseListener(this);
        this.addMouseMotionListener(this);
        this.addMouseWheelListener(this);
        this.lineMap = new LinkedHashMap<int[], HashSet<Integer>>();
        this.hoverList = new HashSet();
    }

    @Override
    public void paintComponent(Graphics g) {
        Graphics cg;
        BufferedImage canvas;
        if ((this.chart.isAntiAliasing() || this.chart.isUseAlpha()) && !(g instanceof SVGGraphics2D)) {
            canvas = new BufferedImage(this.getWidth(), this.getHeight(), 2);
            cg = canvas.getGraphics();
        } else {
            canvas = null;
            cg = g;
        }
        if (this.chart.isAntiAliasing()) {
            Graphics2D graphics2D = (Graphics2D)cg;
            graphics2D.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        }
        super.paintComponent(cg);
        if (this.draggedAxis != null) {
            cg.drawImage(this.bufferedImage, 0, 0, this);
            cg.setColor(new Color(100, 100, 100));
            int yPosition = this.chart.getAxisTopPos();
            int xPosition = this.dragCurrentX;
            cg.drawLine(xPosition - 1, yPosition, xPosition - 1, yPosition + this.chart.getAxisHeight());
            cg.drawLine(xPosition, yPosition, xPosition, yPosition + this.chart.getAxisHeight());
            cg.drawLine(xPosition + 1, yPosition, xPosition + 1, yPosition + this.chart.getAxisHeight());
        } else if (this.dragSelecting) {
            cg.drawImage(this.bufferedImage, 0, 0, this);
            this.drawSelection(cg);
        } else {
            this.drawDesigns(cg);
            this.drawAxes(cg);
        }
        if (canvas != null) {
            g.drawImage(canvas, 0, 0, null);
        }
    }

    private void drawSelection(Graphics g) {
        if (this.dragSelecting) {
            Rectangle rec = this.getSelectionRectangle();
            g.setColor(new Color(50, 50, 50, 150));
            g.drawRect(rec.x, rec.y, rec.width, rec.height);
            g.setColor(new Color(50, 50, 50, 50));
            g.fillRect(rec.x, rec.y, rec.width, rec.height);
        }
    }

    private Rectangle getSelectionRectangle() {
        return this.pointsToRectangle(this.dragStartX, this.dragStartY, this.dragCurrentX, this.dragOffsetY);
    }

    private Rectangle pointsToRectangle(int x1, int y1, int x2, int y2) {
        if (x1 <= x2 && y1 >= y2) {
            return new Rectangle(x1, y2, x2 - x1, y1 - y2);
        }
        if (x1 > x2 && y1 > y2) {
            return new Rectangle(x2, y2, x1 - x2, y1 - y2);
        }
        if (x1 > x2 && y1 < y2) {
            return new Rectangle(x2, y1, x1 - x2, y2 - y1);
        }
        return new Rectangle(x1, y1, x2 - x1, y2 - y1);
    }

    private int withinAxisDragZone(int x) {
        for (int i = 0; i < this.chart.getAxisCount(); ++i) {
            Axis axis = this.chart.getAxis(i);
            int axisPos = axis.getUpperFilter().getXPos();
            if (!axis.isActive() || x < axisPos - 10 || x >= axisPos + 10) continue;
            return i;
        }
        return -1;
    }

    private void drawDesigns(Graphics g) {
        if (this.chart.isAntiAliasing()) {
            Graphics2D graphics2D = (Graphics2D)g;
            graphics2D.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        }
        ParallelCoordinatesChart chart = (ParallelCoordinatesChart)this.getChart();
        int axisTopPos = chart.getAxisTopPos();
        int designLabelFontSize = chart.getDesignLabelFontSize();
        int axisCount = chart.getAxisCount();
        double[] axisRanges = new double[axisCount];
        int[] axisHeights = new int[axisCount];
        int[] axisWidths = new int[axisCount];
        double[] axisMaxValues = new double[axisCount];
        double[] axisMinValues = new double[axisCount];
        boolean[] axisActiveFlags = new boolean[axisCount];
        boolean[] axisInversionFlags = new boolean[axisCount];
        for (int i = 0; i < axisCount; ++i) {
            axisRanges[i] = chart.getAxis(i).getMax() - chart.getAxis(i).getMin();
            axisHeights[i] = chart.getAxisHeight();
            axisWidths[i] = chart.getAxis(i).getWidth();
            axisMaxValues[i] = chart.getAxis(i).getMax();
            axisMinValues[i] = chart.getAxis(i).getMin();
            axisActiveFlags[i] = chart.getAxis(i).isActive();
            axisInversionFlags[i] = chart.getAxis(i).isAxisInverted();
        }
        Color activeDesignColor = chart.getActiveDesignColor();
        Color activeDesignColorNoAlpha = chart.getActiveDesignColorNoAlpha();
        Color filteredDesignColor = chart.getFilteredDesignColor();
        Color filteredDesignColorNoAlpha = chart.getFilteredDesignColorNoAlpha();
        Color selectedDesignColor = chart.getSelectedDesignColor();
        boolean showFilteredDesigns = chart.isShowFilteredDesigns();
        int chartLineThickness = chart.getLineThickness();
        boolean showOnlySelectedDesigns = chart.isShowOnlySelectedDesigns();
        int selectedDesignsLineThickness = chart.getSelectedDesignsLineThickness();
        this.lineMap.clear();
        boolean useAlpha = chart.isUseAlpha();
        ArrayList<Design> highlightedDesigns = new ArrayList<Design>();
        DataSheet dataSheet = this.mainWindow.getDataSheet();
        String fontFamily = chart.getFontFamily();
        for (int designIndex = 0; designIndex < dataSheet.getDesignCount(); ++designIndex) {
            boolean displayDesign;
            Design currentDesign = dataSheet.getDesign(designIndex);
            if (!currentDesign.isInsideBounds(chart)) continue;
            boolean currentDesignClusterActive = true;
            @Nullable Cluster cluster = currentDesign.getCluster();
            if (cluster != null) {
                currentDesignClusterActive = cluster.isActive();
            }
            boolean currentDesignActive = currentDesign.isActive(chart);
            if (showOnlySelectedDesigns) {
                displayDesign = currentDesign.isSelected() && (currentDesignActive || showFilteredDesigns) && currentDesignClusterActive;
            } else {
                boolean bl = displayDesign = (currentDesignActive || showFilteredDesigns) && currentDesignClusterActive;
            }
            if (!displayDesign) continue;
            if (!(!showOnlySelectedDesigns && currentDesign.isSelected() || this.hoverList.contains(currentDesign.getId()))) {
                g.setColor(chart.getDesignColor(currentDesign, currentDesignActive, useAlpha, activeDesignColor, activeDesignColorNoAlpha, filteredDesignColor, filteredDesignColorNoAlpha));
                int lineThickness = cluster != null ? cluster.getLineThickness() : chartLineThickness;
                this.drawDesign(g, chart, axisTopPos, designLabelFontSize, axisCount, axisRanges, axisHeights, axisWidths, axisMaxValues, axisMinValues, axisActiveFlags, axisInversionFlags, currentDesign, lineThickness, fontFamily);
                continue;
            }
            highlightedDesigns.add(currentDesign);
        }
        for (Design highlightedDesign : highlightedDesigns) {
            g.setColor(selectedDesignColor);
            this.drawDesign(g, chart, axisTopPos, designLabelFontSize, axisCount, axisRanges, axisHeights, axisWidths, axisMaxValues, axisMinValues, axisActiveFlags, axisInversionFlags, highlightedDesign, selectedDesignsLineThickness, fontFamily);
        }
    }

    private void drawDesign(Graphics g, ParallelCoordinatesChart chart, int axisTopPos, int designLabelFontSize, int axisCount, double[] axisRanges, int[] axisHeights, int[] axisWidths, double[] axisMaxValues, double[] axisMinValues, boolean[] axisActiveFlags, boolean[] axisInversionFlags, Design currentDesign, int lineThickness, String fontFamily) {
        int xPositionCurrent = this.getMarginLeft();
        int yPositionCurrent = axisTopPos;
        int xPositionLast = xPositionCurrent;
        boolean firstAxisDrawn = false;
        for (int i = 0; i < axisCount; ++i) {
            int yPositionRelToBottom;
            int yPosition = axisTopPos;
            if (!axisActiveFlags[i]) continue;
            Parameter parameter = this.mainWindow.getDataSheet().getParameter(i);
            double value = currentDesign.getDoubleValue(parameter);
            if (axisRanges[i] == 0.0) {
                yPositionRelToBottom = (int)((double)axisHeights[i] * 0.5);
            } else {
                double ratio = axisInversionFlags[i] ? (axisMaxValues[i] - value) / axisRanges[i] : (value - axisMinValues[i]) / axisRanges[i];
                yPositionRelToBottom = (int)((double)axisHeights[i] * ratio);
            }
            int yPositionLast = yPositionCurrent;
            yPositionCurrent = yPosition + axisHeights[i] - yPositionRelToBottom;
            FontMetrics fm = g.getFontMetrics();
            g.setFont(new Font(fontFamily, 0, designLabelFontSize));
            if (firstAxisDrawn) {
                xPositionCurrent += (int)((double)axisWidths[i] * 0.5);
                if (lineThickness == 0) {
                    g.drawLine(xPositionLast - 3, yPositionLast, xPositionLast + 3, yPositionLast);
                    g.drawLine(xPositionCurrent - 3, yPositionCurrent, xPositionCurrent + 3, yPositionCurrent);
                } else {
                    for (int t = 1; t <= lineThickness; ++t) {
                        int deltaY = -(t / 2) * (2 * (t % 2) - 1);
                        g.drawLine(xPositionLast, yPositionLast + deltaY, xPositionCurrent, yPositionCurrent + deltaY);
                        int[] key = new int[]{xPositionLast, yPositionLast + deltaY, xPositionCurrent, yPositionCurrent + deltaY};
                        this.lineMap.computeIfAbsent(key, k -> new HashSet()).add(currentDesign.getId());
                    }
                }
            } else {
                firstAxisDrawn = true;
                if (chart.isShowDesignIDs()) {
                    g.drawString(Integer.toString(currentDesign.getId()), xPositionCurrent - 5 - fm.stringWidth(Integer.toString(currentDesign.getId())), yPositionCurrent + (int)(0.5 * (double)chart.getAxis(i).getTicLabelFontSize()));
                }
            }
            xPositionLast = xPositionCurrent;
            xPositionCurrent += (int)((double)axisWidths[i] * 0.5);
        }
    }

    private void drawAxes(Graphics g) {
        ParallelCoordinatesChart chart = (ParallelCoordinatesChart)this.getChart();
        int xPosition = this.getMarginLeft();
        int yPosition = chart.getAxisTopPos();
        FontMetrics fm = g.getFontMetrics();
        Axis lastAxis = null;
        int drawnAxisCount = 0;
        Color filterColor = chart.getFilterColor();
        String fontFamily = chart.getFontFamily();
        DataSheet dataSheet = this.mainWindow.getDataSheet();
        for (int i = 0; i < chart.getAxisCount(); ++i) {
            if (!chart.getAxis(i).isActive()) continue;
            Axis currentAxis = chart.getAxis(i);
            if (null != lastAxis) {
                xPosition = xPosition + (int)((double)lastAxis.getWidth() * 0.5) + (int)((double)currentAxis.getWidth() * 0.5);
            }
            String axisLabel = currentAxis.getName();
            int slenX = fm.stringWidth(axisLabel);
            g.setFont(new Font(fontFamily, 0, currentAxis.getAxisLabelFontSize()));
            int yLabelOffset = 0;
            if (chart.isVerticallyOffsetAxisLabels()) {
                yLabelOffset = drawnAxisCount++ % 2 * (chart.getMaxAxisLabelFontSize() + chart.getAxisLabelVerticalDistance());
            }
            g.setColor(currentAxis.getAxisLabelFontColor());
            g.drawString(axisLabel, xPosition - (int)(0.5 * (double)slenX), chart.getMaxAxisLabelFontSize() + chart.getTopMargin() + yLabelOffset);
            g.setColor(currentAxis.getAxisColor());
            g.drawLine(xPosition, yPosition, xPosition, yPosition + chart.getAxisHeight());
            Filter uf = currentAxis.getUpperFilter();
            Filter lf = currentAxis.getLowerFilter();
            uf.setXPos(xPosition);
            lf.setXPos(xPosition);
            g.setColor(filterColor);
            g.drawLine(uf.getXPos(), uf.getYPos(dataSheet), uf.getXPos() - chart.getFilterWidth(), uf.getYPos(dataSheet) - chart.getFilterHeight());
            g.drawLine(uf.getXPos(), uf.getYPos(dataSheet), uf.getXPos() + chart.getFilterWidth(), uf.getYPos(dataSheet) - chart.getFilterHeight());
            g.drawLine(uf.getXPos() - chart.getFilterWidth(), uf.getYPos(dataSheet) - chart.getFilterHeight(), uf.getXPos() + chart.getFilterWidth(), uf.getYPos(dataSheet) - chart.getFilterHeight());
            g.drawLine(lf.getXPos(), lf.getYPos(dataSheet), lf.getXPos() - chart.getFilterWidth(), lf.getYPos(dataSheet) + chart.getFilterHeight());
            g.drawLine(lf.getXPos(), lf.getYPos(dataSheet), lf.getXPos() + chart.getFilterWidth(), lf.getYPos(dataSheet) + chart.getFilterHeight());
            g.drawLine(lf.getXPos() - chart.getFilterWidth(), lf.getYPos(dataSheet) + chart.getFilterHeight(), lf.getXPos() + chart.getFilterWidth(), lf.getYPos(dataSheet) + chart.getFilterHeight());
            g.setFont(new Font(fontFamily, 0, currentAxis.getTicLabelFontSize()));
            if ((uf == this.draggedFilter || lf == this.draggedFilter) && currentAxis.getParameter().isNumeric()) {
                g.drawString(String.format(currentAxis.getTicLabelFormat(), this.draggedFilter.getValue()), this.draggedFilter.getXPos() + chart.getFilterWidth() + 4, this.draggedFilter.getYPos(dataSheet) - chart.getFilterHeight());
            }
            if (null != lastAxis) {
                g.drawLine(lastAxis.getUpperFilter().getXPos(), lastAxis.getUpperFilter().getYPos(dataSheet), uf.getXPos(), uf.getYPos(dataSheet));
                g.drawLine(lastAxis.getLowerFilter().getXPos(), lastAxis.getLowerFilter().getYPos(dataSheet), lf.getXPos(), lf.getYPos(dataSheet));
            }
            int ticSize = currentAxis.getTicLength();
            int ticCount = currentAxis.getTicCount();
            double ticSpacing = ticCount > 1 ? (double)chart.getAxisHeight() / (double)(ticCount - 1) : 0.0;
            double axisRange = currentAxis.getRange();
            double ticValueDifference = axisRange / (double)(ticCount - 1);
            for (int ticID = 0; ticID < ticCount; ++ticID) {
                String ticLabel;
                int currentTicYPos = currentAxis.isAxisInverted() ? yPosition + chart.getAxisHeight() - (int)((double)ticID * ticSpacing) : yPosition + (int)((double)ticID * ticSpacing);
                g.setColor(currentAxis.getAxisColor());
                if (ticCount > 1) {
                    g.drawLine(xPosition, currentTicYPos, xPosition + ticSize, currentTicYPos);
                } else {
                    g.drawLine(xPosition, yPosition + chart.getAxisHeight() / 2, xPosition + ticSize, yPosition + chart.getAxisHeight() / 2);
                }
                g.setColor(currentAxis.getAxisTicLabelFontColor());
                g.setFont(new Font(fontFamily, 0, currentAxis.getTicLabelFontSize()));
                if (currentAxis.getParameter().isNumeric()) {
                    double ticValue;
                    if (ticCount > 1) {
                        ticValue = currentAxis.getMax() - ticValueDifference * (double)ticID;
                        ticLabel = String.format(currentAxis.getTicLabelFormat(), ticValue);
                        g.drawString(ticLabel, xPosition + ticSize + 7, currentTicYPos + (int)(0.5 * (double)currentAxis.getTicLabelFontSize()));
                        continue;
                    }
                    ticValue = currentAxis.getMax();
                    ticLabel = String.format(currentAxis.getTicLabelFormat(), ticValue);
                    g.drawString(ticLabel, xPosition + 2 * ticSize, yPosition + chart.getAxisHeight() / 2 + (int)(0.5 * (double)currentAxis.getTicLabelFontSize()));
                    continue;
                }
                if (ticCount > 1) {
                    ticLabel = currentAxis.getParameter().getStringValueOf(currentAxis.getMax() - ticValueDifference * (double)ticID);
                    g.drawString(ticLabel, xPosition + 2 * ticSize, currentTicYPos + (int)(0.5 * (double)currentAxis.getTicLabelFontSize()));
                    continue;
                }
                ticLabel = currentAxis.getParameter().getStringValueOf(currentAxis.getMax());
                g.drawString(ticLabel, xPosition + 2 * ticSize, yPosition + chart.getAxisHeight() / 2 + (int)(0.5 * (double)currentAxis.getTicLabelFontSize()));
            }
            lastAxis = currentAxis;
        }
    }

    private Optional<Axis> getAxisAtLocation(int x) {
        for (int i = 0; i < this.chart.getAxisCount(); ++i) {
            Filter uf = this.chart.getAxis(i).getUpperFilter();
            if (!this.chart.getAxis(i).isActive() || !((double)x >= (double)uf.getXPos() - 0.5 * (double)this.chart.getAxis(i).getWidth()) || !((double)x < (double)uf.getXPos() + 0.5 * (double)this.chart.getAxis(i).getWidth())) continue;
            return Optional.of(this.chart.getAxis(i));
        }
        return Optional.empty();
    }

    private int getNewAxisIndexAtLocation(int x) {
        for (int i = 0; i < this.chart.getAxisCount(); ++i) {
            Filter uf = this.chart.getAxis(i).getUpperFilter();
            if (!this.chart.getAxis(i).isActive() || x >= uf.getXPos()) continue;
            return i;
        }
        return this.chart.getAxisCount();
    }

    @Override
    public void mouseClicked(MouseEvent e) {
        if (e.getButton() == 1 && this.updateHoverList(e.getX(), e.getY())) {
            ArrayList<Integer> newSelection = new ArrayList<Integer>();
            DataSheet dataSheet = this.chart.getDataSheet();
            for (Integer designId : this.hoverList) {
                Design d;
                d.setSelected(!(d = dataSheet.getDesignByID(designId)).isSelected());
            }
            for (int i = 0; i < dataSheet.getDesignCount(); ++i) {
                if (!dataSheet.getDesign(i).isSelected()) continue;
                newSelection.add(i);
            }
            this.mainWindow.getDataSheetTablePanel().setSelectedRows(newSelection);
        } else if (e.getButton() == 3) {
            int x = e.getX();
            int y = e.getY();
            this.getAxisAtLocation(x).ifPresent(axis -> new ParallelCoordinatesContextMenu(this.mainWindow, this.chartFrame, (Axis)axis).show(this, x, y));
        }
    }

    @Override
    public void mouseEntered(MouseEvent e) {
    }

    @Override
    public void mouseExited(MouseEvent e) {
        this.hoverList.clear();
        this.repaint();
    }

    @Override
    public void mousePressed(MouseEvent e) {
        ParallelCoordinatesChart chart = (ParallelCoordinatesChart)this.getChart();
        this.dragStartX = e.getX();
        this.dragStartY = e.getY();
        DataSheet dataSheet = this.mainWindow.getDataSheet();
        for (int i = 0; i < chart.getAxisCount(); ++i) {
            Filter uf = chart.getAxis(i).getUpperFilter();
            Filter lf = chart.getAxis(i).getLowerFilter();
            if (chart.getAxis(i).isActive() && this.dragStartY >= uf.getYPos(dataSheet) - chart.getFilterHeight() && this.dragStartY <= uf.getYPos(dataSheet) && this.dragStartX >= uf.getXPos() - chart.getFilterWidth() && this.dragStartX <= uf.getXPos() + chart.getFilterWidth()) {
                this.draggedFilter = uf;
                this.dragOffsetY = uf.getYPos(dataSheet) - this.dragStartY;
                this.setCursor(new Cursor(13));
                continue;
            }
            if (!chart.getAxis(i).isActive() || this.dragStartY < lf.getYPos(dataSheet) || this.dragStartY > lf.getYPos(dataSheet) + chart.getFilterHeight() || this.dragStartX < lf.getXPos() - chart.getFilterWidth() || this.dragStartX > lf.getXPos() + chart.getFilterWidth()) continue;
            this.draggedFilter = lf;
            this.dragOffsetY = lf.getYPos(dataSheet) - this.dragStartY;
            this.setCursor(new Cursor(13));
        }
        if (this.draggedFilter == null) {
            this.storeBufferedImage();
            if (e.getButton() == 1 && this.withinAxisDragZone(e.getX()) > -1) {
                this.getAxisAtLocation(this.dragStartX).ifPresent(axis -> {
                    this.draggedAxis = axis;
                    this.setCursor(new Cursor(13));
                });
            } else if (e.getButton() == 1) {
                this.hoverList.clear();
                this.dragSelecting = true;
            }
        }
    }

    @Override
    public void mouseReleased(MouseEvent e) {
        this.setCursor(new Cursor(0));
        DataSheet dataSheet = this.mainWindow.getDataSheet();
        boolean repaintRequired = false;
        if (this.draggedFilter != null) {
            repaintRequired = true;
            this.draggedFilter = null;
        }
        if (this.draggedAxis != null) {
            repaintRequired = true;
            int newIndex = this.getNewAxisIndexAtLocation(e.getX() - 1);
            DataSheetTableColumnModel cm = (DataSheetTableColumnModel)this.mainWindow.getDataSheetTablePanel().getDataTable().getColumnModel();
            int currentIndex = dataSheet.getParameterIndex(this.draggedAxis.getName()) + 1;
            if (newIndex > currentIndex) {
                cm.moveColumn(currentIndex, newIndex);
            } else if (newIndex < currentIndex) {
                cm.moveColumn(currentIndex, newIndex + 1);
            }
            this.draggedAxis = null;
        }
        if (this.dragSelecting) {
            repaintRequired = false;
            this.dragSelecting = false;
            Rectangle rec = this.getSelectionRectangle();
            this.dragOffsetY = 0;
            this.dragCurrentX = 0;
            this.dragStartY = 0;
            this.dragStartX = 0;
            if (rec.x > 1 && rec.y > 1) {
                for (int i = 0; i < this.chart.getAxisCount(); ++i) {
                    if (!this.chart.getAxis(i).isActive()) continue;
                    Filter uf = this.chart.getAxis(i).getUpperFilter();
                    Filter lf = this.chart.getAxis(i).getLowerFilter();
                    if (!rec.contains(uf.getXPos(), rec.y + 1)) continue;
                    uf.setYPos(rec.y, dataSheet);
                    lf.setYPos(rec.y + rec.height, dataSheet);
                }
            }
        }
        if (repaintRequired) {
            this.mainWindow.repaintAllChartFrames();
        }
    }

    @Override
    public void mouseMoved(MouseEvent e) {
        boolean needRepaint = false;
        if (this.withinAxisDragZone(e.getX()) > -1) {
            this.setCursor(new Cursor(12));
        } else {
            this.setCursor(new Cursor(0));
        }
        if (this.hoverList.size() > 0) {
            needRepaint = true;
        }
        this.hoverList.clear();
        if (this.withinAxisDragZone(e.getX()) < 0) {
            boolean bl = needRepaint = needRepaint || this.updateHoverList(e.getX(), e.getY());
        }
        if (needRepaint) {
            this.repaint();
        }
    }

    private boolean updateHoverList(int x, int y) {
        boolean designsFound = false;
        this.hoverList.clear();
        for (Map.Entry<int[], HashSet<Integer>> mapEntry : this.lineMap.entrySet()) {
            int[] coords = mapEntry.getKey();
            HashSet<Integer> designIDs = mapEntry.getValue();
            int xStart = coords[0];
            int yStart = coords[1];
            int xEnd = coords[2];
            int yEnd = coords[3];
            if (x <= xStart || x >= xEnd || Math.min(yStart, yEnd) >= y || Math.max(yStart, yEnd) <= y) continue;
            int xDelta = xEnd - xStart;
            int xMiddle = xStart + xDelta / 2;
            int yDelta = Math.abs(yEnd - yStart) / 2;
            int yMiddle = yEnd > yStart ? yStart + yDelta : yEnd + yDelta;
            int designCount = designIDs.size();
            int yOffset = (int)(100.0 * (double)designCount / (double)this.chart.getDataSheet().getDesignCount());
            int[] xPoints = new int[4];
            int[] yPoints = new int[4];
            xPoints[0] = xStart;
            yPoints[0] = yStart;
            xPoints[1] = xMiddle;
            yPoints[1] = yMiddle - yOffset - 2;
            xPoints[2] = xEnd;
            yPoints[2] = yEnd;
            xPoints[3] = xMiddle;
            yPoints[3] = yMiddle + yOffset + 2;
            Polygon poly = new Polygon(xPoints, yPoints, xPoints.length);
            if (!poly.contains(x, y)) continue;
            this.hoverList.addAll(designIDs);
            designsFound = true;
        }
        return designsFound;
    }

    @Override
    public void mouseDragged(MouseEvent e) {
        DataSheet dataSheet = this.mainWindow.getDataSheet();
        if (this.draggedFilter != null) {
            this.draggedFilter.setYPos(Math.max(Math.min(e.getY() + this.dragOffsetY, this.draggedFilter.getLowestPos(dataSheet)), this.draggedFilter.getHighestPos(dataSheet)), dataSheet);
        } else if (this.draggedAxis != null) {
            this.dragCurrentX = e.getX();
            this.repaint();
        } else if (this.dragSelecting) {
            this.dragCurrentX = e.getX();
            this.dragOffsetY = e.getY();
            this.repaint();
        }
    }

    @Override
    public void mouseWheelMoved(MouseWheelEvent e) {
        int modifier = e.getModifiers();
        if (modifier == 0) {
            this.chart.incrementAxisWidth(-e.getUnitsToScroll());
        } else if (modifier == 2) {
            int x = e.getX();
            this.getAxisAtLocation(x).ifPresent(axis -> axis.setWidth(Math.max(0, axis.getWidth() - e.getUnitsToScroll())));
        } else if (modifier == 8) {
            int x = e.getX();
            this.getAxisAtLocation(x).ifPresent(axis -> axis.setTicCount(Math.max(2, axis.getTicCount() - e.getWheelRotation()), this.mainWindow.getDataSheet()));
        }
        this.repaint();
    }

    private void storeBufferedImage() {
        this.bufferedImage = new BufferedImage(this.chartFrame.getChartPanel().getWidth(), this.chartFrame.getChartPanel().getHeight(), 2);
        Graphics2D g = this.bufferedImage.createGraphics();
        this.paintComponent(g);
        g.dispose();
    }
}

