/*
 * Decompiled with CFR 0.152.
 */
package org.xdat.gui.panels;

import java.awt.Dimension;
import java.awt.Graphics;
import javax.swing.JPanel;
import org.xdat.chart.Chart;

public abstract class ChartPanel
extends JPanel {
    private Chart chart;
    private int marginTop = 20;
    private int marginBottom = 80;
    private int marginLeft = 80;
    private int marginRight = 20;

    ChartPanel(Chart chart) {
        this.chart = chart;
        chart.addListener(source -> this.repaint());
    }

    @Override
    public void paintComponent(Graphics g) {
        super.paintComponent(g);
        this.setBackground(this.chart.getBackGroundColor());
        this.drawPlotFieldBackground(g);
    }

    private void drawPlotFieldBackground(Graphics g) {
        g.setColor(this.chart.getBackGroundColor());
        g.fillRect(0, 0, this.getWidth(), this.getHeight());
    }

    @Override
    public Dimension getPreferredSize() {
        int width = this.marginLeft + this.marginRight + this.chart.getWidth();
        int height = this.marginTop + this.marginBottom + this.chart.getHeight();
        return new Dimension(width, height);
    }

    int getMarginLeft() {
        return this.marginLeft;
    }

    public Chart getChart() {
        return this.chart;
    }
}

