/*
 * Decompiled with CFR 0.152.
 */
package org.xdat.gui.panels;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridLayout;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Vector;
import javax.swing.JComboBox;
import javax.swing.JPanel;
import org.xdat.chart.Axis;
import org.xdat.gui.panels.PaddedPanel;
import org.xdat.gui.panels.SettingsGroupPanel;
import org.xdat.gui.panels.TitledSubPanel;
import org.xdat.settings.BooleanSetting;
import org.xdat.settings.Key;
import org.xdat.settings.SettingsGroup;

public class AxisDisplaySettingsPanel
extends JPanel {
    private TitledSubPanel contentPanel = new TitledSubPanel("");
    private JComboBox<Axis> axisChoiceCombo;
    private final Map<SettingsGroup, SettingsGroupPanel> axisSettingPanels = new HashMap<SettingsGroup, SettingsGroupPanel>();
    private Runnable applyAll;
    private JPanel settingsPanelWrapper = new JPanel();

    private AxisDisplaySettingsPanel() {
        this.setLayout(new BorderLayout());
        this.add((Component)this.contentPanel, "Center");
        this.contentPanel.setLayout(new BorderLayout());
        this.contentPanel.add((Component)this.settingsPanelWrapper, "Center");
        this.settingsPanelWrapper.setLayout(new BorderLayout());
    }

    public AxisDisplaySettingsPanel(SettingsGroup settings) {
        this();
        SettingsGroupPanel p = new SettingsGroupPanel(settings);
        this.axisSettingPanels.put(settings, p);
        this.setCurrentSettings(settings);
        this.applyAll = p::applyAll;
    }

    public AxisDisplaySettingsPanel(List<Axis> axes) {
        this();
        Vector<Axis> v = new Vector<Axis>(0, 1);
        for (Axis axis : axes) {
            v.add(axis);
            SettingsGroup settings = axis.getSettings();
            SettingsGroupPanel settingsGroupPanel = new SettingsGroupPanel(settings);
            this.getMinTextField(settingsGroupPanel);
            this.getMaxTextField(settingsGroupPanel);
            BooleanSetting autoFitSetting = settings.getBooleanSetting(Key.PARALLEL_COORDINATES_AUTO_FIT_AXIS);
            autoFitSetting.addListener((src, transaction) -> this.setAxisRangeFieldsEnabled((Boolean)src.get() == false, settingsGroupPanel));
            this.setAxisRangeFieldsEnabled((Boolean)autoFitSetting.get() == false, settingsGroupPanel);
            this.axisSettingPanels.put(settings, settingsGroupPanel);
        }
        this.axisChoiceCombo = new JComboBox(v);
        this.axisChoiceCombo.addActionListener(actionEvent -> {
            Axis selectedItem = (Axis)this.axisChoiceCombo.getSelectedItem();
            if (selectedItem != null) {
                this.setCurrentSettings(selectedItem.getSettings());
            }
        });
        this.applyAll = () -> {
            for (SettingsGroupPanel panel : this.axisSettingPanels.values()) {
                panel.applyAll();
            }
        };
        this.axisChoiceCombo.setSelectedIndex(0);
        this.axisChoiceCombo.setPreferredSize(new Dimension(100, 25));
        PaddedPanel axisComboWrapper = new PaddedPanel(5);
        axisComboWrapper.setLayout(new GridLayout(1, 1));
        axisComboWrapper.add(this.axisChoiceCombo);
        this.add((Component)axisComboWrapper, "North");
        Axis first = axes.get(0);
        if (first != null) {
            this.setCurrentSettings(first.getSettings());
        }
    }

    private void setCurrentSettings(SettingsGroup settings) {
        this.settingsPanelWrapper.removeAll();
        SettingsGroupPanel settingsGroupPanel = this.axisSettingPanels.get(settings);
        if (settingsGroupPanel != null) {
            this.settingsPanelWrapper.add((Component)settingsGroupPanel, "Center");
        }
        this.revalidate();
        this.repaint();
    }

    private JPanel getMaxTextField(SettingsGroupPanel settingsGroupPanel) {
        return settingsGroupPanel.getComponents(Key.PARALLEL_COORDINATES_AXIS_DEFAULT_MAX).getControl();
    }

    private JPanel getMinTextField(SettingsGroupPanel settingsGroupPanel) {
        return settingsGroupPanel.getComponents(Key.PARALLEL_COORDINATES_AXIS_DEFAULT_MIN).getControl();
    }

    public void applyAll() {
        this.applyAll.run();
    }

    public void setAxisRangeFieldsEnabled(boolean fieldsEnabled, SettingsGroupPanel settingsGroupPanel) {
        this.getMinTextField(settingsGroupPanel).setEnabled(fieldsEnabled);
        this.getMaxTextField(settingsGroupPanel).setEnabled(fieldsEnabled);
    }
}

