/*
 * Decompiled with CFR 0.152.
 */
package org.xdat.gui.menus.parallelCoordinatesChart;

import javax.swing.JCheckBoxMenuItem;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.event.MenuEvent;
import javax.swing.event.MenuListener;
import org.xdat.Main;
import org.xdat.actionListeners.chartFrames.ChartFrameSelectParametersMenuActionListener;
import org.xdat.chart.ParallelCoordinatesChart;
import org.xdat.gui.frames.ChartFrame;

class ParallelCoordinatesChartFrameSelectParametersMenu
extends JMenu
implements MenuListener {
    private final Main mainWindow;
    private final ChartFrameSelectParametersMenuActionListener cmd;
    private final ParallelCoordinatesChart chart;

    ParallelCoordinatesChartFrameSelectParametersMenu(Main mainWindow, ChartFrame chartFrame, ParallelCoordinatesChart chart) {
        super("Parameters");
        this.addMenuListener(this);
        this.mainWindow = mainWindow;
        this.chart = chart;
        this.setMnemonic(80);
        this.cmd = new ChartFrameSelectParametersMenuActionListener(mainWindow, chartFrame, chart);
    }

    private void buildMenu() {
        this.removeAll();
        JMenuItem mi = new JMenuItem("Select All");
        mi.setMnemonic(83);
        mi.addActionListener(e -> this.cmd.setAllSelected(true));
        this.add(mi);
        mi = new JMenuItem("Unselect All");
        mi.setMnemonic(85);
        mi.addActionListener(e -> this.cmd.setAllSelected(false));
        this.add(mi);
        mi = new JMenuItem("Reverse Selection");
        mi.setMnemonic(82);
        mi.addActionListener(this.cmd::reverseSelection);
        this.add(mi);
        mi = new JMenuItem("Custom Selection");
        mi.setMnemonic(67);
        mi.addActionListener(this.cmd::customSelection);
        this.add(mi);
        this.addSeparator();
        JCheckBoxMenuItem[] checkBoxMenuItems = new JCheckBoxMenuItem[this.mainWindow.getDataSheet().getParameterCount()];
        for (int i = 0; i < checkBoxMenuItems.length; ++i) {
            checkBoxMenuItems[i] = new JCheckBoxMenuItem(this.mainWindow.getDataSheet().getParameter(i).getName());
            checkBoxMenuItems[i].addActionListener(this.cmd::toggleParameter);
            this.chart.getAxis(0);
            checkBoxMenuItems[i].setState(this.chart.getAxis(this.mainWindow.getDataSheet().getParameter(i).getName()).isActive());
            this.add(checkBoxMenuItems[i]);
        }
    }

    @Override
    public void menuCanceled(MenuEvent arg0) {
    }

    @Override
    public void menuDeselected(MenuEvent arg0) {
    }

    @Override
    public void menuSelected(MenuEvent arg0) {
        this.buildMenu();
    }
}

