/*
 * Decompiled with CFR 0.152.
 */
package org.xdat.gui.menus.parallelCoordinatesChart;

import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.event.MenuEvent;
import javax.swing.event.MenuListener;
import org.xdat.Main;
import org.xdat.actionListeners.chartFrames.ChartFrameAddDesignToClusterMenuActionListener;
import org.xdat.data.Cluster;
import org.xdat.data.ClusterSet;
import org.xdat.gui.frames.ChartFrame;

public class ParallelCoordinatesChartFrameAddDesignToClusterMenu
extends JMenu
implements MenuListener {
    private final Main mainWindow;
    private final ChartFrame chartFrame;

    ParallelCoordinatesChartFrameAddDesignToClusterMenu(Main mainWindow, ChartFrame chartFrame) {
        super("Add filtered designs to cluster");
        this.mainWindow = mainWindow;
        this.chartFrame = chartFrame;
        this.setMnemonic(65);
        this.addMenuListener(this);
    }

    private void updateClusterList() {
        this.removeAll();
        ClusterSet clusterSet = this.mainWindow.getCurrentClusterSet();
        if (clusterSet.getClusterCount() == 0) {
            JMenuItem mi = new JMenuItem("No clusters defined");
            this.add(mi);
            mi.setEnabled(false);
        } else {
            for (int i = 0; i < clusterSet.getClusterCount(); ++i) {
                Cluster cluster = clusterSet.getCluster(i);
                ChartFrameAddDesignToClusterMenuActionListener cmd = new ChartFrameAddDesignToClusterMenuActionListener(this.mainWindow, this.chartFrame, cluster);
                JMenuItem mi = new JMenuItem(cluster.getName());
                mi.addActionListener(cmd);
                this.add(mi);
            }
        }
    }

    @Override
    public void menuCanceled(MenuEvent e) {
    }

    @Override
    public void menuDeselected(MenuEvent e) {
    }

    @Override
    public void menuSelected(MenuEvent e) {
        this.updateClusterList();
    }
}

