/*
 * Decompiled with CFR 0.152.
 */
package org.xdat.gui.frames;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.GridLayout;
import java.awt.event.ComponentEvent;
import java.awt.event.ComponentListener;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import org.xdat.Main;
import org.xdat.chart.Chart;
import org.xdat.chart.ParallelCoordinatesChart;
import org.xdat.chart.ScatterChart2D;
import org.xdat.data.Cluster;
import org.xdat.data.ClusterListener;
import org.xdat.exceptions.NoParametersDefinedException;
import org.xdat.gui.ChartFrameClosingAdapter;
import org.xdat.gui.menus.ScatterChart2D.ScatterChart2DFrameMenuBar;
import org.xdat.gui.menus.parallelCoordinatesChart.ParallelCoordinateChartFrameMenuBar;
import org.xdat.gui.panels.ChartPanel;
import org.xdat.gui.panels.ParallelCoordinatesChartPanel;
import org.xdat.gui.panels.ParallelCoordinatesChartSidebarPanel;
import org.xdat.gui.panels.ScatterChart2DPanel;

public class ChartFrame
extends JFrame
implements ComponentListener {
    private final Main mainWindow;
    private final Chart chart;
    private final ChartPanel chartPanel;
    private final List<Runnable> closeHooks = new ArrayList<Runnable>();

    public ChartFrame(Main mainWindow, Chart chart) throws NoParametersDefinedException {
        super(chart.getTitle());
        if (mainWindow.getDataSheet().getParameterCount() < 1) {
            throw new NoParametersDefinedException();
        }
        this.addWindowListener(new ChartFrameClosingAdapter(this, mainWindow));
        this.mainWindow = mainWindow;
        this.setIconImage(mainWindow.getIconImage());
        this.setPreferredSize(chart.getFrameSize());
        this.chart = chart;
        mainWindow.addChartFrame(this);
        this.setLayout(new GridLayout(1, 1));
        if (chart.getClass().equals(ParallelCoordinatesChart.class)) {
            JPanel wrapper = new JPanel();
            wrapper.setLayout(new BorderLayout());
            this.chartPanel = new ParallelCoordinatesChartPanel(mainWindow, this, (ParallelCoordinatesChart)this.chart);
            this.setJMenuBar(new ParallelCoordinateChartFrameMenuBar(mainWindow, this, (ParallelCoordinatesChart)this.chart));
            JScrollPane scrollPane = new JScrollPane(this.chartPanel, 21, 30);
            ParallelCoordinatesChartSidebarPanel sidebar = new ParallelCoordinatesChartSidebarPanel(mainWindow, this, this.chartPanel, (ParallelCoordinatesChart)chart);
            wrapper.add((Component)scrollPane, "Center");
            wrapper.add((Component)sidebar, "East");
            this.closeHooks.add(sidebar::onClosed);
            this.add(wrapper);
        } else if (chart.getClass().equals(ScatterChart2D.class)) {
            this.chartPanel = new ScatterChart2DPanel(mainWindow, (ScatterChart2D)this.chart);
            this.setJMenuBar(new ScatterChart2DFrameMenuBar(mainWindow, this, (ScatterChart2D)chart));
            this.add((Component)this.chartPanel, "Center");
        } else {
            throw new RuntimeException("Unknown Chart Type!");
        }
        ClusterListener.ClusterAdapter clusterListener = new ClusterListener.ClusterAdapter(){

            @Override
            public void onColorChanged(Cluster source) {
                ChartFrame.this.repaint();
            }
        };
        this.closeHooks.add(() -> mainWindow.removeChartFrame(this));
        this.setLocation(this.chart.getLocation());
        this.getContentPane().setPreferredSize(this.chart.getFrameSize());
        this.pack();
        this.addComponentListener(this);
        this.setVisible(true);
        mainWindow.getCurrentClusterSet().addClusterListener(clusterListener);
        this.closeHooks.add(() -> mainWindow.getCurrentClusterSet().removeClusterListener(clusterListener));
    }

    public Chart getChart() {
        return this.chart;
    }

    public ChartPanel getChartPanel() {
        return this.chartPanel;
    }

    @Override
    public void dispose() {
        this.closeHooks.forEach(Runnable::run);
        super.dispose();
    }

    public Main getMainWindow() {
        return this.mainWindow;
    }

    @Override
    public void componentHidden(ComponentEvent arg0) {
    }

    @Override
    public void componentMoved(ComponentEvent arg0) {
        this.chart.setLocation(this.getLocation());
    }

    @Override
    public void componentResized(ComponentEvent arg0) {
        this.chart.setFrameSize(this.getContentPane().getSize());
    }

    @Override
    public void componentShown(ComponentEvent arg0) {
    }
}

