/*
 * Decompiled with CFR 0.152.
 */
package org.xdat.gui.dialogs;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.GridLayout;
import java.util.function.Consumer;
import java.util.function.Supplier;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JColorChooser;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import org.xdat.Main;
import org.xdat.actionListeners.scatter2DChartSettings.ParallelChartFrameComboModel;
import org.xdat.chart.ScatterChart2D;
import org.xdat.chart.ScatterPlot2D;
import org.xdat.data.AxisType;
import org.xdat.data.DatasheetListener;
import org.xdat.gui.controls.ColorChoiceButton;
import org.xdat.gui.controls.MinMaxSpinnerModel;
import org.xdat.gui.controls.RightAlignedSpinner;
import org.xdat.gui.frames.ChartFrame;
import org.xdat.gui.panels.Scatter2DChartAxisPanel;
import org.xdat.gui.panels.TitledSubPanel;

public class ScatterChart2DSettingsDialog
extends JDialog {
    private final ChartFrame chartFrame;
    private final Runnable onClosed;

    public ScatterChart2DSettingsDialog(Main mainWindow, ChartFrame chartFrame, ScatterChart2D scatterChart2D) {
        super((Frame)chartFrame, scatterChart2D.getTitle() + " Settings");
        this.chartFrame = chartFrame;
        DatasheetListener listener = new DatasheetListener(){

            @Override
            public void onClustersChanged() {
                ScatterChart2DSettingsDialog.this.repaint();
            }

            @Override
            public void onDataPanelUpdateRequired() {
            }

            @Override
            public void onDataChanged(boolean[] autoFitRequired, boolean[] filterResetRequired, boolean[] applyFiltersRequired, boolean parametersChanged) {
                ScatterChart2DSettingsDialog.this.repaint();
            }
        };
        mainWindow.addDataSheetSubListener(listener);
        this.onClosed = () -> mainWindow.removeDataSheetSubListener(listener);
        this.setDefaultCloseOperation(2);
        this.setModal(false);
        this.buildPanel(mainWindow, chartFrame, scatterChart2D);
        Dimension parentSize = chartFrame.getSize();
        int xPos = Math.max(chartFrame.getX() + (int)(0.5 * ((double)parentSize.width - this.getSize().getWidth())), 0);
        int yPos = Math.max(chartFrame.getY() + (int)(0.5 * ((double)parentSize.height - this.getSize().getHeight())), 0);
        this.setLocation(xPos, yPos);
        this.setVisible(true);
    }

    public void buildPanel(Main mainWindow, ChartFrame chartFrame, ScatterChart2D scatterChart2D) {
        this.getContentPane().removeAll();
        this.getContentPane().setLayout(new BorderLayout());
        JPanel mainPanel = new JPanel(new BorderLayout());
        TitledSubPanel displayModeSelectionPanel = new TitledSubPanel("Display Mode");
        displayModeSelectionPanel.setLayout(new GridLayout(3, 1));
        ButtonGroup displayModeButtonGroup = new ButtonGroup();
        ScatterPlot2D scatterPlot2D = scatterChart2D.getScatterPlot2D();
        int displayMode = scatterPlot2D.getDisplayedDesignSelectionMode();
        JRadioButton displayAllDesignsButton = this.buildDisplayModeButton("Display all designs", displayMode, 0, scatterPlot2D, chartFrame);
        JRadioButton displaySelectedDesignsButton = this.buildDisplayModeButton("Display selected designs", displayMode, 1, scatterPlot2D, chartFrame);
        JRadioButton displayActiveDesignsButton = this.buildDisplayModeButton("Display designs visible in parallel chart: ", displayMode, 2, scatterPlot2D, chartFrame);
        displayModeButtonGroup.add(displayAllDesignsButton);
        displayModeButtonGroup.add(displaySelectedDesignsButton);
        displayModeButtonGroup.add(displayActiveDesignsButton);
        JComboBox<String> parallelChartSelectionComboBox = new JComboBox<String>();
        ParallelChartFrameComboModel comboModel = new ParallelChartFrameComboModel(mainWindow, this.chartFrame, scatterPlot2D);
        parallelChartSelectionComboBox.setModel(comboModel);
        mainWindow.registerComboModel(comboModel);
        JPanel visibleDesignsPanel = new JPanel(new GridLayout(1, 2));
        visibleDesignsPanel.add(displayActiveDesignsButton);
        visibleDesignsPanel.add(parallelChartSelectionComboBox);
        displayModeSelectionPanel.add(displayAllDesignsButton);
        displayModeSelectionPanel.add(displaySelectedDesignsButton);
        displayModeSelectionPanel.add(visibleDesignsPanel);
        mainPanel.add((Component)displayModeSelectionPanel, "North");
        JPanel axisSettingsPanel = new JPanel(new GridLayout(1, 2));
        Scatter2DChartAxisPanel xAxisPanel = new Scatter2DChartAxisPanel(mainWindow, chartFrame, scatterChart2D, AxisType.X);
        Scatter2DChartAxisPanel yAxisPanel = new Scatter2DChartAxisPanel(mainWindow, chartFrame, scatterChart2D, AxisType.Y);
        axisSettingsPanel.add(yAxisPanel);
        axisSettingsPanel.add(xAxisPanel);
        mainPanel.add((Component)axisSettingsPanel, "Center");
        TitledSubPanel designDisplaySettingsPanelOuter = new TitledSubPanel("Design display settings");
        designDisplaySettingsPanelOuter.setLayout(new BorderLayout());
        JPanel designDisplaySettingsPanel = new JPanel(new BorderLayout());
        designDisplaySettingsPanelOuter.add((Component)designDisplaySettingsPanel, "West");
        designDisplaySettingsPanel.setLayout(new BorderLayout());
        JPanel designDisplaySettingsLabelPanel = new JPanel(new GridLayout(0, 1));
        JPanel designDisplaySettingsControlsPanel = new JPanel(new GridLayout(0, 1));
        designDisplaySettingsPanel.add((Component)designDisplaySettingsLabelPanel, "Center");
        designDisplaySettingsPanel.add((Component)designDisplaySettingsControlsPanel, "East");
        mainPanel.add((Component)designDisplaySettingsPanelOuter, "South");
        JLabel fgColorLabel = new JLabel("Foreground Color   ");
        JLabel bgColorLabel = new JLabel("Background Color   ");
        JLabel standardDesignColorLabel = new JLabel("Designs standard Color   ");
        JLabel selectedDesignColorLabel = new JLabel("Selected designs Color   ");
        JLabel dataPointSizeLabel = new JLabel("Data Point Size   ");
        ColorChoiceButton fgColorButton = this.buildColorChoiceButton("Foreground Color", scatterPlot2D::getDecorationsColor, scatterPlot2D::setDecorationsColor, chartFrame);
        ColorChoiceButton bgColorButton = this.buildColorChoiceButton("Background Color", scatterPlot2D::getBackGroundColor, scatterPlot2D::setBackGroundColor, chartFrame);
        ColorChoiceButton standardDesignColorButton = this.buildColorChoiceButton("Active Design Color", scatterPlot2D::getActiveDesignColor, scatterPlot2D::setActiveDesignColor, chartFrame);
        ColorChoiceButton selectedDesignColorButton = this.buildColorChoiceButton("Selected Design Color", scatterPlot2D::getSelectedDesignColor, scatterPlot2D::setSelectedDesignColor, chartFrame);
        RightAlignedSpinner dataPointSizeSpinner = new RightAlignedSpinner(new MinMaxSpinnerModel(1, 20));
        dataPointSizeSpinner.addChangeListener(changeEvent -> {
            int value = Integer.parseInt(dataPointSizeSpinner.getValue().toString());
            scatterPlot2D.setDotRadius(value);
            chartFrame.repaint();
        });
        dataPointSizeSpinner.setValue(scatterPlot2D.getDotRadius());
        designDisplaySettingsLabelPanel.add(fgColorLabel);
        designDisplaySettingsLabelPanel.add(bgColorLabel);
        designDisplaySettingsLabelPanel.add(standardDesignColorLabel);
        designDisplaySettingsLabelPanel.add(selectedDesignColorLabel);
        designDisplaySettingsControlsPanel.add(fgColorButton);
        designDisplaySettingsControlsPanel.add(bgColorButton);
        designDisplaySettingsControlsPanel.add(standardDesignColorButton);
        designDisplaySettingsControlsPanel.add(selectedDesignColorButton);
        JPanel dataPointPanel = new JPanel(new GridLayout(1, 2));
        dataPointPanel.add(dataPointSizeLabel);
        dataPointPanel.add(dataPointSizeSpinner);
        designDisplaySettingsPanel.add((Component)dataPointPanel, "South");
        JPanel panelForMainPanelAndLowerButtonsPanel = new JPanel(new BorderLayout());
        panelForMainPanelAndLowerButtonsPanel.add((Component)mainPanel, "Center");
        TitledSubPanel lowerButtonsPanel = new TitledSubPanel("Save / restore Settings");
        lowerButtonsPanel.setLayout(new GridLayout(1, 2));
        JButton setAsDefaultButton = new JButton("Set current settings as default");
        setAsDefaultButton.addActionListener(e -> scatterChart2D.setCurrentSettingsAsDefault());
        JButton loadFromDefaultButton = new JButton("Load default settings");
        loadFromDefaultButton.addActionListener(e -> {
            scatterChart2D.resetDisplaySettingsToDefault(mainWindow.getDataSheet());
            this.buildPanel(mainWindow, chartFrame, scatterChart2D);
        });
        lowerButtonsPanel.add(setAsDefaultButton);
        lowerButtonsPanel.add(loadFromDefaultButton);
        panelForMainPanelAndLowerButtonsPanel.add((Component)lowerButtonsPanel, "South");
        this.add((Component)panelForMainPanelAndLowerButtonsPanel, "Center");
        this.pack();
        this.repaint();
    }

    private JRadioButton buildDisplayModeButton(String label, int currentDisplayMode, int buttonDisplayMode, ScatterPlot2D plot, ChartFrame chartFrame) {
        JRadioButton displayAllDesignsButton = new JRadioButton(label, currentDisplayMode == buttonDisplayMode);
        displayAllDesignsButton.addActionListener(actionEvent -> {
            plot.setDisplayedDesignSelectionMode(buttonDisplayMode);
            chartFrame.repaint();
        });
        return displayAllDesignsButton;
    }

    private ColorChoiceButton buildColorChoiceButton(String label, Supplier<Color> getter, Consumer<Color> setter, ChartFrame chartFrame) {
        ColorChoiceButton colorChoiceButton = new ColorChoiceButton(getter.get(), label);
        colorChoiceButton.addActionListener(actionEvent -> {
            Color newColor = JColorChooser.showDialog(this, label, (Color)getter.get());
            if (newColor != null) {
                setter.accept(newColor);
                colorChoiceButton.setCurrentColor(newColor);
                chartFrame.repaint();
            }
        });
        return colorChoiceButton;
    }

    @Override
    public void dispose() {
        super.dispose();
        this.onClosed.run();
    }
}

