/*
 * Decompiled with CFR 0.152.
 */
package org.xdat.gui.dialogs;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Frame;
import java.awt.GridLayout;
import java.util.LinkedList;
import java.util.List;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JDialog;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import org.xdat.Main;
import org.xdat.actionListeners.chartFrames.ParameterSetSelectionDialogActionListener;
import org.xdat.chart.ParallelCoordinatesChart;
import org.xdat.gui.controls.CustomButton;
import org.xdat.gui.frames.ChartFrame;

public class ParameterSetSelectionDialog
extends JDialog {
    private List<JCheckBox> checkBoxes = new LinkedList<JCheckBox>();

    public ParameterSetSelectionDialog(Main mainWindow, ChartFrame chartFrame) {
        super((Frame)chartFrame, "Select active parameters");
        this.setModal(true);
        this.setLayout(new BorderLayout());
        JPanel mainPanel = new JPanel(new BorderLayout());
        JPanel controlsPanel = new JPanel(new BorderLayout());
        JPanel controlButtonsPanel = new JPanel(new FlowLayout(0));
        controlButtonsPanel.setPreferredSize(new Dimension(400, 50));
        JPanel checkBoxOuterPanel = new JPanel(new BorderLayout());
        JPanel checkBoxInnerPanel = new JPanel(new GridLayout(0, 1));
        JPanel buttonsPanel = new JPanel(new GridLayout(1, 2));
        CustomButton selectAllButton = new CustomButton("Select All", "images/selectAllButtonDefault.png", "images/selectAllButtonPressed.png", "Select All");
        CustomButton unselectAllButton = new CustomButton("Unselect All", "images/UnSelectAllButtonDefault.png", "images/UnSelectAllButtonPressed.png", "Unselect All");
        CustomButton invertSelectionButton = new CustomButton("Invert Selection", "images/reverseSelectionButtonDefault.png", "images/reverseSelectionButtonPressed.png", "Invert Selection");
        JButton cancelButton = new JButton("Cancel");
        JButton okButton = new JButton("Ok");
        ParameterSetSelectionDialogActionListener cmd = new ParameterSetSelectionDialogActionListener(chartFrame, this);
        selectAllButton.addActionListener(e -> cmd.setAllSelected(true));
        unselectAllButton.addActionListener(e -> cmd.setAllSelected(false));
        invertSelectionButton.addActionListener(cmd::invertSelection);
        cancelButton.addActionListener(cmd::cancel);
        okButton.addActionListener(cmd::ok);
        this.add((Component)mainPanel, "Center");
        mainPanel.add((Component)controlsPanel, "North");
        mainPanel.add((Component)new JScrollPane(checkBoxOuterPanel), "Center");
        mainPanel.add((Component)buttonsPanel, "South");
        checkBoxOuterPanel.add((Component)checkBoxInnerPanel, "North");
        controlsPanel.add((Component)controlButtonsPanel, "West");
        controlButtonsPanel.add(selectAllButton);
        controlButtonsPanel.add(unselectAllButton);
        controlButtonsPanel.add(invertSelectionButton);
        buttonsPanel.add(cancelButton);
        buttonsPanel.add(okButton);
        ParallelCoordinatesChart c = (ParallelCoordinatesChart)chartFrame.getChart();
        for (int i = 0; i < mainWindow.getDataSheet().getParameterCount(); ++i) {
            JCheckBox cb = new JCheckBox(mainWindow.getDataSheet().getParameter(i).getName(), c.getAxis(i).isActive());
            this.checkBoxes.add(cb);
            checkBoxInnerPanel.add(cb);
        }
        Dimension screenSize = this.getToolkit().getScreenSize();
        this.setSize(new Dimension(350, 400));
        int yPos = (int)(0.5 * ((double)screenSize.height - this.getSize().getHeight()));
        int xPos = (int)(0.5 * ((double)screenSize.width - this.getSize().getWidth()));
        this.setLocation(xPos, yPos);
        this.setVisible(true);
    }

    public JCheckBox getCheckBox(int index) {
        return this.checkBoxes.get(index);
    }

    public int getCheckBoxCount() {
        return this.checkBoxes.size();
    }
}

