/*
 * Decompiled with CFR 0.152.
 */
package org.xdat.gui.dialogs;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Frame;
import java.awt.GridLayout;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JTabbedPane;
import org.xdat.Main;
import org.xdat.chart.ParallelCoordinatesChart;
import org.xdat.gui.WindowClosingAdapter;
import org.xdat.gui.frames.ChartFrame;
import org.xdat.gui.panels.AxisDisplaySettingsPanel;
import org.xdat.gui.panels.PaddedPanel;
import org.xdat.gui.panels.SettingsGroupPanel;
import org.xdat.settings.SettingsGroup;

public class ParallelCoordinatesDisplaySettingsDialog
extends JDialog {
    static final long serialVersionUID = 2L;
    private Main mainWindow;
    private AxisDisplaySettingsPanel axisDisplaySettingsPanel;

    public ParallelCoordinatesDisplaySettingsDialog(Main mainWindow) {
        super(mainWindow, "Parallel Coord Settings", true);
        this.mainWindow = mainWindow;
        SettingsGroup generalSettingsGroup = this.mainWindow.getGeneralSettingsGroup();
        SettingsGroupPanel chartDisplaySettingsPanel = new SettingsGroupPanel(generalSettingsGroup);
        this.axisDisplaySettingsPanel = new AxisDisplaySettingsPanel(mainWindow.getParallelCoordinatesAxisSettingsGroup());
        this.buildDialog(chartDisplaySettingsPanel);
        this.setVisible(true);
    }

    public ParallelCoordinatesDisplaySettingsDialog(Main mainWindow, ParallelCoordinatesChart chart, ChartFrame chartFrame) {
        super((Frame)chartFrame, "Display Settings");
        this.setModal(true);
        this.mainWindow = mainWindow;
        SettingsGroup settingsGroup = chart.getChartSettingsGroup();
        SettingsGroupPanel chartDisplaySettingsPanel = new SettingsGroupPanel(settingsGroup);
        this.axisDisplaySettingsPanel = new AxisDisplaySettingsPanel(chart.getAxes());
        this.buildDialog(chartDisplaySettingsPanel);
        this.setVisible(true);
    }

    private void buildDialog(SettingsGroupPanel generalSettingsGroupPanel) {
        this.addWindowListener(new WindowClosingAdapter(false));
        this.setResizable(false);
        JTabbedPane tabbedPane = new JTabbedPane();
        this.setLayout(new BorderLayout());
        this.add((Component)tabbedPane, "Center");
        tabbedPane.add("General", generalSettingsGroupPanel);
        tabbedPane.add("Axis-specific", this.axisDisplaySettingsPanel);
        JButton cancelButton = new JButton("Cancel");
        JButton okButton = new JButton("Ok");
        PaddedPanel mainButtonsPanel = new PaddedPanel(5);
        mainButtonsPanel.setLayout(new GridLayout(1, 2));
        mainButtonsPanel.add(cancelButton);
        mainButtonsPanel.add(okButton);
        okButton.addActionListener(actionEvent -> {
            generalSettingsGroupPanel.applyAll();
            this.axisDisplaySettingsPanel.applyAll();
            this.dispose();
        });
        cancelButton.addActionListener(actionEvent -> this.dispose());
        this.add((Component)mainButtonsPanel, "South");
        this.pack();
        int left = (int)(0.5 * (double)this.mainWindow.getSize().width) - (int)((double)this.getSize().width * 0.5) + this.mainWindow.getLocation().x;
        int top = (int)(0.5 * (double)this.mainWindow.getSize().height) - (int)((double)this.getSize().height * 0.5) + this.mainWindow.getLocation().y;
        this.setLocation(left, top);
    }
}

