/*
 * Decompiled with CFR 0.152.
 */
package org.xdat.gui.dialogs;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.Insets;
import java.awt.Window;
import java.io.BufferedReader;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.charset.StandardCharsets;
import java.util.stream.Collectors;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;

public class LicenseDisplayDialog
extends JDialog {
    static final long serialVersionUID = 1L;

    public LicenseDisplayDialog(Window parent) {
        super(parent);
        this.setTitle("GNU GENERAL PUBLIC LICENSE");
        JTextArea licenseTextArea = new JTextArea(this.getLicenseText());
        licenseTextArea.setLineWrap(true);
        licenseTextArea.setWrapStyleWord(true);
        licenseTextArea.setMargin(new Insets(5, 5, 5, 5));
        this.setModal(true);
        this.setDefaultCloseOperation(2);
        JPanel licenseDisplayPanel = new JPanel();
        licenseDisplayPanel.setLayout(new BorderLayout());
        JScrollPane scrollPane = new JScrollPane(licenseTextArea);
        licenseDisplayPanel.add((Component)scrollPane, "Center");
        JPanel buttonsPanel = new JPanel();
        buttonsPanel.setLayout(new FlowLayout(1));
        JButton okButton = new JButton("Ok");
        okButton.addActionListener(actionEvent -> {
            this.setVisible(false);
            this.dispose();
        });
        buttonsPanel.add(okButton);
        licenseDisplayPanel.add((Component)buttonsPanel, "South");
        this.add(licenseDisplayPanel);
        this.setSize(500, (int)((double)this.getToolkit().getScreenSize().height * 0.6));
        int left = (int)((double)this.getToolkit().getScreenSize().width * 0.5 - (double)this.getWidth() * 0.5);
        int top = (int)((double)this.getToolkit().getScreenSize().height * 0.5 - (double)this.getHeight() * 0.5);
        this.setLocation(left, top);
        this.validate();
    }

    private String getLicenseText() {
        InputStream inputStream = this.getClass().getResourceAsStream("LICENSE.txt");
        BufferedReader in = new BufferedReader(new InputStreamReader(inputStream, StandardCharsets.UTF_8));
        return in.lines().collect(Collectors.joining("\n"));
    }
}

