/*
 * Decompiled with CFR 0.152.
 */
package org.xdat.gui.controls;

import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.GridLayout;
import java.awt.Image;
import java.awt.MediaTracker;
import java.awt.Toolkit;
import java.net.URL;
import javax.swing.JButton;
import org.xdat.Main;

public class CustomButton
extends JButton {
    private Image imgDefault;
    private Image imgPressed;

    public CustomButton(String toolTip, String pathToDefaultImage, String pathToPressedImage, String actionCommand) {
        this.setToolTipText(toolTip);
        URL urlDefault = Main.class.getResource(pathToDefaultImage);
        URL urlPressed = Main.class.getResource(pathToPressedImage);
        this.imgDefault = null;
        this.imgPressed = null;
        Toolkit tk = Toolkit.getDefaultToolkit();
        try {
            MediaTracker m = new MediaTracker(this);
            this.imgDefault = tk.getImage(urlDefault);
            m.addImage(this.imgDefault, 0);
            this.imgPressed = tk.getImage(urlPressed);
            m.addImage(this.imgPressed, 0);
            m.waitForAll();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        this.setActionCommand(actionCommand);
        this.setLayout(new GridLayout(1, 1));
        this.setPreferredSize(new Dimension(this.imgDefault.getWidth(this), this.imgDefault.getHeight(this)));
    }

    @Override
    public void paintComponent(Graphics g) {
        super.paintComponent(g);
        if (this.getModel().isPressed()) {
            g.drawImage(this.imgPressed, 0, 0, this);
        } else {
            g.drawImage(this.imgDefault, 0, 0, this);
        }
    }
}

