/*
 * Decompiled with CFR 0.152.
 */
package org.xdat.gui.controls;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.GridLayout;
import javax.swing.JButton;
import org.jetbrains.annotations.Nullable;

public class ColorChoiceButton
extends JButton {
    private Color currentColor;
    private final int width;
    private final int height;

    public ColorChoiceButton(Color currentColor) {
        this(currentColor, null, 16, 16);
    }

    public ColorChoiceButton(Color currentColor, @Nullable String actionCommand) {
        this(currentColor, actionCommand, 16, 16);
    }

    public ColorChoiceButton(Color currentColor, @Nullable String actionCommand, int width, int height) {
        this.currentColor = currentColor;
        this.width = width;
        this.height = height;
        if (actionCommand != null) {
            this.setActionCommand(actionCommand);
        }
        this.setLayout(new GridLayout(1, 1));
        this.setPreferredSize(new Dimension(this.width, this.height));
    }

    @Override
    public void paintComponent(Graphics g) {
        super.paintComponent(g);
        g.setColor(this.currentColor);
        g.fillRect(0, 0, this.width, this.height);
    }

    public void setCurrentColor(Color currentColor) {
        this.currentColor = currentColor;
        this.repaint();
    }

    public Color getCurrentColor() {
        return this.currentColor;
    }

    public void setAlpha(int alpha) {
        this.currentColor = new Color(this.currentColor.getRed(), this.currentColor.getGreen(), this.currentColor.getBlue(), alpha);
        this.repaint();
    }
}

