/*
 * Decompiled with CFR 0.152.
 */
package org.xdat.data;

import java.awt.FontMetrics;
import java.io.Serializable;
import java.util.Comparator;
import java.util.Iterator;
import java.util.Optional;
import java.util.TreeSet;
import java.util.stream.Collectors;
import org.xdat.data.DataSheet;
import org.xdat.data.Design;
import org.xdat.data.NumberParser;
import org.xdat.data.ParameterType;
import org.xdat.exceptions.CorruptDataException;

public class Parameter
implements Serializable {
    static final long serialVersionUID = 4L;
    private String name;
    private boolean numeric = true;
    private TreeSet<String> discreteLevels = new TreeSet<String>(new ReverseStringComparator());
    private int ticLabelDigitCount = 3;

    public Parameter(String name, DataSheet dataSheet) {
        this.name = name;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    boolean isMixed(DataSheet dataSheet) {
        return this.getType(dataSheet) == ParameterType.MIXED;
    }

    private ParameterType getType(DataSheet dataSheet) {
        boolean foundNumericValue = false;
        boolean foundStringValue = false;
        for (Design design : dataSheet.getDesigns()) {
            String string = design.getStringValue(this);
            if (NumberParser.parseNumber(string).isPresent()) {
                foundNumericValue = true;
            } else {
                foundStringValue = true;
            }
            if (!foundNumericValue || !foundStringValue) continue;
            return ParameterType.MIXED;
        }
        if (foundStringValue) {
            return ParameterType.NON_NUMERIC;
        }
        if (foundNumericValue) {
            return ParameterType.NUMERIC;
        }
        return ParameterType.NUMERIC;
    }

    public boolean isNumeric() {
        return this.numeric;
    }

    void setNumeric(boolean numeric, DataSheet dataSheet) {
        if (numeric == this.numeric) {
            return;
        }
        this.numeric = numeric;
        this.updateDiscreteLevels(dataSheet);
    }

    double getDoubleValueOf(String string) {
        Optional<Float> parsed;
        if (this.numeric && (parsed = NumberParser.parseNumber(string)).isPresent()) {
            return parsed.get().floatValue();
        }
        int index = 0;
        Iterator<String> it = this.discreteLevels.iterator();
        while (it.hasNext()) {
            if (string.equalsIgnoreCase(it.next())) {
                return index;
            }
            ++index;
        }
        this.discreteLevels.add(string);
        index = 0;
        for (String next : this.discreteLevels) {
            if (string.equalsIgnoreCase(next)) {
                return index;
            }
            ++index;
        }
        throw new CorruptDataException(this);
    }

    public String getStringValueOf(double value) {
        if (this.numeric) {
            return Double.toString(value);
        }
        int index = (int)value;
        int currentIndex = 0;
        for (String next : this.discreteLevels) {
            if (currentIndex == index) {
                return next;
            }
            ++currentIndex;
        }
        throw new CorruptDataException(this);
    }

    public int getDiscreteLevelCount() {
        if (this.isNumeric()) {
            throw new RuntimeException("Parameter " + this.name + " is numeric!");
        }
        return this.discreteLevels.size();
    }

    void updateNumeric(DataSheet dataSheet) {
        this.setNumeric(this.getType(dataSheet) == ParameterType.NUMERIC, dataSheet);
    }

    void updateDiscreteLevels(DataSheet dataSheet) {
        this.discreteLevels.clear();
        if (this.isNumeric()) {
            return;
        }
        this.discreteLevels.addAll(dataSheet.getDesigns().stream().map(d -> d.getStringValue(this)).collect(Collectors.toSet()));
    }

    public void setTicLabelDigitCount(int value) {
        this.ticLabelDigitCount = value;
    }

    public int getTicLabelDigitCount() {
        return this.ticLabelDigitCount;
    }

    public String getTicLabelFormat() {
        int digitCount = this.getTicLabelDigitCount();
        return "%" + (digitCount + 1) + "." + digitCount + "f";
    }

    public int getLongestTicLabelStringLength(FontMetrics fm, String numberFormat, DataSheet dataSheet) {
        if (this.isNumeric()) {
            double minValue = Double.POSITIVE_INFINITY;
            double maxValue = Double.NEGATIVE_INFINITY;
            for (int i = 0; i < dataSheet.getDesignCount(); ++i) {
                if (dataSheet.getDesign(i).getDoubleValue(this) > maxValue) {
                    maxValue = dataSheet.getDesign(i).getDoubleValue(this);
                }
                if (!(dataSheet.getDesign(i).getDoubleValue(this) < minValue)) continue;
                minValue = dataSheet.getDesign(i).getDoubleValue(this);
            }
            int minLength = fm.stringWidth(String.format(numberFormat, minValue));
            int maxLength = fm.stringWidth(String.format(numberFormat, maxValue));
            return Math.max(minLength, maxLength);
        }
        int length = 0;
        for (int i = 0; i < this.getDiscreteLevelCount(); ++i) {
            int tempLength = fm.stringWidth(this.getStringValueOf(i));
            if (tempLength <= length) continue;
            length = tempLength;
        }
        return length;
    }

    public String toString() {
        return this.name;
    }

    private static class ReverseStringComparator
    implements Comparator<String>,
    Serializable {
        static final long serialVersionUID = 0L;

        private ReverseStringComparator() {
        }

        @Override
        public int compare(String s1, String s2) {
            return s2.compareToIgnoreCase(s1);
        }
    }
}

