/*
 * Decompiled with CFR 0.152.
 */
package org.xdat.data;

import java.awt.Color;
import java.io.Serializable;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import org.jetbrains.annotations.Nullable;
import org.xdat.chart.Axis;
import org.xdat.chart.Filter;
import org.xdat.chart.ParallelCoordinatesChart;
import org.xdat.data.Cluster;
import org.xdat.data.DataSheet;
import org.xdat.data.NumberParser;
import org.xdat.data.Parameter;

public class Design
implements Serializable {
    static final long serialVersionUID = 4L;
    private final Map<Parameter, String> stringParameterValues = new HashMap<Parameter, String>(0, 1.0f);
    private final Map<Parameter, Float> numericalParameterValues = new HashMap<Parameter, Float>(0, 1.0f);
    private final int id;
    @Nullable
    private Cluster cluster = null;
    private final Map<Filter, Boolean> activationMap = new HashMap<Filter, Boolean>();
    private boolean insideBounds;
    private boolean selected = false;
    private Color gradientColor = null;

    public Design(int id) {
        this.id = id;
    }

    public void setValue(Parameter param, String parameterValue, DataSheet dataSheet) {
        Optional<Float> parsed = NumberParser.parseNumber(parameterValue);
        if (parsed.isPresent()) {
            this.numericalParameterValues.put(param, parsed.get());
            this.stringParameterValues.remove(param);
        } else {
            param.setNumeric(false, dataSheet);
            this.stringParameterValues.put(param, parameterValue);
            this.numericalParameterValues.remove(param);
        }
    }

    public double getDoubleValue(Parameter param) {
        if (this.stringParameterValues.containsKey(param)) {
            return param.getDoubleValueOf(this.stringParameterValues.get(param));
        }
        if (this.numericalParameterValues.containsKey(param) && param.isNumeric()) {
            return this.numericalParameterValues.get(param).floatValue();
        }
        if (this.numericalParameterValues.containsKey(param)) {
            return param.getDoubleValueOf(Float.toString(this.numericalParameterValues.get(param).floatValue()));
        }
        throw new IllegalArgumentException("Unknown parameter " + param.getName());
    }

    public String getStringValue(Parameter param) {
        if (this.stringParameterValues.containsKey(param)) {
            return this.stringParameterValues.get(param);
        }
        if (this.numericalParameterValues.containsKey(param)) {
            return Float.toString(this.numericalParameterValues.get(param).floatValue());
        }
        throw new IllegalArgumentException("Unknown parameter " + param.getName());
    }

    public boolean isActive(ParallelCoordinatesChart chart) {
        for (int i = 0; i < chart.getAxisCount(); ++i) {
            Filter uf = chart.getAxis(i).getUpperFilter();
            Filter lf = chart.getAxis(i).getLowerFilter();
            if (!this.activationMap.containsKey(uf)) {
                this.activationMap.put(uf, true);
            }
            if (!this.activationMap.containsKey(lf)) {
                this.activationMap.put(lf, true);
            }
            if (chart.getAxis(i).isFilterInverted()) {
                if (this.activationMap.get(uf).booleanValue() || this.activationMap.get(lf).booleanValue()) continue;
                return false;
            }
            if (!this.activationMap.get(uf).booleanValue()) {
                return false;
            }
            if (this.activationMap.get(lf).booleanValue()) continue;
            return false;
        }
        return true;
    }

    public void setActive(Filter filter, boolean active) {
        this.activationMap.put(filter, active);
    }

    public void evaluateBounds(ParallelCoordinatesChart chart) {
        this.insideBounds = true;
        for (int i = 0; i < chart.getAxisCount(); ++i) {
            if (this.isInsideBounds(chart.getAxis(i))) continue;
            this.insideBounds = false;
            return;
        }
    }

    private boolean isInsideBounds(Axis axis) {
        double value = this.getDoubleValue(axis.getParameter());
        double max = axis.getMax();
        double min = axis.getMin();
        return min <= value && value <= max;
    }

    public boolean isInsideBounds(ParallelCoordinatesChart chart) {
        return this.insideBounds;
    }

    public boolean isSelected() {
        return this.selected;
    }

    public void setSelected(boolean selected) {
        this.selected = selected;
    }

    public int getId() {
        return this.id;
    }

    @Nullable
    public Cluster getCluster() {
        return this.cluster;
    }

    public void setCluster(@Nullable Cluster cluster) {
        this.cluster = cluster;
    }

    public Color getGradientColor() {
        return this.gradientColor;
    }

    public void setAxisGradientColor(Color gradientColor) {
        this.gradientColor = gradientColor;
    }

    public void removeAxisGradientColor() {
        this.gradientColor = null;
    }

    public boolean hasGradientColor() {
        return this.gradientColor != null;
    }

    public int computeValuesHash(List<Parameter> parameters) {
        return Objects.hash(parameters.stream().map(p -> new ParameterValue((Parameter)p, this.getStringValue((Parameter)p))).toArray());
    }

    private static class ParameterValue {
        private final Parameter parameter;
        private final String value;

        private ParameterValue(Parameter parameter, String value) {
            this.parameter = parameter;
            this.value = value;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            ParameterValue that = (ParameterValue)o;
            return Objects.equals(this.parameter, that.parameter) && Objects.equals(this.value, that.value);
        }

        public int hashCode() {
            return Objects.hash(this.parameter, this.value);
        }
    }
}

