/*
 * Decompiled with CFR 0.152.
 */
package org.xdat.data;

import java.io.BufferedReader;
import java.io.FileReader;
import java.io.IOException;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.function.Consumer;
import javax.swing.JOptionPane;
import javax.swing.ProgressMonitor;
import org.jetbrains.annotations.Nullable;
import org.xdat.Main;
import org.xdat.UserPreferences;
import org.xdat.chart.ParallelCoordinatesChart;
import org.xdat.data.Cluster;
import org.xdat.data.ClusterSet;
import org.xdat.data.DatasheetListener;
import org.xdat.data.Design;
import org.xdat.data.NumberParser;
import org.xdat.data.Parameter;
import org.xdat.exceptions.InconsistentDataException;

public class DataSheet
implements Serializable {
    static final long serialVersionUID = 8L;
    private List<Design> data = new ArrayList<Design>();
    private Map<Integer, Design> designIdsMap = new HashMap<Integer, Design>();
    private final List<Parameter> parameters = new LinkedList<Parameter>();
    private transient List<DatasheetListener> listeners;
    private String delimiter;

    public void initTransientData() {
        this.listeners = new ArrayList<DatasheetListener>();
    }

    public DataSheet(String pathToInputFile, boolean dataHasHeaders, Main mainWindow, ProgressMonitor progressMonitor) throws IOException {
        this.initTransientData();
        UserPreferences userPreferences = UserPreferences.getInstance();
        this.delimiter = userPreferences.getDelimiter();
        if (userPreferences.isTreatConsecutiveAsOne()) {
            this.delimiter = this.delimiter + "+";
        }
        this.importData(pathToInputFile, dataHasHeaders, progressMonitor);
        boolean continueChecking = true;
        for (Parameter parameter : this.parameters) {
            if (parameter.isMixed(this) && continueChecking) {
                int userAction = JOptionPane.showConfirmDialog(mainWindow, "Parameter " + parameter.getName() + " has numeric values in some designs\nand non-numerical values in others. \nThis will result in the parameter being treated as a \nnon-numeric parameter. \nIf this is incorrect it is recommended to find the design(s)\nwith non-numeric values and correct or remove them.\n\nPress Ok to continue checking parameters or Cancel to\nsuppress further warnings.", "Mixed Parameter Warning", 2, 2);
                continueChecking = userAction == 0;
            }
            parameter.setTicLabelDigitCount(userPreferences.getParallelCoordinatesAxisTicLabelDigitCount());
        }
    }

    private void importData(String pathToInputFile, boolean dataHasHeaders, ProgressMonitor progressMonitor) throws IOException {
        ArrayList<Object> buffer = new ArrayList();
        if (this.data != null) {
            buffer = new ArrayList<Design>(this.data);
        }
        int lineCount = this.getLineCount(pathToInputFile);
        progressMonitor.setMaximum(lineCount);
        int idCounter = 1;
        BufferedReader f = new BufferedReader(new FileReader(pathToInputFile));
        String line = f.readLine().trim();
        String[] lineElements = line.split(this.delimiter);
        if (dataHasHeaders) {
            for (String lineElement : lineElements) {
                this.parameters.add(new Parameter(this.getUniqueParameterName(lineElement), this));
            }
        } else {
            Design newDesign = new Design(idCounter++);
            for (int i = 0; i < lineElements.length; ++i) {
                this.parameters.add(new Parameter("Parameter " + (i + 1), this));
                newDesign.setValue(this.parameters.get(i), lineElements[i], this);
            }
            this.data.add(newDesign);
            this.designIdsMap.put(newDesign.getId(), newDesign);
            progressMonitor.setProgress(idCounter - 1);
        }
        try {
            this.readDesignsFromFile(progressMonitor, f, idCounter);
        }
        catch (IOException e) {
            this.data = buffer;
            throw e;
        }
        f.close();
        if (progressMonitor.isCanceled()) {
            this.data = buffer;
        }
        for (Parameter parameter : this.parameters) {
            parameter.updateDiscreteLevels(this);
        }
    }

    public void updateData(String pathToInputFile, boolean dataHasHeaders, ProgressMonitor progressMonitor, ClusterSet clusterSet) throws IOException, InconsistentDataException {
        int lineCount = this.getLineCount(pathToInputFile);
        progressMonitor.setMaximum(lineCount);
        int idCounter = 1;
        BufferedReader f = new BufferedReader(new FileReader(pathToInputFile));
        String line = f.readLine().trim();
        String[] lineElements = line.split(this.delimiter);
        if (lineElements.length != this.getParameterCount()) {
            f.close();
            throw new InconsistentDataException(pathToInputFile);
        }
        ArrayList<Design> buffer = new ArrayList<Design>(this.data);
        HashMap<Integer, Design> idbuffer = new HashMap<Integer, Design>(this.designIdsMap);
        Map<Integer, Set<Integer>> clustersToDesignHashes = this.computeClusterDesignHashes(this.data);
        this.data.clear();
        this.designIdsMap.clear();
        if (dataHasHeaders) {
            for (Parameter parameter : this.parameters) {
                parameter.setName(null);
            }
            for (int i = 0; i < lineElements.length; ++i) {
                this.parameters.get(i).setName(this.getUniqueParameterName(lineElements[i]));
            }
        } else {
            Design newDesign = new Design(idCounter++);
            for (int i = 0; i < this.parameters.size(); ++i) {
                if (lineElements.length <= i) {
                    newDesign.setValue(this.parameters.get(i), "-", this);
                    continue;
                }
                this.parameters.get(i).setName("Parameter " + (i + 1));
                newDesign.setValue(this.parameters.get(i), lineElements[i], this);
            }
            this.data.add(newDesign);
            this.designIdsMap.put(newDesign.getId(), newDesign);
        }
        try {
            this.readDesignsFromFile(progressMonitor, f, idCounter);
        }
        catch (IOException e) {
            this.data = buffer;
            this.designIdsMap = idbuffer;
            throw e;
        }
        f.close();
        if (progressMonitor.isCanceled()) {
            this.data = buffer;
            this.designIdsMap = idbuffer;
        }
        for (Parameter parameter : this.parameters) {
            parameter.updateNumeric(this);
            parameter.updateDiscreteLevels(this);
        }
        this.restoreClustersFromHashes(clustersToDesignHashes, this.data, clusterSet);
        this.fireOnDataChanged(this.initialiseBooleanArray(true), this.initialiseBooleanArray(true), this.initialiseBooleanArray(true), false);
        this.fireDataPanelUpdateRequired();
    }

    private void restoreClustersFromHashes(Map<Integer, Set<Integer>> clustersToDesignHashes, List<Design> designs, ClusterSet clusterSet) {
        for (Map.Entry<Integer, Set<Integer>> entry : clustersToDesignHashes.entrySet()) {
            Integer clusterId = entry.getKey();
            Set<Integer> designHashes = entry.getValue();
            clusterSet.findClusterById(clusterId).ifPresent(cluster -> {
                for (Design design : designs) {
                    if (!designHashes.contains(design.computeValuesHash(this.parameters))) continue;
                    design.setCluster((Cluster)cluster);
                }
            });
        }
    }

    private Map<Integer, Set<Integer>> computeClusterDesignHashes(List<Design> designs) {
        HashMap<Integer, Set<Integer>> clustersToDesignHashes = new HashMap<Integer, Set<Integer>>();
        for (Design design : designs) {
            @Nullable Cluster cluster = design.getCluster();
            if (cluster == null) continue;
            clustersToDesignHashes.computeIfAbsent(cluster.getUniqueId(), k -> new HashSet()).add(design.computeValuesHash(this.parameters));
        }
        return clustersToDesignHashes;
    }

    private void readDesignsFromFile(ProgressMonitor progressMonitor, BufferedReader f, int idCounter) throws IOException {
        String line;
        while ((line = f.readLine()) != null && !progressMonitor.isCanceled()) {
            progressMonitor.setProgress(idCounter - 1);
            String[] lineElements = line.split(this.delimiter);
            if (lineElements.length <= 0) continue;
            Design newDesign = new Design(idCounter++);
            boolean newDesignContainsValues = false;
            for (String lineElement : lineElements) {
                if (lineElement.length() <= 0 || lineElement.equals("\\s")) continue;
                newDesignContainsValues = true;
                break;
            }
            if (!newDesignContainsValues) continue;
            for (int i = 0; i < this.parameters.size(); ++i) {
                if (lineElements.length <= i || lineElements[i].length() <= 0 || lineElements[i].equals("\\s")) {
                    newDesign.setValue(this.parameters.get(i), "-", this);
                    continue;
                }
                newDesign.setValue(this.parameters.get(i), lineElements[i], this);
            }
            this.data.add(newDesign);
            this.designIdsMap.put(newDesign.getId(), newDesign);
        }
    }

    public void setValueAt(Object newValue, int rowIndex, int columnIndex) {
        Parameter parameter = this.parameters.get(columnIndex - 1);
        boolean previousNumeric = parameter.isNumeric();
        boolean[] axisAutofitRequired = this.initialiseBooleanArray(false);
        boolean[] axisResetFilterRequired = this.initialiseBooleanArray(false);
        boolean[] axisApplyFiltersRequired = this.initialiseBooleanArray(false);
        this.data.get(rowIndex).setValue(this.parameters.get(columnIndex - 1), newValue.toString(), this);
        if (!previousNumeric) {
            parameter.updateDiscreteLevels(this);
        }
        Optional<Float> parsed = NumberParser.parseNumber(newValue.toString());
        boolean parsable = parsed.isPresent();
        if (previousNumeric && !parsable) {
            parameter.setNumeric(false, this);
        } else if (!previousNumeric && parsable) {
            parameter.updateNumeric(this);
        }
        if (previousNumeric != parameter.isNumeric()) {
            axisAutofitRequired[columnIndex - 1] = true;
            axisResetFilterRequired[columnIndex - 1] = true;
        }
        axisApplyFiltersRequired[columnIndex - 1] = true;
        this.fireOnDataChanged(axisAutofitRequired, axisResetFilterRequired, axisApplyFiltersRequired, false);
    }

    private int getLineCount(String pathToInputFile) throws IOException {
        BufferedReader f = new BufferedReader(new FileReader(pathToInputFile));
        int lineCount = 0;
        while (f.readLine() != null) {
            ++lineCount;
        }
        f.close();
        return lineCount;
    }

    public Design getDesign(int i) {
        return this.data.get(i);
    }

    public Design getDesignByID(int id) {
        return this.designIdsMap.get(id);
    }

    public void removeDesigns(int[] designsToRemove) {
        int i;
        boolean[] axisAutofitRequired = this.initialiseBooleanArray(false);
        boolean[] axisResetFilterRequired = this.initialiseBooleanArray(false);
        boolean[] axisApplyFiltersRequired = this.initialiseBooleanArray(false);
        boolean[] discrete = new boolean[this.parameters.size()];
        for (i = 0; i < this.parameters.size(); ++i) {
            discrete[i] = !this.parameters.get(i).isNumeric();
        }
        for (i = designsToRemove.length - 1; i >= 0; --i) {
            Design removedDesign = this.data.remove(designsToRemove[i]);
            this.designIdsMap.remove(removedDesign.getId());
            for (Parameter parameter : this.parameters) {
                String string;
                if (parameter.isNumeric() || NumberParser.parseNumber(string = removedDesign.getStringValue(parameter)).isPresent()) continue;
                parameter.updateNumeric(this);
                parameter.updateDiscreteLevels(this);
            }
        }
        for (i = 0; i < this.parameters.size(); ++i) {
            axisAutofitRequired[i] = discrete[i] && this.parameters.get(i).isNumeric();
            axisApplyFiltersRequired[i] = true;
        }
        this.fireOnDataChanged(axisAutofitRequired, axisResetFilterRequired, axisApplyFiltersRequired, false);
        this.fireDataPanelUpdateRequired();
    }

    public int getParameterCount() {
        return this.parameters.size();
    }

    public String getParameterName(int index) {
        if (index >= this.parameters.size() || index < 0) {
            throw new IllegalArgumentException("Invalid Index " + index);
        }
        return this.parameters.get(index).getName();
    }

    public Parameter getParameter(int index) {
        if (index >= this.parameters.size() || index < 0) {
            throw new IllegalArgumentException("Invalid Index " + index);
        }
        return this.parameters.get(index);
    }

    public Parameter getParameter(String parameterName) {
        for (Parameter parameter : this.parameters) {
            if (!parameterName.equals(parameter.getName())) continue;
            return parameter;
        }
        throw new IllegalArgumentException("Parameter " + parameterName + " not found");
    }

    public void removeParameter(String parameterName) {
        boolean removed = this.parameters.removeIf(p -> p.getName().equals(parameterName));
        if (removed) {
            this.fireDataPanelUpdateRequired();
            this.fireOnDataChanged(false, false, false, true);
        }
    }

    public int getParameterIndex(String parameterName) {
        for (int i = 0; i < this.parameters.size(); ++i) {
            if (!parameterName.equals(this.parameters.get(i).getName())) continue;
            return i;
        }
        throw new IllegalArgumentException("Parameter " + parameterName + " not found");
    }

    public boolean parameterExists(Parameter param) {
        return this.parameters.contains(param);
    }

    public double getMaxValueOf(Parameter param) {
        if (param.isNumeric()) {
            double max = Double.NEGATIVE_INFINITY;
            for (Design datum : this.data) {
                if (!(max < datum.getDoubleValue(param))) continue;
                max = datum.getDoubleValue(param);
            }
            return max;
        }
        return param.getDiscreteLevelCount() - 1;
    }

    public double getMinValueOf(Parameter param) {
        if (param.isNumeric()) {
            double min = Double.POSITIVE_INFINITY;
            for (Design datum : this.data) {
                if (!(min > datum.getDoubleValue(param))) continue;
                min = datum.getDoubleValue(param);
            }
            return min;
        }
        return 0.0;
    }

    public int getDesignCount() {
        return this.data.size();
    }

    private String getUniqueParameterName(String nameSuggestion) {
        String name = nameSuggestion;
        int id = 2;
        while (!this.isNameUnique(name)) {
            name = nameSuggestion + " (" + id++ + ")";
        }
        return name;
    }

    private boolean isNameUnique(String name) {
        boolean unique = true;
        for (Parameter parameter : this.parameters) {
            if (!name.equals(parameter.getName())) continue;
            unique = false;
            break;
        }
        return unique;
    }

    public void evaluateBoundsForAllDesigns(ParallelCoordinatesChart chart) {
        for (int i = 0; i < this.getDesignCount(); ++i) {
            this.data.get(i).evaluateBounds(chart);
        }
    }

    public void moveParameter(int oldIndex, int newIndex) {
        Parameter param = this.parameters.remove(oldIndex);
        this.parameters.add(newIndex, param);
    }

    private boolean[] initialiseBooleanArray(boolean value) {
        boolean[] array = new boolean[this.getParameterCount()];
        for (int i = 0; i < this.getParameterCount(); ++i) {
            array[i] = value;
        }
        return array;
    }

    public void addListener(DatasheetListener l) {
        this.listeners.add(l);
    }

    public void removeListener(DatasheetListener l) {
        this.listeners.remove(l);
    }

    private void fireListeners(Consumer<DatasheetListener> action) {
        for (DatasheetListener listener : this.listeners) {
            action.accept(listener);
        }
    }

    void onClustersUpdated(List<Cluster> changed, List<Cluster> added, List<Cluster> removed) {
        for (Cluster removedCluster : removed) {
            for (int j = 0; j < this.getDesignCount(); ++j) {
                if (!removedCluster.equals(this.getDesign(j).getCluster())) continue;
                this.getDesign(j).setCluster(null);
            }
        }
        if (changed.isEmpty() && added.isEmpty() && removed.isEmpty()) {
            return;
        }
        this.fireClustersChanged();
    }

    public Collection<Design> getDesigns() {
        return Collections.unmodifiableList(this.data);
    }

    public List<Parameter> getParameters() {
        return Collections.unmodifiableList(this.parameters);
    }

    public void fireClustersChanged() {
        this.fireListeners(DatasheetListener::onClustersChanged);
    }

    public void fireDataPanelUpdateRequired() {
        this.fireListeners(DatasheetListener::onDataPanelUpdateRequired);
    }

    public void fireOnDataChanged(boolean axisAutofitRequired, boolean axisResetFilterRequired, boolean axisApplyFiltersRequired, boolean parametersChanged) {
        boolean[] autofit = new boolean[this.parameters.size()];
        boolean[] resetFilter = new boolean[this.parameters.size()];
        boolean[] applyFilters = new boolean[this.parameters.size()];
        Arrays.fill(autofit, axisAutofitRequired);
        Arrays.fill(resetFilter, axisResetFilterRequired);
        Arrays.fill(applyFilters, axisApplyFiltersRequired);
        this.fireOnDataChanged(autofit, resetFilter, applyFilters, parametersChanged);
    }

    public void fireOnDataChanged(boolean[] axisAutofitRequired, boolean[] axisResetFilterRequired, boolean[] axisApplyFiltersRequired, boolean parametersChanged) {
        this.fireListeners(l -> l.onDataChanged(axisAutofitRequired, axisResetFilterRequired, axisApplyFiltersRequired, parametersChanged));
    }
}

