/*
 * Decompiled with CFR 0.152.
 */
package org.xdat.data;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import org.xdat.data.Cluster;
import org.xdat.data.ClusterFactory;
import org.xdat.data.ClusterListener;
import org.xdat.data.DataSheet;
import org.xdat.gui.tables.ClusterTableModel;

public class ClusterSet
implements Serializable {
    static final long serialVersionUID = 1L;
    private DataSheet dataSheet;
    private final List<Cluster> clusters = new LinkedList<Cluster>();
    private transient Set<ClusterListener> listeners;
    private transient ClusterListener dispatchingListener;

    public ClusterSet() {
        this.initTransientData();
    }

    public ClusterSet(DataSheet dataSheet) {
        this();
        this.dataSheet = dataSheet;
    }

    public void newCluster(ClusterFactory factory) {
        Cluster newCluster = factory.newCluster(this.clusters);
        this.clusters.add(newCluster);
        newCluster.addClusterListener(this.dispatchingListener);
        this.dataSheet.onClustersUpdated(Collections.emptyList(), Collections.singletonList(newCluster), Collections.emptyList());
    }

    public Cluster getCluster(int i) {
        return this.clusters.get(i);
    }

    public Cluster getCluster(String clusterName) {
        for (Cluster cluster : this.clusters) {
            if (!cluster.getName().equals(clusterName)) continue;
            return cluster;
        }
        throw new IllegalArgumentException("Could not find cluster " + clusterName);
    }

    public Optional<Cluster> findClusterById(int id) {
        return this.clusters.stream().filter(c -> c.getUniqueId() == id).findAny();
    }

    public int getClusterCount() {
        return this.clusters.size();
    }

    public ClusterTableModel createTableModel(ClusterFactory factory) {
        return new ClusterTableModel(this.clusters, factory);
    }

    public void removeCluster(Cluster cluster) {
        boolean removed = this.clusters.remove(cluster);
        if (removed) {
            cluster.removeClusterListener(this.dispatchingListener);
            this.dataSheet.onClustersUpdated(Collections.emptyList(), Collections.emptyList(), Collections.singletonList(cluster));
        }
    }

    public List<Cluster> getClusters() {
        return this.clusters;
    }

    public void applyClustersBuffer(List<Cluster> clustersBuffer) {
        ArrayList<Cluster> removedClusters = new ArrayList<Cluster>();
        ArrayList<Cluster> changedClusters = new ArrayList<Cluster>();
        ArrayList<Cluster> addedClusters = new ArrayList<Cluster>();
        Iterator<Cluster> iterator = this.clusters.iterator();
        while (iterator.hasNext()) {
            Cluster next = iterator.next();
            if (clustersBuffer.contains(next)) continue;
            removedClusters.add(next);
            iterator.remove();
        }
        for (Cluster bufferedCluster : clustersBuffer) {
            Cluster existing = this.clusters.stream().filter(b -> b.equals(bufferedCluster)).findAny().orElse(null);
            if (existing == null) {
                Cluster added = bufferedCluster.duplicate();
                this.clusters.add(added);
                addedClusters.add(added);
                continue;
            }
            boolean changed = bufferedCluster.copySettingsTo(existing);
            if (!changed) continue;
            changedClusters.add(existing);
        }
        this.dataSheet.onClustersUpdated(changedClusters, addedClusters, removedClusters);
    }

    public void addClusterListener(ClusterListener l) {
        this.listeners.add(l);
    }

    public void removeClusterListener(ClusterListener l) {
        this.listeners.remove(l);
    }

    public void initTransientData() {
        this.listeners = new LinkedHashSet<ClusterListener>();
        this.dispatchingListener = new ClusterListener(){

            @Override
            public void onNameChanged(Cluster source) {
                for (ClusterListener listener : ClusterSet.this.listeners) {
                    listener.onNameChanged(source);
                }
            }

            @Override
            public void onColorChanged(Cluster source) {
                for (ClusterListener listener : ClusterSet.this.listeners) {
                    listener.onColorChanged(source);
                }
            }
        };
        for (Cluster cluster : this.clusters) {
            cluster.initTransientData();
        }
    }
}

