/*
 * Decompiled with CFR 0.152.
 */
package org.xdat.data;

import java.awt.Color;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import org.xdat.UserPreferences;
import org.xdat.data.ClusterListener;

public class Cluster
implements Serializable {
    static final long serialVersionUID = 1L;
    private String name;
    private Color activeDesignColor;
    private Color activeDesignColorNoAlpha;
    private boolean active = true;
    private int lineThickness = 1;
    private int uniqueId;
    private transient List<ClusterListener> clusterListeners;

    public Cluster(String name, int uniqueId) {
        this.name = name;
        this.uniqueId = uniqueId;
        this.activeDesignColor = UserPreferences.getInstance().getParallelCoordinatesActiveDesignDefaultColor();
        this.activeDesignColorNoAlpha = new Color(this.activeDesignColor.getRed(), this.activeDesignColor.getGreen(), this.activeDesignColor.getBlue());
        this.initTransientData();
    }

    public Color getActiveDesignColor(boolean useAlpha) {
        return useAlpha ? this.activeDesignColor : this.activeDesignColorNoAlpha;
    }

    public void setActiveDesignColor(Color activeDesignColor) {
        this.activeDesignColor = activeDesignColor;
        this.activeDesignColorNoAlpha = new Color(this.activeDesignColor.getRed(), this.activeDesignColor.getGreen(), this.activeDesignColor.getBlue());
        this.fireColorChanged();
    }

    public int getLineThickness() {
        return this.lineThickness;
    }

    public void setLineThickness(int lineThickness) {
        this.lineThickness = lineThickness;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
        this.fireNameChanged();
    }

    public boolean isActive() {
        return this.active;
    }

    public void setActive(boolean active) {
        this.active = active;
    }

    public Cluster duplicate() {
        Cluster duplication = new Cluster(this.name, this.uniqueId);
        duplication.setActive(this.active);
        duplication.setActiveDesignColor(this.activeDesignColor);
        duplication.setLineThickness(this.lineThickness);
        return duplication;
    }

    public boolean copySettingsTo(Cluster cluster) {
        boolean changed;
        boolean bl = changed = !Objects.equals(cluster.name, this.name) || cluster.active != this.active || !Objects.equals(cluster.activeDesignColor, this.activeDesignColor) || cluster.lineThickness != this.lineThickness;
        if (!changed) {
            return false;
        }
        cluster.setName(this.name);
        cluster.setActive(this.active);
        cluster.setActiveDesignColor(this.activeDesignColor);
        cluster.setLineThickness(this.lineThickness);
        return true;
    }

    public int getUniqueId() {
        return this.uniqueId;
    }

    public void addClusterListener(ClusterListener l) {
        this.clusterListeners.add(l);
    }

    public void removeClusterListener(ClusterListener l) {
        this.clusterListeners.remove(l);
    }

    private void fireNameChanged() {
        for (ClusterListener l : this.clusterListeners) {
            l.onNameChanged(this);
        }
    }

    private void fireColorChanged() {
        for (ClusterListener l : this.clusterListeners) {
            l.onColorChanged(this);
        }
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Cluster cluster = (Cluster)o;
        return this.uniqueId == cluster.uniqueId;
    }

    public int hashCode() {
        return Objects.hash(this.uniqueId);
    }

    void initTransientData() {
        this.clusterListeners = new ArrayList<ClusterListener>();
    }
}

