/*
 * Decompiled with CFR 0.152.
 */
package org.xdat.chart;

import java.awt.Color;
import java.util.HashMap;
import java.util.Map;
import org.jetbrains.annotations.Nullable;
import org.xdat.UserPreferences;
import org.xdat.chart.ParallelCoordinatesChart;
import org.xdat.chart.Plot;
import org.xdat.data.AxisType;
import org.xdat.data.Cluster;
import org.xdat.data.DataSheet;
import org.xdat.data.Design;
import org.xdat.data.Parameter;

public class ScatterPlot2D
extends Plot {
    static final long serialVersionUID = 4L;
    public static final int SHOW_ALL_DESIGNS = 0;
    public static final int SHOW_SELECTED_DESIGNS = 1;
    public static final int SHOW_DESIGNS_ACTIVE_IN_PARALLEL_CHART = 2;
    public static final int AXIS_LABEL_PADDING = 10;
    public static final int TIC_LABEL_PADDING = 5;
    public static final String TIC_LABEL_FORMAT = "%4.3f";
    private static final int TIC_SIZE = 5;
    private int displayedDesignSelectionMode = 0;
    @Nullable
    private ParallelCoordinatesChart parallelCoordinatesChartForFiltering;
    private int dotRadius = 4;
    private Color activeDesignColor = new Color(0, 150, 0);
    private Color selectedDesignColor = Color.BLUE;
    private Parameter parameterForXAxis;
    private Parameter parameterForYAxis;
    private final boolean showDecorations;
    private Color decorationsColor = Color.BLACK;
    private int ticCountX = 2;
    private int ticCountY = 2;
    private final Map<String, Double> minValues = new HashMap<String, Double>();
    private final Map<String, Double> maxValues = new HashMap<String, Double>();
    private int axisLabelFontSizeX = 20;
    private int axisLabelFontSizeY = 20;
    private int ticLabelFontSizeX = 12;
    private int ticLabelFontSizeY = 12;

    ScatterPlot2D(DataSheet dataSheet, boolean showDecorations) {
        this.showDecorations = showDecorations;
        if (dataSheet.getParameterCount() > 1) {
            this.parameterForXAxis = dataSheet.getParameter(0);
            this.parameterForYAxis = dataSheet.getParameter(1);
        } else if (dataSheet.getParameterCount() > 0) {
            this.parameterForXAxis = dataSheet.getParameter(0);
            this.parameterForYAxis = dataSheet.getParameter(0);
        }
        for (int i = 0; i < dataSheet.getParameterCount(); ++i) {
            this.autofitParam(dataSheet, dataSheet.getParameter(i));
        }
        this.resetDisplaySettingsToDefault();
    }

    public Color getDesignColor(Design design) {
        @Nullable Cluster cluster = design.getCluster();
        if (cluster != null) {
            return cluster.getActiveDesignColor(false);
        }
        return this.activeDesignColor;
    }

    public Color getActiveDesignColor() {
        return this.activeDesignColor;
    }

    public void setActiveDesignColor(Color activeDesignColor) {
        this.activeDesignColor = activeDesignColor;
    }

    public int getDisplayedDesignSelectionMode() {
        return this.displayedDesignSelectionMode;
    }

    public void setDisplayedDesignSelectionMode(int displayedDesignSelectionMode) {
        this.displayedDesignSelectionMode = displayedDesignSelectionMode;
    }

    @Nullable
    public ParallelCoordinatesChart getParallelCoordinatesChartForFiltering() {
        return this.parallelCoordinatesChartForFiltering;
    }

    public void setParallelCoordinatesChartForFiltering(@Nullable ParallelCoordinatesChart parallelCoordinatesChartForFiltering) {
        this.parallelCoordinatesChartForFiltering = parallelCoordinatesChartForFiltering;
    }

    public int getDotRadius() {
        return this.dotRadius;
    }

    public void setDotRadius(int dotRadius) {
        this.dotRadius = dotRadius;
    }

    public Color getSelectedDesignColor() {
        return this.selectedDesignColor;
    }

    public void setSelectedDesignColor(Color selectedDesignColor) {
        this.selectedDesignColor = selectedDesignColor;
    }

    public Parameter getParameterForAxis(AxisType axisType) {
        switch (axisType) {
            case X: {
                return this.parameterForXAxis;
            }
            case Y: {
                return this.parameterForYAxis;
            }
        }
        throw new IllegalArgumentException("Unknown axis type " + (Object)((Object)axisType));
    }

    public void setParameterForAxis(AxisType axisType, Parameter parameter) {
        switch (axisType) {
            case X: {
                this.parameterForXAxis = parameter;
                break;
            }
            case Y: {
                this.parameterForYAxis = parameter;
                break;
            }
            default: {
                throw new IllegalArgumentException("Unknown axis type " + (Object)((Object)axisType));
            }
        }
    }

    public Color getDecorationsColor() {
        return this.decorationsColor;
    }

    public void setDecorationsColor(Color decorationsColor) {
        this.decorationsColor = decorationsColor;
    }

    public void autofit(DataSheet dataSheet, AxisType axisType) {
        Parameter parameter = this.getParameterForAxis(axisType);
        this.autofitParam(dataSheet, parameter);
    }

    private void autofitParam(DataSheet dataSheet, Parameter parameter) {
        this.setMin(parameter, dataSheet.getMinValueOf(parameter));
        this.setMax(parameter, dataSheet.getMinValueOf(parameter));
    }

    public void setMin(AxisType axisType, double value) {
        Parameter parameter = this.getParameterForAxis(axisType);
        this.setMin(parameter, value);
    }

    private void setMin(Parameter parameter, double value) {
        this.minValues.put(parameter.getName(), value);
    }

    public double getMin(AxisType axisType) {
        Parameter parameter = this.getParameterForAxis(axisType);
        return this.minValues.get(parameter.getName());
    }

    public void setMax(AxisType axisType, double value) {
        Parameter parameter = this.getParameterForAxis(axisType);
        this.setMax(parameter, value);
    }

    private void setMax(Parameter parameter, double value) {
        this.maxValues.put(parameter.getName(), value);
    }

    public double getMax(AxisType axisType) {
        Parameter parameter = this.getParameterForAxis(axisType);
        return this.maxValues.get(parameter.getName());
    }

    public int getTicSize() {
        return 5;
    }

    public void setTicCount(AxisType axisType, int value) {
        switch (axisType) {
            case X: {
                this.ticCountX = value;
                break;
            }
            case Y: {
                this.ticCountY = value;
                break;
            }
            default: {
                throw new IllegalArgumentException("Unknown axis type " + (Object)((Object)axisType));
            }
        }
    }

    public int getTicCount(AxisType axisType) {
        switch (axisType) {
            case X: {
                return this.ticCountX;
            }
            case Y: {
                return this.ticCountY;
            }
        }
        throw new IllegalArgumentException("Unknown axis type " + (Object)((Object)axisType));
    }

    public void setAxisLabelFontSize(AxisType axisType, int value) {
        switch (axisType) {
            case X: {
                this.axisLabelFontSizeX = value;
                break;
            }
            case Y: {
                this.axisLabelFontSizeY = value;
                break;
            }
            default: {
                throw new IllegalArgumentException("Unknown axis type " + (Object)((Object)axisType));
            }
        }
    }

    public int getAxisLabelFontSize(AxisType axisType) {
        switch (axisType) {
            case X: {
                return this.axisLabelFontSizeX;
            }
            case Y: {
                return this.axisLabelFontSizeY;
            }
        }
        throw new IllegalArgumentException("Unknown axis type " + (Object)((Object)axisType));
    }

    public void setTicLabelFontSize(AxisType axisType, int value) {
        switch (axisType) {
            case X: {
                this.ticLabelFontSizeX = value;
                break;
            }
            case Y: {
                this.ticLabelFontSizeY = value;
                break;
            }
            default: {
                throw new IllegalArgumentException("Unknown axis type " + (Object)((Object)axisType));
            }
        }
    }

    public int getTicLabelFontSize(AxisType axisType) {
        switch (axisType) {
            case X: {
                return this.ticLabelFontSizeX;
            }
            case Y: {
                return this.ticLabelFontSizeY;
            }
        }
        throw new IllegalArgumentException("Unknown axis type " + (Object)((Object)axisType));
    }

    public int getPlotAreaDistanceToLeft(int ticLabelOffset) {
        int distance = this.getMargin();
        if (this.showDecorations) {
            distance = distance + this.axisLabelFontSizeY + 20 + 10 + ticLabelOffset;
        }
        return distance;
    }

    public int getPlotAreaDistanceToRight() {
        int distance = this.getMargin();
        if (this.showDecorations) {
            distance += 20;
        }
        return distance;
    }

    public int getPlotAreaDistanceToTop() {
        int distance = this.getMargin();
        if (this.showDecorations) {
            distance += 20;
        }
        return distance;
    }

    public int getPlotAreaDistanceToBottom() {
        int distance = this.getMargin();
        if (this.showDecorations) {
            distance = distance + this.axisLabelFontSizeX + 20 + this.ticLabelFontSizeX + 10;
        }
        return distance;
    }

    public boolean isShowDecorations() {
        return this.showDecorations;
    }

    @Override
    public void resetDisplaySettingsToDefault() {
        UserPreferences userPreferences = UserPreferences.getInstance();
        this.setDisplayedDesignSelectionMode(userPreferences.getScatterChart2DDisplayMode());
        this.axisLabelFontSizeX = userPreferences.getScatterChart2DAxisTitleFontsizeX();
        this.axisLabelFontSizeY = userPreferences.getScatterChart2DAxisTitleFontsizeY();
        this.ticCountX = userPreferences.getScatterChart2DTicCountX();
        this.ticCountY = userPreferences.getScatterChart2DTicCountY();
        this.ticLabelFontSizeX = userPreferences.getScatterChart2DTicLabelFontsizeX();
        this.ticLabelFontSizeY = userPreferences.getScatterChart2DTicLabelFontsizeY();
        this.setDotRadius(userPreferences.getScatterChart2DDataPointSize());
        this.setDecorationsColor(userPreferences.getScatterChart2DForegroundColor());
        this.setBackGroundColor(userPreferences.getScatterChart2DBackgroundColor());
        this.setActiveDesignColor(userPreferences.getScatterChart2DActiveDesignColor());
        this.setSelectedDesignColor(userPreferences.getScatterChart2DSelectedDesignColor());
    }
}

