/*
 * Decompiled with CFR 0.152.
 */
package org.xdat.chart;

import java.awt.Color;
import java.awt.Dimension;
import java.util.stream.Stream;
import org.jetbrains.annotations.Nullable;
import org.xdat.UserPreferences;
import org.xdat.chart.Chart;
import org.xdat.chart.ScatterPlot2D;
import org.xdat.data.AxisType;
import org.xdat.data.DataSheet;
import org.xdat.settings.Key;
import org.xdat.settings.Setting;
import org.xdat.settings.SettingsGroup;
import org.xdat.settings.SettingsGroupFactory;
import org.xdat.settings.SettingsTransaction;

public class ScatterChart2D
extends Chart {
    static final long serialVersionUID = 1L;
    private final ScatterPlot2D scatterPlot2D;
    private final SettingsGroup axisSettingsX = SettingsGroupFactory.build2DScatterChartAxisSettingsGroup(AxisType.X);
    private final SettingsGroup axisSettingsY = SettingsGroupFactory.build2DScatterChartAxisSettingsGroup(AxisType.Y);

    public ScatterChart2D(DataSheet dataSheet, boolean showDecorations, Dimension frameSize, int id) {
        super(dataSheet, id);
        Stream.concat(this.axisSettingsX.getSettings().values().stream(), this.axisSettingsY.getSettings().values().stream()).forEach(s -> s.addListener((Setting<T> source, SettingsTransaction transaction) -> this.handleSettingChange(this::fireChanged, transaction)));
        this.scatterPlot2D = new ScatterPlot2D(dataSheet, showDecorations);
        this.setFrameSize(frameSize);
    }

    public void setCurrentSettingsAsDefault() {
        UserPreferences userPreferences = UserPreferences.getInstance();
        userPreferences.setScatterChart2DDisplayMode(this.scatterPlot2D.getDisplayedDesignSelectionMode());
        userPreferences.setScatterChart2DAxisTitleFontsizeX(this.scatterPlot2D.getAxisLabelFontSize(AxisType.X));
        userPreferences.setScatterChart2DAxisTitleFontsizeY(this.scatterPlot2D.getAxisLabelFontSize(AxisType.Y));
        userPreferences.setScatterChart2DTicCountX(this.scatterPlot2D.getTicCount(AxisType.X));
        userPreferences.setScatterChart2DTicCountY(this.scatterPlot2D.getTicCount(AxisType.Y));
        userPreferences.setScatterChart2DTicLabelFontsizeX(this.scatterPlot2D.getTicLabelFontSize(AxisType.X));
        userPreferences.setScatterChart2DTicLabelFontsizeY(this.scatterPlot2D.getTicLabelFontSize(AxisType.Y));
        userPreferences.setScatterChart2DDataPointSize(this.scatterPlot2D.getDotRadius());
        userPreferences.setScatterChart2DForegroundColor(this.scatterPlot2D.getDecorationsColor());
        userPreferences.setScatterChart2DBackgroundColor(this.scatterPlot2D.getBackGroundColor());
        userPreferences.setScatterChart2DActiveDesignColor(this.scatterPlot2D.getActiveDesignColor());
        userPreferences.setScatterChart2DSelectedDesignColor(this.scatterPlot2D.getSelectedDesignColor());
        this.axisSettingsX.applyAllAsDefault();
        this.axisSettingsY.applyAllAsDefault();
    }

    @Override
    public int getWidth() {
        return this.getFrameSize().width;
    }

    @Override
    public int getHeight() {
        return this.getFrameSize().height;
    }

    @Override
    public String getTitle() {
        return "2D Scatter Chart " + this.getID();
    }

    public ScatterPlot2D getScatterPlot2D() {
        return this.scatterPlot2D;
    }

    @Override
    public Color getBackGroundColor() {
        return this.scatterPlot2D.getBackGroundColor();
    }

    @Override
    public void setBackGroundColor(Color backGroundColor) {
        this.scatterPlot2D.setBackGroundColor(backGroundColor);
    }

    public boolean isAutoFit(AxisType axisType) {
        return this.getAxisSettings(axisType).getBoolean(Key.getScatterChartAutoFitAxis(axisType));
    }

    public SettingsGroup getAxisSettingsX() {
        return this.axisSettingsX;
    }

    public SettingsGroup getAxisSettingsY() {
        return this.axisSettingsY;
    }

    public SettingsGroup getAxisSettings(AxisType axisType) {
        switch (axisType) {
            case X: {
                return this.getAxisSettingsX();
            }
            case Y: {
                return this.getAxisSettingsY();
            }
        }
        throw new IllegalStateException("illegal axis type " + (Object)((Object)axisType));
    }

    @Override
    public void resetDisplaySettingsToDefault(DataSheet dataSheet) {
        this.scatterPlot2D.resetDisplaySettingsToDefault();
        this.axisSettingsX.resetToDefault();
        this.axisSettingsY.resetToDefault();
    }

    @Override
    public void initTransientDataImpl() {
        this.axisSettingsX.initTransientData();
        this.axisSettingsY.initTransientData();
    }

    private void handleSettingChange(Runnable changeHandler, @Nullable SettingsTransaction transaction) {
        if (transaction == null) {
            changeHandler.run();
        } else {
            transaction.handleOnce(changeHandler);
        }
    }
}

