/*
 * Decompiled with CFR 0.152.
 */
package org.xdat.chart;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Point;
import java.io.Serializable;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.stream.Stream;
import javax.swing.ProgressMonitor;
import org.jetbrains.annotations.Nullable;
import org.xdat.chart.Axis;
import org.xdat.chart.Chart;
import org.xdat.data.Cluster;
import org.xdat.data.DataSheet;
import org.xdat.data.DatasheetListener;
import org.xdat.data.Design;
import org.xdat.settings.Key;
import org.xdat.settings.Setting;
import org.xdat.settings.SettingsGroup;
import org.xdat.settings.SettingsGroupFactory;
import org.xdat.settings.SettingsTransaction;

public class ParallelCoordinatesChart
extends Chart
implements Serializable {
    static final long serialVersionUID = 4L;
    private static final int BOTTOM_PADDING = 60;
    private static final int TOP_MARGIN = 10;
    private final List<Axis> axes = new LinkedList<Axis>();
    private final SettingsGroup chartSettings = SettingsGroupFactory.buildGeneralParallelCoordinatesChartSettingsGroup();

    public ParallelCoordinatesChart(final DataSheet dataSheet, ProgressMonitor progressMonitor, int id) {
        super(dataSheet, id);
        int i;
        this.setLocation(new Point(100, 100));
        this.setFrameSize(new Dimension(1280, 800));
        progressMonitor.setMaximum(dataSheet.getParameterCount() - 1);
        progressMonitor.setNote("Building Chart...");
        for (i = 0; i < dataSheet.getParameterCount() && !progressMonitor.isCanceled(); ++i) {
            Axis newAxis = new Axis(dataSheet, this, dataSheet.getParameter(i));
            this.addAxis(newAxis);
            progressMonitor.setProgress(i);
        }
        if (!progressMonitor.isCanceled()) {
            progressMonitor.setNote("Building Filters...");
            progressMonitor.setProgress(0);
            for (i = 0; i < dataSheet.getParameterCount() && !progressMonitor.isCanceled(); ++i) {
                this.axes.get(i).addFilters(dataSheet);
                progressMonitor.setProgress(i);
            }
        }
        Stream.concat(this.chartSettings.getSettings().values().stream(), this.axes.stream().map(Axis::getSettings).flatMap(g -> g.getSettings().values().stream())).forEach(s -> s.addListener((Setting<T> source, SettingsTransaction transaction) -> this.handleSettingChange(this::fireChanged, transaction)));
        dataSheet.addListener(new DatasheetListener(){

            @Override
            public void onClustersChanged() {
                ParallelCoordinatesChart.this.fireChanged();
            }

            @Override
            public void onDataPanelUpdateRequired() {
            }

            @Override
            public void onDataChanged(boolean[] autoFitRequired, boolean[] filterResetRequired, boolean[] applyFiltersRequired, boolean parametersChanged) {
                boolean changed = false;
                if (parametersChanged) {
                    changed = ParallelCoordinatesChart.this.axes.removeIf(axis -> !dataSheet.parameterExists(axis.getParameter()));
                }
                for (int i = 0; i < ParallelCoordinatesChart.this.axes.size(); ++i) {
                    Axis axis2 = (Axis)ParallelCoordinatesChart.this.axes.get(i);
                    if (autoFitRequired[i]) {
                        changed = true;
                        axis2.autofit(dataSheet);
                    }
                    if (filterResetRequired[i]) {
                        changed = true;
                        axis2.resetFilters(dataSheet);
                    }
                    if (!applyFiltersRequired[i]) continue;
                    changed = true;
                    axis2.applyFilters(dataSheet);
                }
                if (changed) {
                    ParallelCoordinatesChart.this.fireChanged();
                }
            }
        });
    }

    private void handleSettingChange(Runnable changeHandler, @Nullable SettingsTransaction transaction) {
        if (transaction == null) {
            changeHandler.run();
        } else {
            transaction.handleOnce(changeHandler);
        }
    }

    @Override
    protected void fireChanged() {
        this.applyAutoFitIfNeeded();
        super.fireChanged();
    }

    private void applyAutoFitIfNeeded() {
        for (Axis axis : this.getAxes()) {
            if (!axis.isAutoFit()) continue;
            axis.autofit(this.getDataSheet());
        }
    }

    @Override
    public String getTitle() {
        return "Parallel Coordinates Chart " + this.getID();
    }

    @Override
    public int getWidth() {
        int width = 0;
        if (this.getAxis(0).isActive()) {
            width += (int)(0.5 * (double)this.getAxis(0).getWidth());
        }
        for (int i = 1; i < this.getAxisCount(); ++i) {
            if (!this.getAxis(i).isActive()) continue;
            width += this.getAxis(i).getWidth();
        }
        return width;
    }

    @Override
    public int getHeight() {
        return this.getAxisTopPos() + this.getAxisHeight();
    }

    public void incrementAxisWidth(int deltaWidth) {
        for (Axis axis : this.axes) {
            axis.setWidth(Math.max(0, axis.getWidth() + deltaWidth));
        }
    }

    public int getAxisTopPos() {
        boolean verticallyOffsetAxisLabels = this.chartSettings.getBoolean(Key.PARALLEL_COORDINATES_VERTICALLY_OFFSET_AXIS_LABELS);
        int topPos = verticallyOffsetAxisLabels ? 2 * this.getMaxAxisLabelFontSize() + this.getAxisLabelVerticalDistance() + this.getTopMargin() * 2 + this.getFilterHeight() : this.getMaxAxisLabelFontSize() + this.getTopMargin() * 2 + this.getFilterHeight();
        return topPos;
    }

    public Axis getAxis(int index) {
        return this.axes.get(index);
    }

    public Axis getAxis(String parameterName) {
        for (Axis axis : this.axes) {
            if (!parameterName.equals(axis.getParameter().getName())) continue;
            return axis;
        }
        throw new IllegalArgumentException("Axis " + parameterName + " not found");
    }

    public int getMaxAxisLabelFontSize() {
        int maxAxisLabelFontSize = 0;
        for (Axis axis : this.axes) {
            if (maxAxisLabelFontSize >= axis.getAxisLabelFontSize()) continue;
            maxAxisLabelFontSize = axis.getAxisLabelFontSize();
        }
        return maxAxisLabelFontSize;
    }

    public int getAxisCount() {
        return this.axes.size();
    }

    public int getAxisLabelVerticalDistance() {
        return this.chartSettings.getInteger(Key.PARALLEL_COORDINATES_LABELS_VERTICAL_DISTANCE);
    }

    public boolean isVerticallyOffsetAxisLabels() {
        return this.chartSettings.getBoolean(Key.PARALLEL_COORDINATES_VERTICALLY_OFFSET_AXIS_LABELS);
    }

    public void addAxis(Axis axis) {
        this.axes.add(axis);
    }

    public void moveAxis(int oldIndex, int newIndex) {
        Axis axis = this.axes.remove(oldIndex);
        this.axes.add(newIndex, axis);
    }

    public int getAxisHeight() {
        return this.getFrameSize().height - this.getAxisTopPos() - 60;
    }

    public int getDesignLabelFontSize() {
        return this.chartSettings.getInteger(Key.DESIGN_LABEL_FONT_SIZE);
    }

    public int getLineThickness() {
        return this.chartSettings.getInteger(Key.LINE_THICKNESS);
    }

    public void setActiveDesignColor(Color newColor) {
        this.chartSettings.getColorSetting(Key.ACTIVE_DESIGN_DEFAULT_COLOR).set(newColor);
    }

    public Color getActiveDesignColor() {
        return this.chartSettings.getColor(Key.ACTIVE_DESIGN_DEFAULT_COLOR);
    }

    public Color getActiveDesignColorNoAlpha() {
        return new Color(this.getActiveDesignColor().getRGB());
    }

    public Color getFilteredDesignColor() {
        return this.chartSettings.getColor(Key.IN_ACTIVE_DESIGN_DEFAULT_COLOR);
    }

    public Color getFilteredDesignColorNoAlpha() {
        return new Color(this.getFilteredDesignColor().getRGB());
    }

    public Color getDesignColor(Design design, boolean designActive, boolean useAlpha, Color activeDesignColor, Color activeDesignColorNoAlpha, Color filteredDesignColor, Color filteredDesignColorNoAlpha) {
        if (designActive && design.hasGradientColor()) {
            return design.getGradientColor();
        }
        @Nullable Cluster cluster = design.getCluster();
        if (designActive && cluster != null) {
            return cluster.getActiveDesignColor(useAlpha);
        }
        if (designActive) {
            return useAlpha ? activeDesignColor : activeDesignColorNoAlpha;
        }
        return useAlpha ? filteredDesignColor : filteredDesignColorNoAlpha;
    }

    public int getSelectedDesignsLineThickness() {
        return this.chartSettings.getInteger(Key.SELECTED_DESIGN_LINE_THICKNESS);
    }

    public Color getDefaultDesignColor(boolean designActive, boolean useAlpha) {
        if (designActive) {
            return useAlpha ? this.getActiveDesignColor() : this.getActiveDesignColorNoAlpha();
        }
        return useAlpha ? this.getFilteredDesignColor() : this.getFilteredDesignColorNoAlpha();
    }

    public Color getSelectedDesignColor() {
        return this.chartSettings.getColor(Key.SELECTED_DESIGN_DEFAULT_COLOR);
    }

    public boolean isShowDesignIDs() {
        return this.chartSettings.getBoolean(Key.SHOW_DESIGN_IDS);
    }

    public boolean isShowFilteredDesigns() {
        return this.chartSettings.getBoolean(Key.SHOW_FILTERED_DESIGNS);
    }

    public boolean isShowOnlySelectedDesigns() {
        return this.chartSettings.getBoolean(Key.PARALLEL_COORDINATES_SHOW_ONLY_SELECTED_DESIGNS);
    }

    public Color getFilterColor() {
        return this.chartSettings.getColor(Key.PARALLEL_COORDINATES_FILTER_COLOR);
    }

    public String getFontFamily() {
        return (String)this.chartSettings.getMultipleChoiceSetting(Key.FONT_FAMILY).get();
    }

    public int getTopMargin() {
        return 10;
    }

    @Override
    public void resetDisplaySettingsToDefault(DataSheet dataSheet) {
        this.chartSettings.resetToDefault();
        for (Axis axis : this.axes) {
            axis.resetSettingsToDefault(dataSheet);
        }
    }

    @Override
    public Color getBackGroundColor() {
        return this.chartSettings.getColor(Key.PARALLEL_CHART_BACKGROUND_COLOR);
    }

    @Override
    public void setBackGroundColor(Color backGroundColor) {
        this.chartSettings.getColorSetting(Key.PARALLEL_CHART_BACKGROUND_COLOR).set(backGroundColor);
    }

    public int getFilterHeight() {
        return this.chartSettings.getInteger(Key.PARALLEL_COORDINATES_FILTER_HEIGHT);
    }

    public int getFilterWidth() {
        return this.chartSettings.getInteger(Key.PARALLEL_COORDINATES_FILTER_WIDTH);
    }

    @Override
    public void initTransientDataImpl() {
        this.chartSettings.initTransientData();
        this.axes.forEach(Axis::initTransientData);
    }

    public SettingsGroup getChartSettingsGroup() {
        return this.chartSettings;
    }

    public List<Axis> getAxes() {
        return Collections.unmodifiableList(this.axes);
    }
}

