/*
 * Decompiled with CFR 0.152.
 */
package org.xdat.chart;

import java.io.Serializable;
import org.xdat.chart.Axis;
import org.xdat.data.DataSheet;
import org.xdat.data.Design;
import org.xdat.data.Parameter;

public class Filter
implements Serializable {
    static final long serialVersionUID = 2L;
    public static final int UPPER_FILTER = 0;
    public static final int LOWER_FILTER = 1;
    public static final double FILTER_TOLERANCE = 1.0E-5;
    private final int filterType;
    private final Axis axis;
    private int xPos;
    private double value;

    public Filter(DataSheet dataSheet, Axis axis, int filterType) {
        this.axis = axis;
        this.filterType = filterType;
        this.reset(dataSheet);
    }

    public double getValue() {
        return this.value;
    }

    public void setValue(double value, DataSheet dataSheet) {
        this.value = value;
        this.apply(dataSheet);
    }

    public int getXPos() {
        return this.xPos;
    }

    public void setXPos(int pos) {
        this.xPos = pos;
    }

    public int getYPos(DataSheet dataSheet) {
        int yPos;
        if (this.axis.getTicCount() == 1) {
            return this.getAxis().getChart().getAxisTopPos() + (int)((double)this.getAxis().getChart().getAxisHeight() * 0.5);
        }
        double upperLimit = this.axis.getMax();
        double lowerLimit = this.axis.getMin();
        if (this.value > upperLimit) {
            this.value = upperLimit;
        } else if (this.value < lowerLimit) {
            this.value = lowerLimit;
        }
        double valueRange = upperLimit - lowerLimit;
        int topPos = this.axis.getChart().getAxisTopPos() - 1;
        int bottomPos = topPos + this.getAxis().getChart().getAxisHeight() + 1;
        double posRange = bottomPos - topPos;
        if (this.axis.isAxisInverted()) {
            double ratio = (this.value - lowerLimit) / valueRange;
            yPos = topPos + (int)(posRange * ratio);
        } else {
            double ratio = (this.value - lowerLimit) / valueRange;
            yPos = bottomPos - (int)(posRange * ratio);
        }
        return yPos;
    }

    public void setYPos(int pos, DataSheet dataSheet) {
        double upperLimit = this.axis.getMax();
        double lowerLimit = this.axis.getMin();
        double valueRange = upperLimit - lowerLimit;
        int topPos = this.axis.getChart().getAxisTopPos() - 1;
        int bottomPos = topPos + this.getAxis().getChart().getAxisHeight() + 1;
        double posRange = bottomPos - topPos;
        double ratio = this.axis.isAxisInverted() ? (double)(pos - topPos) / posRange : (double)(bottomPos - pos) / posRange;
        this.value = lowerLimit + valueRange * ratio;
        this.apply(dataSheet);
    }

    public int getHighestPos(DataSheet dataSheet) {
        int pos = this.getFilterType() == 0 ? this.getAxis().getChart().getAxisTopPos() : (this.getFilterType() == 1 ? this.getAxis().getUpperFilter().getYPos(dataSheet) : this.getAxis().getChart().getAxisTopPos());
        return pos - 1;
    }

    public int getLowestPos(DataSheet dataSheet) {
        int pos = this.getFilterType() == 0 ? this.getAxis().getLowerFilter().getYPos(dataSheet) : (this.getFilterType() == 1 ? this.getAxis().getChart().getAxisTopPos() + this.getAxis().getChart().getAxisHeight() : this.getAxis().getChart().getAxisTopPos() + this.getAxis().getChart().getAxisHeight());
        return pos + 1;
    }

    public int getFilterType() {
        return this.filterType;
    }

    public Axis getAxis() {
        return this.axis;
    }

    public void apply(DataSheet dataSheet) {
        Parameter param = this.axis.getParameter();
        double tolerance = this.getAxis().getRange() * 1.0E-5;
        if (tolerance <= 0.0) {
            tolerance = 1.0E-5;
        }
        double value = this.getValue();
        for (Design design : dataSheet.getDesigns()) {
            if (this.filterType == 0 && this.axis.isFilterInverted() && this.axis.isAxisInverted()) {
                if (design.getDoubleValue(param) - tolerance > value) {
                    design.setActive(this, false);
                    continue;
                }
                design.setActive(this, true);
                continue;
            }
            if (this.filterType == 1 && this.axis.isFilterInverted() && this.axis.isAxisInverted()) {
                if (design.getDoubleValue(param) + tolerance < value) {
                    design.setActive(this, false);
                    continue;
                }
                design.setActive(this, true);
                continue;
            }
            if (this.filterType == 0 && this.axis.isAxisInverted()) {
                if (design.getDoubleValue(param) + tolerance < value) {
                    design.setActive(this, false);
                    continue;
                }
                design.setActive(this, true);
                continue;
            }
            if (this.filterType == 1 && this.axis.isAxisInverted()) {
                if (design.getDoubleValue(param) - tolerance > value) {
                    design.setActive(this, false);
                    continue;
                }
                design.setActive(this, true);
                continue;
            }
            if (this.filterType == 0 && this.axis.isFilterInverted()) {
                if (design.getDoubleValue(param) + tolerance < value) {
                    design.setActive(this, false);
                    continue;
                }
                design.setActive(this, true);
                continue;
            }
            if (this.filterType == 1 && this.axis.isFilterInverted()) {
                if (design.getDoubleValue(param) - tolerance > value) {
                    design.setActive(this, false);
                    continue;
                }
                design.setActive(this, true);
                continue;
            }
            if (this.filterType == 0) {
                if (design.getDoubleValue(param) - tolerance > value) {
                    design.setActive(this, false);
                    continue;
                }
                design.setActive(this, true);
                continue;
            }
            if (this.filterType != 1) continue;
            if (design.getDoubleValue(param) + tolerance < value) {
                design.setActive(this, false);
                continue;
            }
            design.setActive(this, true);
        }
        dataSheet.fireOnDataChanged(false, false, false, false);
    }

    public void reset(DataSheet dataSheet) {
        if (this.filterType == 0 && this.axis.isAxisInverted()) {
            this.setValue(this.axis.getMax(), dataSheet);
        } else if (this.filterType == 0) {
            double value = this.axis.getMax();
            this.setValue(value, dataSheet);
        } else if (this.filterType == 1 && this.axis.isAxisInverted()) {
            this.setValue(this.axis.getMax(), dataSheet);
        } else {
            this.setValue(this.axis.getMin(), dataSheet);
        }
    }
}

