/*
 * Decompiled with CFR 0.152.
 */
package org.xdat.chart;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Point;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import org.xdat.UserPreferences;
import org.xdat.chart.ChartListener;
import org.xdat.data.DataSheet;

public abstract class Chart
implements Serializable {
    static final long serialVersionUID = 1L;
    private Point location;
    private int id;
    private Dimension frameSize;
    private final DataSheet dataSheet;
    private boolean antiAliasing;
    private boolean useAlpha;
    private transient List<ChartListener> listeners = new ArrayList<ChartListener>();

    public Chart(DataSheet dataSheet, int id) {
        this.dataSheet = dataSheet;
        this.id = id;
        this.location = new Point(100, 100);
        this.frameSize = new Dimension(800, 600);
        this.antiAliasing = UserPreferences.getInstance().isAntiAliasing();
        this.useAlpha = UserPreferences.getInstance().isUseAlpha();
    }

    public void addListener(ChartListener l) {
        this.listeners.add(l);
    }

    protected void fireChanged() {
        for (ChartListener listener : this.listeners) {
            listener.onChartChanged(this);
        }
    }

    public abstract String getTitle();

    public int getID() {
        return this.id;
    }

    public abstract int getWidth();

    public abstract int getHeight();

    public DataSheet getDataSheet() {
        return this.dataSheet;
    }

    public abstract Color getBackGroundColor();

    public abstract void setBackGroundColor(Color var1);

    public Dimension getFrameSize() {
        return this.frameSize;
    }

    public void setFrameSize(Dimension size) {
        this.frameSize = size;
    }

    public Point getLocation() {
        return this.location;
    }

    public void setLocation(Point location) {
        this.location = location;
    }

    public abstract void resetDisplaySettingsToDefault(DataSheet var1);

    public boolean isAntiAliasing() {
        return this.antiAliasing;
    }

    public void setAntiAliasing(boolean antiAliasing) {
        this.antiAliasing = antiAliasing;
    }

    public boolean isUseAlpha() {
        return this.useAlpha;
    }

    public void setUseAlpha(boolean useAlpha) {
        this.useAlpha = useAlpha;
    }

    public void initTransientData() {
        this.listeners = new ArrayList<ChartListener>();
        this.initTransientDataImpl();
    }

    protected abstract void initTransientDataImpl();
}

