/*
 * Decompiled with CFR 0.152.
 */
package org.xdat.chart;

import java.awt.Color;
import java.io.Serializable;
import org.xdat.chart.Filter;
import org.xdat.chart.ParallelCoordinatesChart;
import org.xdat.data.DataSheet;
import org.xdat.data.Parameter;
import org.xdat.gui.panels.DisabledValueSupplierDatasheetAxisLimit;
import org.xdat.settings.IntegerSetting;
import org.xdat.settings.Key;
import org.xdat.settings.Setting;
import org.xdat.settings.SettingsGroup;
import org.xdat.settings.SettingsGroupFactory;

public class Axis
implements Serializable {
    static final long serialVersionUID = 7L;
    private final ParallelCoordinatesChart chart;
    private Parameter parameter;
    private Filter upperFilter;
    private Filter lowerFilter;
    private final SettingsGroup settings;

    public Axis(DataSheet dataSheet, ParallelCoordinatesChart chart, Parameter parameter) {
        this.chart = chart;
        this.parameter = parameter;
        this.settings = SettingsGroupFactory.buildParallelCoordinatesChartAxisSettingsGroup(new DisabledValueSupplierDatasheetAxisLimit(dataSheet, parameter, DisabledValueSupplierDatasheetAxisLimit.AxisLimitType.MIN), new DisabledValueSupplierDatasheetAxisLimit(dataSheet, parameter, DisabledValueSupplierDatasheetAxisLimit.AxisLimitType.MAX));
        this.initialiseSettings(dataSheet);
        if (this.settings.getBoolean(Key.PARALLEL_COORDINATES_AUTO_FIT_AXIS)) {
            this.autofit(dataSheet);
        }
        IntegerSetting ticLabelDigitCountSetting = this.settings.getIntegerSetting(Key.PARALLEL_COORDINATES_AXIS_TIC_LABEL_DIGIT_COUNT);
        ticLabelDigitCountSetting.set(parameter.getTicLabelDigitCount());
        ticLabelDigitCountSetting.addListener((source, transaction) -> parameter.setTicLabelDigitCount((Integer)source.get()));
        this.settings.getBooleanSetting(Key.PARALLEL_COORDINATES_AXIS_INVERTED).addListener((source, transaction) -> this.onAxisInverted(dataSheet));
        this.settings.getBooleanSetting(Key.PARALLEL_COORDINATES_FILTER_INVERTED).addListener((source, transaction) -> this.applyFilters(dataSheet));
        this.settings.getDoubleSetting(Key.PARALLEL_COORDINATES_AXIS_DEFAULT_MIN).addListener((source, transaction) -> dataSheet.evaluateBoundsForAllDesigns(chart));
        this.settings.getDoubleSetting(Key.PARALLEL_COORDINATES_AXIS_DEFAULT_MAX).addListener((source, transaction) -> dataSheet.evaluateBoundsForAllDesigns(chart));
        this.settings.getIntegerSetting(Key.PARALLEL_COORDINATES_AXIS_TIC_COUNT).addListener((source, transaction) -> {
            if ((Integer)source.get() < 2) {
                this.applyFilters(dataSheet);
            }
        });
    }

    private void initialiseSettings(DataSheet dataSheet) {
        dataSheet.evaluateBoundsForAllDesigns(this.chart);
    }

    void resetSettingsToDefault(DataSheet dataSheet) {
        this.initialiseSettings(dataSheet);
        this.autofit(dataSheet);
    }

    void addFilters(DataSheet dataSheet) {
        this.upperFilter = new Filter(dataSheet, this, 0);
        this.lowerFilter = new Filter(dataSheet, this, 1);
    }

    public void autofit(DataSheet dataSheet) {
        this.setMax(this.getMaxPossibleValue(dataSheet));
        this.setMin(this.getMinPossibleValue(dataSheet));
        dataSheet.evaluateBoundsForAllDesigns(this.chart);
    }

    public double getMinPossibleValue(DataSheet dataSheet) {
        return dataSheet.getMinValueOf(this.parameter);
    }

    public double getMaxPossibleValue(DataSheet dataSheet) {
        return dataSheet.getMaxValueOf(this.parameter);
    }

    public Color getAxisLabelFontColor() {
        return this.settings.getColor(Key.PARALLEL_COORDINATES_AXIS_LABEL_FONT_COLOR);
    }

    public int getAxisLabelFontSize() {
        return this.settings.getInteger(Key.PARALLEL_COORDINATES_AXIS_LABEL_FONT_SIZE);
    }

    public double getMax() {
        if (!this.parameter.isNumeric()) {
            return this.parameter.getDiscreteLevelCount() - 1;
        }
        return this.settings.getDouble(Key.PARALLEL_COORDINATES_AXIS_DEFAULT_MAX);
    }

    public void setMax(double max) {
        this.settings.getDoubleSetting(Key.PARALLEL_COORDINATES_AXIS_DEFAULT_MAX).set(max);
    }

    public double getMin() {
        if (!this.parameter.isNumeric()) {
            return 0.0;
        }
        return this.settings.getDouble(Key.PARALLEL_COORDINATES_AXIS_DEFAULT_MIN);
    }

    public void setMin(double min) {
        this.settings.getDoubleSetting(Key.PARALLEL_COORDINATES_AXIS_DEFAULT_MIN).set(min);
    }

    public double getRange() {
        if (this.parameter.isNumeric()) {
            return this.getMax() - this.getMin();
        }
        return this.parameter.getDiscreteLevelCount() - 1;
    }

    public int getTicCount() {
        if (this.parameter.isNumeric() && this.getRange() > 0.0) {
            return this.settings.getInteger(Key.PARALLEL_COORDINATES_AXIS_TIC_COUNT);
        }
        if (this.parameter.isNumeric()) {
            return 1;
        }
        return this.parameter.getDiscreteLevelCount();
    }

    public void setTicCount(int ticCount, DataSheet dataSheet) {
        this.settings.getIntegerSetting(Key.PARALLEL_COORDINATES_AXIS_TIC_COUNT).set(ticCount);
    }

    public int getTicLabelFontSize() {
        return this.settings.getInteger(Key.TIC_LABEL_FONT_SIZE);
    }

    public String getTicLabelFormat() {
        return this.parameter.getTicLabelFormat();
    }

    public int getTicLength() {
        return this.settings.getInteger(Key.PARALLEL_COORDINATES_AXIS_TIC_LENGTH);
    }

    public int getWidth() {
        return this.settings.getInteger(Key.PARALLEL_COORDINATES_AXIS_WIDTH);
    }

    public void setWidth(int width) {
        this.getSettings().getIntegerSetting(Key.PARALLEL_COORDINATES_AXIS_WIDTH).set(width);
    }

    public boolean isActive() {
        return this.settings.getBoolean(Key.PARALLEL_COORDINATES_AXIS_ACTIVE);
    }

    public void setActive(boolean active) {
        this.settings.getBooleanSetting(Key.PARALLEL_COORDINATES_AXIS_ACTIVE).set(active);
    }

    public Parameter getParameter() {
        return this.parameter;
    }

    public void setParameter(Parameter parameter) {
        this.parameter = parameter;
    }

    public Color getAxisColor() {
        return this.settings.getColor(Key.PARALLEL_COORDINATES_AXIS_COLOR);
    }

    public Color getAxisTicLabelFontColor() {
        return this.settings.getColor(Key.PARALLEL_COORDINATES_AXIS_LABEL_FONT_COLOR);
    }

    public String getName() {
        return this.parameter.getName();
    }

    public Filter getLowerFilter() {
        return this.lowerFilter;
    }

    public Filter getUpperFilter() {
        return this.upperFilter;
    }

    public Filter getMinimumFilter() {
        if (this.isAxisInverted()) {
            return this.upperFilter;
        }
        return this.lowerFilter;
    }

    public Filter getMaximumFilter() {
        if (this.isAxisInverted()) {
            return this.lowerFilter;
        }
        return this.upperFilter;
    }

    public ParallelCoordinatesChart getChart() {
        return this.chart;
    }

    public boolean isFilterInverted() {
        return this.settings.getBoolean(Key.PARALLEL_COORDINATES_FILTER_INVERTED);
    }

    public boolean isAxisInverted() {
        return this.settings.getBoolean(Key.PARALLEL_COORDINATES_AXIS_INVERTED);
    }

    public void setAxisInverted(boolean axisInverted, DataSheet dataSheet) {
        this.settings.getBooleanSetting(Key.PARALLEL_COORDINATES_AXIS_INVERTED).set(axisInverted);
        this.onAxisInverted(dataSheet);
    }

    private void onAxisInverted(DataSheet dataSheet) {
        double maxFilterValue = this.getMaximumFilter().getValue();
        double minFilterValue = this.getMinimumFilter().getValue();
        this.getMaximumFilter().setValue(minFilterValue, dataSheet);
        this.getMinimumFilter().setValue(maxFilterValue, dataSheet);
    }

    public boolean isAutoFit() {
        if (this.parameter.isNumeric()) {
            return this.settings.getBoolean(Key.PARALLEL_COORDINATES_AUTO_FIT_AXIS);
        }
        return true;
    }

    public void setAutoFit(boolean autoFit) {
        this.settings.getBooleanSetting(Key.PARALLEL_COORDINATES_AUTO_FIT_AXIS).set(autoFit);
    }

    public void setFilterAsNewRange(DataSheet dataSheet) {
        this.setAutoFit(false);
        double minFilterValue = this.getMinimumFilter().getValue();
        double maxFilterValue = this.getMaximumFilter().getValue();
        this.setMin(minFilterValue);
        this.setMax(maxFilterValue);
        this.resetFilters(dataSheet);
    }

    public void applyFilters(DataSheet dataSheet) {
        this.upperFilter.apply(dataSheet);
        this.lowerFilter.apply(dataSheet);
    }

    public void resetFilters(DataSheet dataSheet) {
        this.upperFilter.reset(dataSheet);
        this.lowerFilter.reset(dataSheet);
    }

    public void initTransientData() {
        this.settings.getSettings().values().forEach(Setting::initTransientData);
    }

    public SettingsGroup getSettings() {
        return this.settings;
    }

    public String toString() {
        return this.parameter.getName();
    }
}

