/*
 * Decompiled with CFR 0.152.
 */
package org.xdat.actionListeners.scatter2DChartSettings;

import java.awt.event.ActionEvent;
import javax.swing.JTextField;
import org.xdat.Main;
import org.xdat.chart.ScatterChart2D;
import org.xdat.data.AxisType;
import org.xdat.gui.frames.ChartFrame;

public class Scatter2DChartAxisPanelActionListener {
    private Main mainWindow;
    private ScatterChart2D chart;
    private ChartFrame frame;
    private AxisType axisType;

    public Scatter2DChartAxisPanelActionListener(Main mainWindow, ChartFrame chartFrame, ScatterChart2D chart, AxisType axisType) {
        this.mainWindow = mainWindow;
        this.frame = chartFrame;
        this.chart = chart;
        this.axisType = axisType;
    }

    public void maxTextFieldUpdated(ActionEvent e) {
        double newMaxValue = this.validateDoubleInput(e.getActionCommand(), this.chart.getScatterPlot2D().getMax(this.axisType));
        this.chart.getScatterPlot2D().setMax(this.axisType, newMaxValue);
        ((JTextField)e.getSource()).setText(Double.toString(newMaxValue));
        this.frame.repaint();
    }

    public void minTextFieldUpdated(ActionEvent e) {
        double newMinValue = this.validateDoubleInput(e.getActionCommand(), this.chart.getScatterPlot2D().getMin(this.axisType));
        this.chart.getScatterPlot2D().setMin(this.axisType, newMinValue);
        ((JTextField)e.getSource()).setText(Double.toString(newMinValue));
        this.frame.repaint();
    }

    public void ticLabelFontsizeUpdated(int value) {
        this.chart.getScatterPlot2D().setTicLabelFontSize(this.axisType, value);
        this.frame.repaint();
    }

    public void ticCountUpdated(int value) {
        this.chart.getScatterPlot2D().setTicCount(this.axisType, value);
        this.frame.repaint();
    }

    public void ticLabelDigitCountUpdated(int value) {
        this.chart.getScatterPlot2D().getParameterForAxis(this.axisType).setTicLabelDigitCount(value);
        this.frame.repaint();
    }

    public void axisLabelFontsizeUpdated(int value) {
        this.chart.getScatterPlot2D().setAxisLabelFontSize(this.axisType, value);
        this.frame.repaint();
    }

    private double validateDoubleInput(String input, double fallBackValue) {
        try {
            return Double.parseDouble(input);
        }
        catch (NumberFormatException e) {
            return fallBackValue;
        }
    }
}

