/*
 * Decompiled with CFR 0.152.
 */
package org.xdat.actionListeners.scatter2DChartSettings;

import java.util.LinkedList;
import java.util.List;
import javax.swing.AbstractListModel;
import javax.swing.MutableComboBoxModel;
import org.xdat.Main;
import org.xdat.chart.ParallelCoordinatesChart;
import org.xdat.chart.ScatterPlot2D;
import org.xdat.gui.frames.ChartFrame;

public class ParallelChartFrameComboModel
extends AbstractListModel<String>
implements MutableComboBoxModel<String> {
    static final long serialVersionUID = 0L;
    private Main mainWindow;
    private ChartFrame chartFrame;
    private ScatterPlot2D plot;
    private List<String> chartNames = new LinkedList<String>();

    public ParallelChartFrameComboModel(Main mainWindow, ChartFrame chartFrame, ScatterPlot2D plot) {
        this.mainWindow = mainWindow;
        this.chartFrame = chartFrame;
        this.plot = plot;
        for (int i = 0; i < mainWindow.getChartFrameCount(); ++i) {
            if (!mainWindow.getChartFrame(i).getChart().getClass().equals(ParallelCoordinatesChart.class)) continue;
            this.addElement(mainWindow.getChartFrame(i).getChart().getTitle());
        }
    }

    @Override
    public void setSelectedItem(Object anItem) {
        if (anItem.toString().equals("No chart selected             ")) {
            this.plot.setParallelCoordinatesChartForFiltering(null);
        } else {
            this.plot.setParallelCoordinatesChartForFiltering((ParallelCoordinatesChart)this.mainWindow.getChartFrame(anItem.toString()).getChart());
        }
        this.chartFrame.repaint();
    }

    @Override
    public Object getSelectedItem() {
        if (this.plot.getParallelCoordinatesChartForFiltering() == null) {
            return "No chart selected             ";
        }
        return this.plot.getParallelCoordinatesChartForFiltering().getTitle();
    }

    @Override
    public String getElementAt(int index) {
        if (this.chartNames.size() == 0 && index == 0) {
            return "No chart selected             ";
        }
        return this.chartNames.get(index);
    }

    @Override
    public int getSize() {
        return Math.max(this.chartNames.size(), 1);
    }

    @Override
    public void addElement(String obj) {
        this.chartNames.add(obj);
        this.fireIntervalAdded(this, 0, this.chartNames.size());
    }

    @Override
    public void insertElementAt(String obj, int index) {
        this.chartNames.add(index, obj);
        this.fireIntervalAdded(this, 0, this.chartNames.size());
    }

    @Override
    public void removeElement(Object obj) {
        this.chartNames.remove(obj.toString());
        this.fireIntervalRemoved(this, 0, this.chartNames.size());
    }

    @Override
    public void removeElementAt(int index) {
        this.chartNames.remove(index);
        this.fireIntervalRemoved(this, 0, this.chartNames.size());
    }
}

