/*
 * Decompiled with CFR 0.152.
 */
package org.xdat.actionListeners.mainMenu;

import java.awt.event.ActionEvent;
import java.io.File;
import javax.swing.JFileChooser;
import javax.swing.filechooser.FileNameExtensionFilter;
import org.xdat.Main;
import org.xdat.Session;
import org.xdat.UserPreferences;

public class MainFileMenuActionListener {
    private Main mainWindow;

    public MainFileMenuActionListener(Main mainWindow) {
        this.mainWindow = mainWindow;
    }

    public void loadSession(ActionEvent e) {
        int returnVal;
        JFileChooser chooser = this.buildFileChooser();
        if (UserPreferences.getInstance().getCurrentDir() != null) {
            chooser.setCurrentDirectory(new File(UserPreferences.getInstance().getCurrentDir()));
        }
        if ((returnVal = chooser.showOpenDialog(this.mainWindow)) == 0) {
            String filepath = chooser.getSelectedFile().getAbsolutePath();
            UserPreferences.getInstance().setLastFile(chooser.getSelectedFile().getAbsolutePath());
            this.mainWindow.loadSession(filepath);
            this.mainWindow.initialiseDataPanel();
        }
    }

    public void saveSession(ActionEvent e) {
        Session session = this.mainWindow.getCurrentSession();
        if (session.getSessionDirectory() == null || session.getSessionName() == null) {
            this.saveSessionAs(e);
        } else {
            String filepath = session.getSessionDirectory() + System.getProperty("file.separator") + session.getSessionName() + ".ses";
            this.mainWindow.saveSessionAs(filepath);
        }
    }

    public void saveSessionAs(ActionEvent e) {
        int returnVal;
        Session session = this.mainWindow.getCurrentSession();
        JFileChooser chooser = this.buildFileChooser();
        if (UserPreferences.getInstance().getCurrentDir() != null) {
            chooser.setCurrentDirectory(new File(UserPreferences.getInstance().getCurrentDir()));
        }
        if ((returnVal = chooser.showSaveDialog(this.mainWindow)) == 0) {
            String filepath = chooser.getSelectedFile().getAbsolutePath();
            String filename = chooser.getSelectedFile().getName();
            session.setSessionDirectory(chooser.getSelectedFile().getParent());
            if (filename.endsWith(".ses")) {
                session.setSessionName(filename.substring(0, filename.length() - 4));
                this.mainWindow.saveSessionAs(filepath);
            } else {
                session.setSessionName(filename);
                this.mainWindow.saveSessionAs(filepath + ".ses");
            }
            UserPreferences.getInstance().setLastFile(filepath);
            this.mainWindow.setTitle("xdat   -   " + filepath + ".ses");
        }
    }

    public void exit(ActionEvent e) {
        this.mainWindow.setVisible(false);
        this.mainWindow.dispose();
        System.exit(0);
    }

    private JFileChooser buildFileChooser() {
        JFileChooser chooser = new JFileChooser();
        FileNameExtensionFilter filter = new FileNameExtensionFilter("*.ses files", "ses");
        chooser.setFileFilter(filter);
        chooser.addChoosableFileFilter(filter);
        return chooser;
    }
}

