/*
 * Decompiled with CFR 0.152.
 */
package org.xdat.actionListeners.mainMenu;

import java.awt.event.ActionEvent;
import java.io.File;
import javax.swing.JFileChooser;
import javax.swing.JOptionPane;
import javax.swing.ProgressMonitor;
import org.xdat.Main;
import org.xdat.UserPreferences;
import org.xdat.data.DataSheet;
import org.xdat.gui.dialogs.ClusterDialog;
import org.xdat.workerThreads.DataSheetCreationThread;
import org.xdat.workerThreads.DataSheetUpdateThread;

public class MainDataMenuActionListener {
    private Main mainWindow;

    public MainDataMenuActionListener(Main mainWindow) {
        this.mainWindow = mainWindow;
    }

    public void importData(boolean headers) {
        if (this.mainWindow.getChartFrameCount() == 0 || 0 == JOptionPane.showConfirmDialog(this.mainWindow, "This operation will close all charts.\n Are you sure you want to continue?", "Import Data", 2)) {
            int returnVal;
            this.mainWindow.disposeAllChartFrames();
            JFileChooser chooser = new JFileChooser();
            if (UserPreferences.getInstance().getCurrentDir() != null) {
                chooser.setCurrentDirectory(new File(UserPreferences.getInstance().getCurrentDir()));
            }
            if ((returnVal = chooser.showOpenDialog(this.mainWindow)) == 0) {
                String filepath = chooser.getSelectedFile().getAbsolutePath();
                UserPreferences.getInstance().setLastFile(chooser.getSelectedFile().getAbsolutePath());
                ProgressMonitor progressMonitor = new ProgressMonitor(this.mainWindow, "", "Importing Data...", 0, 100);
                progressMonitor.setProgress(0);
                DataSheetCreationThread sw = new DataSheetCreationThread(filepath, headers, this.mainWindow, progressMonitor);
                sw.execute();
            }
        }
    }

    public void updateData(boolean headers) {
        int returnVal;
        JFileChooser chooser = new JFileChooser();
        if (UserPreferences.getInstance().getCurrentDir() != null) {
            chooser.setCurrentDirectory(new File(UserPreferences.getInstance().getCurrentDir()));
        }
        if ((returnVal = chooser.showOpenDialog(this.mainWindow)) == 0) {
            String filepath = chooser.getSelectedFile().getAbsolutePath();
            UserPreferences.getInstance().setLastFile(chooser.getSelectedFile().getAbsolutePath());
            ProgressMonitor progressMonitor = new ProgressMonitor(this.mainWindow, "", "Updating Data...", 0, 100);
            progressMonitor.setProgress(0);
            DataSheetUpdateThread sw = new DataSheetUpdateThread(filepath, headers, this.mainWindow, progressMonitor);
            sw.execute();
        }
    }

    public void unselectAllDesigns(ActionEvent e) {
        DataSheet dataSheet = this.mainWindow.getDataSheet();
        if (dataSheet == null) {
            JOptionPane.showMessageDialog(this.mainWindow, "Please create a data sheet first by selecting Data->Import.", "Clustering", 1);
        } else {
            this.mainWindow.getDataSheetTablePanel().getDataTable().getSelectionModel().clearSelection();
        }
    }

    public void removeSelectedDesigns(ActionEvent e) {
        DataSheet dataSheet = this.mainWindow.getDataSheet();
        if (dataSheet == null) {
            JOptionPane.showMessageDialog(this.mainWindow, "Please create a data sheet first by selecting Data->Import.", "Clustering", 1);
        } else if (this.mainWindow.getDataSheetTablePanel().getDataTable().getSelectedRowCount() < 1) {
            JOptionPane.showMessageDialog(this.mainWindow, "Please select at least one design first.", "Remove Designs", 1);
        } else {
            int[] selection = this.mainWindow.getDataSheetTablePanel().getDataTable().getSelectedRows();
            this.mainWindow.getDataSheetTablePanel().getDataTable().getSelectionModel().clearSelection();
            this.mainWindow.getDataSheet().removeDesigns(selection);
        }
    }

    public void clustering(ActionEvent e) {
        if (this.mainWindow.getDataSheet() == null) {
            JOptionPane.showMessageDialog(this.mainWindow, "Please create a data sheet first by selecting Data->Import.", "Clustering", 1);
        } else {
            new ClusterDialog(this.mainWindow, this.mainWindow);
        }
    }
}

