/*
 * Decompiled with CFR 0.152.
 */
package org.xdat.actionListeners.importSettings;

import java.awt.event.ActionEvent;
import java.io.File;
import javax.swing.ButtonModel;
import javax.swing.JFileChooser;
import org.xdat.Main;
import org.xdat.UserPreferences;
import org.xdat.gui.dialogs.FileImportSettingsDialog;

public class FileImportSettingsDialogActionListener {
    private final Main mainWindow;
    private final FileImportSettingsDialog dialog;

    public FileImportSettingsDialogActionListener(Main mainWindow, FileImportSettingsDialog dialog) {
        this.mainWindow = mainWindow;
        this.dialog = dialog;
    }

    public void onCancel(ActionEvent e) {
        this.dialog.dispose();
    }

    public void onOk(ActionEvent e) {
        ButtonModel fileBrowsingSelectedModel = this.dialog.getFileBrowsingButtonGroup().getSelection();
        if (fileBrowsingSelectedModel.equals(this.dialog.getUseHomeRadioButton().getModel())) {
            UserPreferences.getInstance().setDirToImportFrom(0);
        } else if (fileBrowsingSelectedModel.equals(this.dialog.getUseLastRadioButton().getModel())) {
            UserPreferences.getInstance().setDirToImportFrom(1);
        } else if (fileBrowsingSelectedModel.equals(this.dialog.getUseThisRadioButton().getModel())) {
            UserPreferences.getInstance().setDirToImportFrom(2);
        }
        UserPreferences.getInstance().setUserDir(this.dialog.getUseThisTextField().getText());
        ButtonModel delimiterSelectedModel = this.dialog.getDelimiterButtonGroup().getSelection();
        if (delimiterSelectedModel.equals(this.dialog.getSpaceRadioButton().getModel())) {
            UserPreferences.getInstance().setDelimiter(" ");
        } else if (delimiterSelectedModel.equals(this.dialog.getTabRadioButton().getModel())) {
            UserPreferences.getInstance().setDelimiter("\\t");
        } else if (delimiterSelectedModel.equals(this.dialog.getAllBlanksRadioButton().getModel())) {
            UserPreferences.getInstance().setDelimiter("\\s");
        } else if (delimiterSelectedModel.equals(this.dialog.getCommaRadioButton().getModel())) {
            UserPreferences.getInstance().setDelimiter(",");
        } else if (delimiterSelectedModel.equals(this.dialog.getSemiColonRadioButton().getModel())) {
            UserPreferences.getInstance().setDelimiter(";");
        } else if (delimiterSelectedModel.equals(this.dialog.getOtherRadioButton().getModel())) {
            UserPreferences.getInstance().setDelimiter(this.dialog.getOtherTextField().getText());
            UserPreferences.getInstance().setOtherDelimiter(this.dialog.getOtherTextField().getText());
        }
        UserPreferences.getInstance().setTreatConsecutiveAsOne(this.dialog.getTreatConsecutiveAsOneCheckBox().isSelected());
        ButtonModel localeButtonModel = this.dialog.getNumberFormatLocaleButtonGroup().getSelection();
        if (localeButtonModel.equals(this.dialog.getGermanLocaleRadioButton().getModel())) {
            UserPreferences.getInstance().setLocale(1);
        } else {
            UserPreferences.getInstance().setLocale(0);
        }
        this.dialog.dispose();
    }

    public void onBrowse(ActionEvent e) {
        JFileChooser chooser = new JFileChooser();
        if (UserPreferences.getInstance().getCurrentDir() != null) {
            chooser.setCurrentDirectory(new File(UserPreferences.getInstance().getCurrentDir()));
        }
        chooser.setFileSelectionMode(1);
        int returnVal = chooser.showOpenDialog(this.mainWindow);
        if (returnVal == 0) {
            String filepath = chooser.getSelectedFile().getAbsolutePath();
            this.dialog.getUseThisTextField().setText(filepath);
        }
    }
}

