/*
 * Decompiled with CFR 0.152.
 */
package org.xdat.actionListeners.clusterDialog;

import java.awt.event.ActionEvent;
import java.util.List;
import org.xdat.Main;
import org.xdat.data.Cluster;
import org.xdat.data.DataSheet;
import org.xdat.gui.dialogs.ClusterDialog;
import org.xdat.gui.tables.ClusterTableModel;

public class ClusterDialogActionListener {
    private final Main mainWindow;
    private final ClusterDialog dialog;
    private final ClusterTableModel tableModel;

    public ClusterDialogActionListener(Main mainWindow, ClusterDialog dialog, ClusterTableModel tableModel) {
        this.mainWindow = mainWindow;
        this.dialog = dialog;
        this.tableModel = tableModel;
    }

    public void onOk(ActionEvent e) {
        if (this.dialog.getClusterTable().isEditing() && this.dialog.getClusterTable().getCellEditor() != null) {
            this.dialog.getClusterTable().getCellEditor().stopCellEditing();
        }
        List<Cluster> clustersBuffer = this.tableModel.getClustersBuffer();
        DataSheet dataSheet = this.mainWindow.getDataSheet();
        this.mainWindow.getCurrentClusterSet().applyClustersBuffer(clustersBuffer);
        this.tableModel.applyBuffer(this.mainWindow.getCurrentClusterSet().getClusters(), dataSheet);
        for (int i = 0; i < this.mainWindow.getChartFrameCount(); ++i) {
            this.mainWindow.getChartFrame(i).validate();
            this.mainWindow.getChartFrame(i).repaint();
        }
        this.dialog.setVisible(false);
        this.dialog.dispose();
    }

    public void onCancel(ActionEvent e) {
        this.dialog.setVisible(false);
        this.dialog.dispose();
    }

    public void onRemove(ActionEvent e) {
        int[] selectedRows = this.dialog.getClusterTable().getSelectedRows();
        for (int i = selectedRows.length - 1; i >= 0; --i) {
            this.tableModel.removeCluster(selectedRows[i]);
        }
    }

    public void onAdd(ActionEvent e) {
        this.tableModel.addCluster();
    }
}

