/*
 * Decompiled with CFR 0.152.
 */
package org.xdat.actionListeners.chartFrames;

import java.awt.Color;
import javax.swing.JCheckBox;
import javax.swing.JColorChooser;
import javax.swing.JSlider;
import org.xdat.Main;
import org.xdat.UserPreferences;
import org.xdat.chart.ParallelCoordinatesChart;
import org.xdat.data.Cluster;
import org.xdat.data.ClusterFactory;
import org.xdat.data.ClusterSet;
import org.xdat.data.DataSheet;
import org.xdat.gui.controls.ColorChoiceButton;
import org.xdat.gui.panels.ParallelCoordinatesChartPanel;
import org.xdat.gui.panels.ParallelCoordinatesChartSidebarPanel;

public class ParallelChartSidebarActionListener {
    private final ParallelCoordinatesChartSidebarPanel sidePanel;
    private final Main mainWindow;
    private final ParallelCoordinatesChartPanel chartPanel;
    private final ClusterFactory clusterFactory;
    private Color activeDesignColor;

    public ParallelChartSidebarActionListener(Main mainWindow, ParallelCoordinatesChartSidebarPanel panel, ParallelCoordinatesChartPanel chartPanel, ClusterFactory clusterFactory) {
        this.mainWindow = mainWindow;
        this.sidePanel = panel;
        this.chartPanel = chartPanel;
        this.activeDesignColor = ((ParallelCoordinatesChart)chartPanel.getChart()).getDefaultDesignColor(true, chartPanel.getChart().isUseAlpha());
        this.clusterFactory = clusterFactory;
    }

    public void changeClusterColor(ColorChoiceButton source, Cluster cluster) {
        Color newColor = JColorChooser.showDialog(this.sidePanel.getChartFrame(), "Cluster Color", cluster.getActiveDesignColor(true));
        if (newColor != null) {
            if (newColor.getAlpha() == 255) {
                int alpha = this.sidePanel.getClusterAlphaSlider(cluster).getValue();
                newColor = new Color(newColor.getRed(), newColor.getGreen(), newColor.getBlue(), alpha);
            }
            cluster.setActiveDesignColor(newColor);
            source.setCurrentColor(newColor);
            this.sidePanel.getClusterAlphaSlider(cluster).setValue(newColor.getAlpha());
            this.chartPanel.repaint();
        }
    }

    public void toggleClusterActive(JCheckBox source, Cluster cluster) {
        cluster.setActive(source.isSelected());
        this.mainWindow.fireClustersChanged();
    }

    public void applySettings(ParallelCoordinatesChart chart, Cluster cluster) {
        int i;
        DataSheet dataSheet = chart.getDataSheet();
        for (i = 0; i < dataSheet.getDesignCount(); ++i) {
            if (!dataSheet.getDesign(i).isActive(chart)) continue;
            dataSheet.getDesign(i).setCluster(cluster);
        }
        this.chartPanel.setPreferredSize(this.chartPanel.getPreferredSize());
        for (i = 0; i < this.mainWindow.getChartFrameCount(); ++i) {
            this.mainWindow.getChartFrame(i).validate();
            this.mainWindow.getChartFrame(i).repaint();
        }
    }

    public void removeCluster(Cluster cluster) {
        ClusterSet clusterSet = this.mainWindow.getCurrentClusterSet();
        clusterSet.removeCluster(cluster);
        this.sidePanel.updateClusterList(clusterSet);
        this.chartPanel.revalidate();
        this.chartPanel.repaint();
    }

    public void addCluster() {
        ClusterSet clusterSet = this.mainWindow.getCurrentClusterSet();
        clusterSet.newCluster(this.clusterFactory);
        this.sidePanel.updateClusterList(clusterSet);
    }

    public void changeActiveDesignColor(ParallelCoordinatesChart chart) {
        Color newColor = JColorChooser.showDialog(this.sidePanel.getChartFrame(), "Background Color", this.activeDesignColor);
        if (newColor != null) {
            if (newColor.getAlpha() == 255) {
                int alphaValue = this.sidePanel.getActiveDesignAlphaSlider().getValue();
                newColor = new Color(newColor.getRed(), newColor.getGreen(), newColor.getBlue(), alphaValue);
            }
            this.activeDesignColor = newColor;
            chart.setActiveDesignColor(newColor);
            this.sidePanel.getActiveDesignColorButton().setCurrentColor(this.activeDesignColor);
            this.sidePanel.getActiveDesignAlphaSlider().setValue(newColor.getAlpha());
            this.chartPanel.repaint();
        }
    }

    public void setClusterAlpha(JSlider slider, Cluster cluster) {
        int value = slider.getValue();
        if (cluster != null) {
            Color newColor = new Color(cluster.getActiveDesignColor(true).getRed(), cluster.getActiveDesignColor(true).getGreen(), cluster.getActiveDesignColor(true).getBlue(), value);
            cluster.setActiveDesignColor(newColor);
            this.chartPanel.repaint();
        }
    }

    public void setActiveDesignColorAlpha(JSlider slider, ParallelCoordinatesChart chart) {
        Color newColor;
        int value = slider.getValue();
        this.activeDesignColor = newColor = new Color(this.activeDesignColor.getRed(), this.activeDesignColor.getGreen(), this.activeDesignColor.getBlue(), value);
        chart.setActiveDesignColor(newColor);
        this.sidePanel.getActiveDesignColorButton().setCurrentColor(this.activeDesignColor);
        this.sidePanel.getActiveDesignAlphaSlider().setValue(slider.getValue());
        this.chartPanel.repaint();
        Color oldDefaultColor = UserPreferences.getInstance().getParallelCoordinatesActiveDesignDefaultColor();
        UserPreferences.getInstance().setParallelCoordinatesActiveDesignDefaultColor(new Color(oldDefaultColor.getRed(), oldDefaultColor.getGreen(), oldDefaultColor.getBlue(), value));
    }

    public Color getActiveDesignColor() {
        return this.activeDesignColor;
    }
}

