/*
 * Decompiled with CFR 0.152.
 */
package org.xdat.actionListeners.chartFrames;

import java.awt.Color;
import java.awt.event.ActionEvent;
import org.xdat.Main;
import org.xdat.chart.Axis;
import org.xdat.chart.ParallelCoordinatesChart;
import org.xdat.data.DataSheet;
import org.xdat.data.Design;
import org.xdat.gui.frames.ChartFrame;
import org.xdat.gui.tables.DataSheetTableColumnModel;

public class ParallelChartContextMenuActionListener {
    private final Main mainWindow;
    private final ChartFrame chartFrame;
    private final Axis axis;

    public ParallelChartContextMenuActionListener(Main mainWindow, ChartFrame chartFrame, Axis axis) {
        this.mainWindow = mainWindow;
        this.chartFrame = chartFrame;
        this.axis = axis;
    }

    public void setCurrentFiltersAsNewRange(ActionEvent e) {
        this.axis.setFilterAsNewRange(this.mainWindow.getDataSheet());
    }

    public void resetFilter(ActionEvent e) {
        this.axis.resetFilters(this.mainWindow.getDataSheet());
    }

    public void autofit(ActionEvent e) {
        this.axis.autofit(this.mainWindow.getDataSheet());
        this.chartFrame.repaint();
    }

    public void moveAxisLeft(ActionEvent e) {
        DataSheetTableColumnModel cm = (DataSheetTableColumnModel)this.mainWindow.getDataSheetTablePanel().getDataTable().getColumnModel();
        boolean jumpedAxisWasInactive = true;
        for (int currentIndex = this.mainWindow.getDataSheet().getParameterIndex(this.axis.getName()); currentIndex > 0 && jumpedAxisWasInactive; --currentIndex) {
            jumpedAxisWasInactive = !((ParallelCoordinatesChart)this.chartFrame.getChart()).getAxis(currentIndex - 1).isActive();
            cm.moveColumn(currentIndex + 1, currentIndex);
        }
    }

    public void moveAxisRight(ActionEvent e) {
        DataSheetTableColumnModel cm = (DataSheetTableColumnModel)this.mainWindow.getDataSheetTablePanel().getDataTable().getColumnModel();
        int currentIndex = this.mainWindow.getDataSheet().getParameterIndex(this.axis.getName());
        boolean jumpedAxisWasInactive = true;
        while (currentIndex + 2 < cm.getColumnCount() && jumpedAxisWasInactive) {
            jumpedAxisWasInactive = !((ParallelCoordinatesChart)this.chartFrame.getChart()).getAxis(currentIndex + 1).isActive();
            cm.moveColumn(currentIndex + 1, currentIndex + 2);
            ++currentIndex;
        }
    }

    public void hideAxis(ActionEvent e) {
        this.axis.setActive(false);
        this.chartFrame.repaint();
    }

    public void addTic(ActionEvent e) {
        this.axis.setTicCount(this.axis.getTicCount() + 1, this.mainWindow.getDataSheet());
        this.chartFrame.repaint();
    }

    public void removeTic(ActionEvent e) {
        this.axis.setTicCount(Math.max(2, this.axis.getTicCount() - 1), this.mainWindow.getDataSheet());
        this.chartFrame.repaint();
    }

    public void addDistanceThisAxis(int delta) {
        this.axis.setWidth(Math.max(0, this.axis.getWidth() + delta));
        this.chartFrame.repaint();
    }

    public void resetAllFilters(ActionEvent e) {
        ParallelCoordinatesChart chart = this.axis.getChart();
        for (int i = 0; i < chart.getAxisCount(); ++i) {
            chart.getAxis(i).resetFilters(this.mainWindow.getDataSheet());
        }
    }

    public void reduceDistanceAllAxes(ActionEvent e) {
        ParallelCoordinatesChart chart = this.axis.getChart();
        for (int i = 0; i < chart.getAxisCount(); ++i) {
            chart.getAxis(i).setWidth(Math.max(0, chart.getAxis(i).getWidth() - 10));
        }
        this.chartFrame.repaint();
    }

    public void increaseDistanceAllAxes(ActionEvent e) {
        ParallelCoordinatesChart chart = this.axis.getChart();
        for (int i = 0; i < chart.getAxisCount(); ++i) {
            chart.getAxis(i).setWidth(Math.max(0, chart.getAxis(i).getWidth() + 10));
        }
        this.chartFrame.repaint();
    }

    public void invertAxis(ActionEvent e) {
        this.axis.setAxisInverted(!this.axis.isAxisInverted(), this.mainWindow.getDataSheet());
    }

    public void applyColorGradient(ActionEvent e) {
        ParallelCoordinatesChart chart = (ParallelCoordinatesChart)this.chartFrame.getChart();
        DataSheet datasheet = chart.getDataSheet();
        double axisRange = this.axis.getMax() - this.axis.getMin();
        for (int designID = 0; designID < datasheet.getDesignCount(); ++designID) {
            int b;
            int g;
            int r;
            Design currentDesign = datasheet.getDesign(designID);
            double value = currentDesign.getDoubleValue(datasheet.getParameter(this.axis.getName()));
            if (axisRange == 0.0) {
                currentDesign.setAxisGradientColor(new Color(0, 0, 255, 150));
                continue;
            }
            int alpha = 255;
            double ratio = this.axis.isAxisInverted() ? (this.axis.getMax() - value) / axisRange : (value - this.axis.getMin()) / axisRange;
            if (ratio > 1.0 || ratio < 0.0) {
                currentDesign.removeAxisGradientColor();
                continue;
            }
            if (ratio > 0.9) {
                ratio = ratio * 10.0 - 9.0;
                r = 165 + (int)(50.0 * (1.0 - ratio));
                g = (int)(48.0 * (1.0 - ratio));
                b = 38 + (int)(1.0 * (1.0 - ratio));
                currentDesign.setAxisGradientColor(new Color(r, g, b, alpha));
                continue;
            }
            if (ratio > 0.8) {
                ratio = ratio * 10.0 - 8.0;
                r = 215 + (int)(29.0 * (1.0 - ratio));
                g = 48 + (int)(61.0 * (1.0 - ratio));
                b = 39 + (int)(28.0 * (1.0 - ratio));
                currentDesign.setAxisGradientColor(new Color(r, g, b, alpha));
                continue;
            }
            if (ratio > 0.7) {
                ratio = ratio * 10.0 - 7.0;
                r = 244 + (int)(9.0 * (1.0 - ratio));
                g = 109 + (int)(65.0 * (1.0 - ratio));
                b = 67 + (int)(30.0 * (1.0 - ratio));
                currentDesign.setAxisGradientColor(new Color(r, g, b, alpha));
                continue;
            }
            if (ratio > 0.6) {
                ratio = ratio * 10.0 - 6.0;
                r = 253 + (int)(1.0 * (1.0 - ratio));
                g = 174 + (int)(50.0 * (1.0 - ratio));
                b = 97 + (int)(47.0 * (1.0 - ratio));
                currentDesign.setAxisGradientColor(new Color(r, g, b, alpha));
                continue;
            }
            if (ratio > 0.5) {
                ratio = ratio * 10.0 - 5.0;
                r = 254 + (int)(1.0 * (1.0 - ratio));
                g = 224 + (int)(31.0 * (1.0 - ratio));
                b = 144 + (int)(47.0 * (1.0 - ratio));
                currentDesign.setAxisGradientColor(new Color(r, g, b, alpha));
                continue;
            }
            if (ratio > 0.4) {
                ratio = ratio * 10.0 - 4.0;
                r = 255 - (int)(31.0 * ratio);
                g = 255 - (int)(12.0 * ratio);
                b = 191 + (int)(57.0 * (1.0 - ratio));
                currentDesign.setAxisGradientColor(new Color(r, g, b, alpha));
                continue;
            }
            if (ratio > 0.3) {
                ratio = ratio * 10.0 - 3.0;
                r = 224 - (int)(53.0 * ratio);
                g = 243 - (int)(26.0 * ratio);
                b = 248 - (int)(15.0 * ratio);
                currentDesign.setAxisGradientColor(new Color(r, g, b, alpha));
                continue;
            }
            if (ratio > 0.2) {
                ratio = ratio * 10.0 - 2.0;
                r = 171 - (int)(55.0 * ratio);
                g = 217 - (int)(44.0 * ratio);
                b = 233 - (int)(24.0 * ratio);
                currentDesign.setAxisGradientColor(new Color(r, g, b, alpha));
                continue;
            }
            if (ratio > 0.1) {
                ratio = ratio * 10.0 - 1.0;
                r = 116 - (int)(67.0 * ratio);
                g = 173 - (int)(56.0 * ratio);
                b = 209 - (int)(29.0 * ratio);
                currentDesign.setAxisGradientColor(new Color(r, g, b, alpha));
                continue;
            }
            r = 69 - (int)(20.0 * (ratio *= 10.0));
            g = 117 - (int)(63.0 * ratio);
            b = 180 - (int)(31.0 * ratio);
            currentDesign.setAxisGradientColor(new Color(r, g, b, alpha));
        }
        this.mainWindow.repaintAllChartFrames();
    }

    public void resetColorGradient(ActionEvent e) {
        DataSheet datasheet = this.chartFrame.getChart().getDataSheet();
        for (int designID = 0; designID < datasheet.getDesignCount(); ++designID) {
            datasheet.getDesign(designID).removeAxisGradientColor();
        }
        this.mainWindow.repaintAllChartFrames();
    }
}

