/*
 * Decompiled with CFR 0.152.
 */
package org.xdat.actionListeners.chartFrames;

import java.awt.Component;
import java.awt.event.ActionEvent;
import javax.swing.JCheckBoxMenuItem;
import org.xdat.Main;
import org.xdat.chart.ParallelCoordinatesChart;
import org.xdat.gui.dialogs.ParameterSetSelectionDialog;
import org.xdat.gui.frames.ChartFrame;

public class ChartFrameSelectParametersMenuActionListener {
    private final Main mainWindow;
    private final ChartFrame chartFrame;
    private final ParallelCoordinatesChart chart;

    public ChartFrameSelectParametersMenuActionListener(Main mainWindow, ChartFrame chartFrame, ParallelCoordinatesChart chart) {
        this.mainWindow = mainWindow;
        this.chartFrame = chartFrame;
        this.chart = chart;
    }

    private void update() {
        this.chartFrame.getChartPanel().setSize(this.chartFrame.getChartPanel().getPreferredSize());
        this.chartFrame.validate();
        this.chartFrame.repaint();
    }

    public void toggleParameter(ActionEvent e) {
        String actionCommand = e.getActionCommand();
        this.chart.getAxis(actionCommand).setActive(!this.chart.getAxis(actionCommand).isActive());
        this.update();
    }

    public void customSelection(ActionEvent e) {
        new ParameterSetSelectionDialog(this.mainWindow, this.chartFrame);
        this.update();
    }

    public void reverseSelection(ActionEvent e) {
        Component[] menuComps = this.chartFrame.getJMenuBar().getMenu(0).getMenuComponents();
        for (int i = 0; i < menuComps.length; ++i) {
            if (!menuComps[i].getClass().equals(JCheckBoxMenuItem.class)) continue;
            this.chart.getAxis(((JCheckBoxMenuItem)menuComps[i]).getText()).setActive(!this.chart.getAxis(((JCheckBoxMenuItem)menuComps[i]).getText()).isActive());
        }
        this.update();
    }

    public void setAllSelected(boolean selected) {
        Component[] menuComps = this.chartFrame.getJMenuBar().getMenu(0).getMenuComponents();
        for (int i = 0; i < menuComps.length; ++i) {
            if (!menuComps[i].getClass().equals(JCheckBoxMenuItem.class)) continue;
            this.chart.getAxis(((JCheckBoxMenuItem)menuComps[i]).getText()).setActive(selected);
        }
        this.update();
    }
}

