/*
 * Decompiled with CFR 0.152.
 */
package org.xdat.actionListeners.chartFrames;

import java.awt.Graphics2D;
import java.awt.event.ActionEvent;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.File;
import java.io.IOException;
import javax.imageio.ImageIO;
import javax.swing.JFileChooser;
import javax.swing.JOptionPane;
import org.apache.batik.dom.GenericDOMImplementation;
import org.apache.batik.svggen.SVGGraphics2D;
import org.w3c.dom.DOMImplementation;
import org.w3c.dom.Document;
import org.xdat.Main;
import org.xdat.UserPreferences;
import org.xdat.gui.frames.ChartFrame;

public class ChartFrameOptionsMenuActionListener {
    private final Main mainWindow;
    private final ChartFrame chartFrame;

    protected ChartFrameOptionsMenuActionListener(Main mainWindow, ChartFrame chartFrame) {
        this.mainWindow = mainWindow;
        this.chartFrame = chartFrame;
    }

    protected Main getMainWindow() {
        return this.mainWindow;
    }

    protected ChartFrame getChartFrame() {
        return this.chartFrame;
    }

    public void exportToPng(ActionEvent e) {
        int returnVal;
        JFileChooser chooser = new JFileChooser();
        if (UserPreferences.getInstance().getCurrentDir() != null) {
            chooser.setCurrentDirectory(new File(UserPreferences.getInstance().getCurrentDir()));
        }
        if ((returnVal = chooser.showSaveDialog(this.chartFrame)) == 0) {
            String filepath = chooser.getSelectedFile().getAbsolutePath();
            if (!filepath.endsWith(".png")) {
                filepath = filepath + ".png";
            }
            UserPreferences.getInstance().setLastFile(filepath);
            try {
                BufferedImage bi = new BufferedImage(this.chartFrame.getChartPanel().getWidth(), this.chartFrame.getChartPanel().getHeight(), 2);
                Graphics2D g = bi.createGraphics();
                this.chartFrame.getChartPanel().paint(g);
                g.dispose();
                ImageIO.write((RenderedImage)bi, "png", new File(filepath));
            }
            catch (IOException exc) {
                JOptionPane.showMessageDialog(this.chartFrame, "IOException on saving image: " + exc.getMessage(), "Export to Image", 0);
            }
        }
    }

    public void exportToSvg(ActionEvent e) {
        int returnVal;
        JFileChooser chooser = new JFileChooser();
        if (UserPreferences.getInstance().getCurrentDir() != null) {
            chooser.setCurrentDirectory(new File(UserPreferences.getInstance().getCurrentDir()));
        }
        if ((returnVal = chooser.showSaveDialog(this.chartFrame)) == 0) {
            String filepath = chooser.getSelectedFile().getAbsolutePath();
            if (!filepath.endsWith(".svg")) {
                filepath = filepath + ".svg";
            }
            UserPreferences.getInstance().setLastFile(filepath);
            try {
                DOMImplementation domImpl = GenericDOMImplementation.getDOMImplementation();
                String svgNS = "http://www.w3.org/2000/svg";
                Document document = domImpl.createDocument(svgNS, "svg", null);
                SVGGraphics2D svgGenerator = new SVGGraphics2D(document);
                this.chartFrame.getChartPanel().paint(svgGenerator);
                svgGenerator.stream(filepath, true);
            }
            catch (IOException exc) {
                JOptionPane.showMessageDialog(this.chartFrame, "IOException on saving SVG: " + exc.getMessage(), "Export to SVG", 0);
            }
        }
    }
}

