/*
 * Decompiled with CFR 0.152.
 */
package org.xdat;

import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import org.jetbrains.annotations.Nullable;
import org.xdat.chart.Chart;
import org.xdat.data.ClusterSet;
import org.xdat.data.DataSheet;

public class Session
implements Serializable {
    static final long serialVersionUID = 5L;
    public static final String sessionFileExtension = ".ses";
    private String sessionName = "Untitled";
    private String sessionDirectory;
    @Nullable
    private DataSheet currentDataSheet;
    private ClusterSet currentClusterSet;
    private final List<Chart> charts = new LinkedList<Chart>();

    public Session() {
        this.currentClusterSet = new ClusterSet();
    }

    public void saveToFile(String pathToFile) throws IOException {
        FileOutputStream fs = new FileOutputStream(pathToFile);
        ObjectOutputStream os = new ObjectOutputStream(fs);
        os.writeObject(this);
        os.close();
    }

    public static Session readFromFile(String pathToFile) throws IOException, ClassNotFoundException {
        FileInputStream fs = new FileInputStream(pathToFile);
        ObjectInputStream is = new ObjectInputStream(fs);
        Session readSession = (Session)is.readObject();
        readSession.initTransientData();
        is.close();
        return readSession;
    }

    private void initTransientData() {
        DataSheet ds = this.currentDataSheet;
        if (ds != null) {
            ds.initTransientData();
        }
        this.currentClusterSet.initTransientData();
        this.charts.forEach(Chart::initTransientData);
    }

    public Collection<Chart> getCharts() {
        return Collections.unmodifiableList(this.charts);
    }

    public void addChart(Chart chart) {
        this.charts.add(chart);
    }

    public void removeChart(Chart chart) {
        this.charts.remove(chart);
    }

    public void clearAllCharts() {
        this.charts.clear();
    }

    public void removeParameter(String paramName) {
        DataSheet dataSheet = this.currentDataSheet;
        if (dataSheet != null) {
            dataSheet.removeParameter(paramName);
        }
    }

    @Nullable
    public DataSheet getCurrentDataSheet() {
        return this.currentDataSheet;
    }

    public void setCurrentDataSheet(@Nullable DataSheet currentDataSheet) {
        this.currentDataSheet = currentDataSheet;
    }

    public ClusterSet getCurrentClusterSet() {
        return this.currentClusterSet;
    }

    public void setCurrentClusterSet(ClusterSet currentClusterSet) {
        this.currentClusterSet = currentClusterSet;
    }

    public String getSessionName() {
        return this.sessionName;
    }

    public void setSessionName(String sessionName) {
        this.sessionName = sessionName;
    }

    public String getSessionDirectory() {
        return this.sessionDirectory;
    }

    public void setSessionDirectory(String sessionDirectory) {
        this.sessionDirectory = sessionDirectory;
    }
}

