/*
 * Decompiled with CFR 0.152.
 */
package org.xdat;

import java.awt.Dimension;
import java.awt.GraphicsEnvironment;
import java.awt.HeadlessException;
import java.io.IOException;
import java.io.InvalidClassException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.LinkedList;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.function.Consumer;
import javax.swing.ImageIcon;
import javax.swing.JFrame;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.ProgressMonitor;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.UnsupportedLookAndFeelException;
import org.jetbrains.annotations.Nullable;
import org.xdat.BuildProperties;
import org.xdat.Session;
import org.xdat.actionListeners.scatter2DChartSettings.ParallelChartFrameComboModel;
import org.xdat.chart.Chart;
import org.xdat.chart.ParallelCoordinatesChart;
import org.xdat.data.ClusterFactory;
import org.xdat.data.ClusterSet;
import org.xdat.data.DataSheet;
import org.xdat.data.DatasheetListener;
import org.xdat.exceptions.NoParametersDefinedException;
import org.xdat.gui.WindowClosingAdapter;
import org.xdat.gui.frames.ChartFrame;
import org.xdat.gui.menus.mainWindow.MainMenuBar;
import org.xdat.gui.panels.DataSheetTablePanel;
import org.xdat.gui.panels.DisabledValueSupplierStaticImpl;
import org.xdat.settings.Setting;
import org.xdat.settings.SettingsGroup;
import org.xdat.settings.SettingsGroupFactory;

public class Main
extends JFrame {
    public static final long serialVersionUID = 10L;
    private final MainMenuBar mainMenuBar;
    private Session currentSession;
    private final List<ChartFrame> chartFrames = new LinkedList<ChartFrame>();
    private final BuildProperties buildProperties;
    private final ClusterFactory clusterFactory = new ClusterFactory();
    private final DatasheetListener datasheetListener;
    private final List<DatasheetListener> subListeners = new CopyOnWriteArrayList<DatasheetListener>();
    private DataSheetTablePanel dataSheetTablePanel;
    private final List<ParallelChartFrameComboModel> comboModels = new LinkedList<ParallelChartFrameComboModel>();
    private final SettingsGroup generalSettingsGroup = SettingsGroupFactory.buildGeneralParallelCoordinatesChartSettingsGroup();
    private final SettingsGroup parallelCoordinatesAxisSettingsGroup;
    private static final List<String> LOOK_AND_FEEL_ORDER_OF_PREF = Arrays.asList("com.sun.java.swing.plaf.gtk.GTKLookAndFeel", "com.sun.java.swing.plaf.windows.WindowsLookAndFeel", "javax.swing.plaf.nimbus.NimbusLookAndFeel");

    public Main() {
        super("xdat   -   Untitled");
        Dimension screenSize;
        for (Setting<?> value : this.generalSettingsGroup.getSettings().values()) {
            value.addListener((source, transaction) -> source.setCurrentToDefault());
        }
        this.parallelCoordinatesAxisSettingsGroup = SettingsGroupFactory.buildParallelCoordinatesChartAxisSettingsGroup(new DisabledValueSupplierStaticImpl<Double>(0.0), new DisabledValueSupplierStaticImpl<Double>(1.0));
        for (Setting<?> value : this.parallelCoordinatesAxisSettingsGroup.getSettings().values()) {
            value.addListener((source, transaction) -> source.setCurrentToDefault());
        }
        this.buildProperties = new BuildProperties();
        this.datasheetListener = new DatasheetListener(){

            @Override
            public void onClustersChanged() {
                Main.this.repaintAllChartFrames();
                Main.this.fireSubListeners(DatasheetListener::onClustersChanged);
            }

            @Override
            public void onDataPanelUpdateRequired() {
                Main.this.updateDataPanel();
                Main.this.fireSubListeners(DatasheetListener::onDataPanelUpdateRequired);
            }

            @Override
            public void onDataChanged(boolean[] autoFitRequired, boolean[] filterResetRequired, boolean[] applyFiltersRequired, boolean parametersChanged) {
                ProgressMonitor progressMonitor = new ProgressMonitor(Main.this, "", "Rebuilding charts", 0, Main.this.getDataSheet().getParameterCount() - 1);
                progressMonitor.setMillisToPopup(0);
                for (int i = 0; i < Main.this.getDataSheet().getParameterCount(); ++i) {
                    int progress = i;
                    if (progressMonitor.isCanceled()) break;
                    SwingUtilities.invokeLater(() -> progressMonitor.setProgress(progress));
                    if (autoFitRequired[i]) {
                        Main.this.autofitAxisAllChartFrames(i);
                    }
                    if (filterResetRequired[i]) {
                        Main.this.resetFiltersOnAxisAllChartFrames(i);
                    }
                    if (!applyFiltersRequired[i]) continue;
                    Main.this.refilterAllChartFrames(i);
                }
                progressMonitor.close();
                Main.this.repaintAllChartFrames();
                Main.this.fireSubListeners(l -> l.onDataChanged(autoFitRequired, filterResetRequired, applyFiltersRequired, false));
            }
        };
        this.currentSession = new Session();
        this.addWindowListener(new WindowClosingAdapter(true));
        this.mainMenuBar = new MainMenuBar(this);
        this.setJMenuBar(this.mainMenuBar);
        ImageIcon img = new ImageIcon(Main.class.getClassLoader().getResource("org/xdat/images/icon.png"));
        this.setIconImage(img.getImage());
        GraphicsEnvironment ge = GraphicsEnvironment.getLocalGraphicsEnvironment();
        try {
            screenSize = new Dimension(ge.getScreenDevices()[0].getDisplayMode().getWidth(), ge.getScreenDevices()[0].getDisplayMode().getHeight());
        }
        catch (Exception e) {
            try {
                screenSize = this.getToolkit().getScreenSize();
            }
            catch (HeadlessException e1) {
                screenSize = new Dimension(1200, 800);
            }
        }
        this.setLocation((int)(0.25 * (double)screenSize.width), (int)(0.25 * (double)screenSize.height));
        this.setSize((int)(0.5 * (double)screenSize.width), (int)(0.5 * (double)screenSize.height));
        this.setVisible(true);
    }

    public void initialiseDataPanel() {
        SwingUtilities.invokeLater(() -> {
            if (this.dataSheetTablePanel == null) {
                this.dataSheetTablePanel = new DataSheetTablePanel(this);
                this.setContentPane(this.dataSheetTablePanel);
                this.dataSheetTablePanel.revalidate();
            } else if (this.currentSession.getCurrentDataSheet() != null) {
                this.dataSheetTablePanel.initialiseDataSheetTableModel();
                this.dataSheetTablePanel.revalidate();
            } else {
                this.setContentPane(new JPanel());
                this.repaint();
            }
        });
    }

    public void updateDataPanel() {
        SwingUtilities.invokeLater(() -> {
            if (this.dataSheetTablePanel == null) {
                this.dataSheetTablePanel = new DataSheetTablePanel(this);
                this.setContentPane(this.dataSheetTablePanel);
                this.dataSheetTablePanel.revalidate();
            } else if (this.currentSession.getCurrentDataSheet() != null) {
                this.dataSheetTablePanel.updateRunsTableModel();
                this.dataSheetTablePanel.revalidate();
            } else {
                this.setContentPane(new JPanel());
                this.repaint();
            }
        });
    }

    public static void main(String[] args) {
        Main.setLookAndFeel();
        new Main();
    }

    private static void setLookAndFeel() {
        for (String lnf : LOOK_AND_FEEL_ORDER_OF_PREF) {
            try {
                UIManager.setLookAndFeel(lnf);
                break;
            }
            catch (ClassNotFoundException | IllegalAccessException | InstantiationException | UnsupportedLookAndFeelException exception) {
            }
        }
    }

    public DataSheet getDataSheet() {
        return this.currentSession.getCurrentDataSheet();
    }

    public void setDataSheet(@Nullable DataSheet dataSheet) {
        DataSheet currentDataSheet = this.currentSession.getCurrentDataSheet();
        if (currentDataSheet != null) {
            currentDataSheet.removeListener(this.datasheetListener);
        }
        this.currentSession.setCurrentDataSheet(dataSheet);
        if (dataSheet == null) {
            this.remove(this.dataSheetTablePanel);
        } else {
            dataSheet.addListener(this.datasheetListener);
        }
        this.initialiseDataPanel();
        this.repaint();
        this.rebuildAllChartFrames();
    }

    public ClusterSet getCurrentClusterSet() {
        return this.currentSession.getCurrentClusterSet();
    }

    public void setCurrentClusterSet(ClusterSet clusterSet) {
        this.currentSession.setCurrentClusterSet(clusterSet);
    }

    public Session getCurrentSession() {
        return this.currentSession;
    }

    public void setCurrentSession(Session currentSession) {
        this.currentSession = currentSession;
    }

    public void addChartFrame(ChartFrame chartFrame) {
        this.chartFrames.add(chartFrame);
        this.addChartToComboboxes(chartFrame);
    }

    public void removeChartFrame(ChartFrame chartFrame) {
        this.chartFrames.remove(chartFrame);
        this.currentSession.removeChart(chartFrame.getChart());
        this.removeChartFromComboboxes(chartFrame);
    }

    public void removeParameter(String paramName) {
        this.getCurrentSession().removeParameter(paramName);
        int newParamsCount = this.getCurrentSession().getCurrentDataSheet().getParameterCount();
        boolean[] flags = new boolean[newParamsCount];
        Arrays.fill(flags, false);
        this.fireDataPanelUpdateRequired();
        this.fireDataChanged(flags, flags, flags);
    }

    public ChartFrame getChartFrame(int index) {
        return this.chartFrames.get(index);
    }

    public ChartFrame getChartFrame(String title) {
        for (int i = 0; i < this.getChartFrameCount(); ++i) {
            if (!title.equals(this.getChartFrame(i).getTitle())) continue;
            return this.getChartFrame(i);
        }
        throw new RuntimeException("No chart found with title " + title);
    }

    public int getChartFrameCount() {
        return this.chartFrames.size();
    }

    public int getUniqueChartId(Class<?> chartClass) {
        int id = 0;
        for (int i = 0; i < this.getChartFrameCount(); ++i) {
            if (!chartClass.equals(this.chartFrames.get(i).getChart().getClass())) continue;
            id = this.chartFrames.get(i).getChart().getID();
        }
        return ++id;
    }

    public void disposeAllChartFrames() {
        for (int i = this.chartFrames.size() - 1; i >= 0; --i) {
            this.removeChartFromComboboxes(this.chartFrames.get(i));
            this.chartFrames.get(i).dispose();
        }
        this.chartFrames.clear();
        this.currentSession.clearAllCharts();
    }

    private void rebuildAllChartFrames() {
        SwingUtilities.invokeLater(() -> {
            ArrayList<Chart> chartsSnapshot = new ArrayList<Chart>(this.currentSession.getCharts());
            this.disposeAllChartFrames();
            for (Chart chart : chartsSnapshot) {
                try {
                    ChartFrame newFrame = new ChartFrame(this, chart);
                    this.chartFrames.add(newFrame);
                    this.currentSession.addChart(chart);
                }
                catch (NoParametersDefinedException e) {
                    JOptionPane.showMessageDialog(this, "Cannot create chart when no parameters are defined.", "No parameters defined!", 0);
                }
            }
        });
    }

    public void repaintAllChartFrames() {
        this.repaintAllChartFrames(new ArrayList<ChartFrame>());
    }

    private void repaintAllChartFrames(List<ChartFrame> exclusionList) {
        SwingUtilities.invokeLater(() -> {
            for (ChartFrame cf : this.chartFrames) {
                if (exclusionList.contains(cf)) continue;
                cf.repaint();
            }
        });
    }

    public void refilterAllChartFrames(int columnIndex) {
        for (ChartFrame chartFrame : this.chartFrames) {
            Chart c = chartFrame.getChart();
            if (!c.getClass().equals(ParallelCoordinatesChart.class)) continue;
            ((ParallelCoordinatesChart)c).getAxis(columnIndex).applyFilters(this.getDataSheet());
        }
    }

    public void autofitAxisAllChartFrames(int axisIndex) {
        for (ChartFrame chartFrame : this.chartFrames) {
            Chart c = chartFrame.getChart();
            if (!c.getClass().equals(ParallelCoordinatesChart.class)) continue;
            ((ParallelCoordinatesChart)c).getAxis(axisIndex).autofit(this.getDataSheet());
        }
    }

    public void resetFiltersOnAxisAllChartFrames(int axisIndex) {
        for (ChartFrame chartFrame : this.chartFrames) {
            Chart c = chartFrame.getChart();
            if (!c.getClass().equals(ParallelCoordinatesChart.class)) continue;
            ((ParallelCoordinatesChart)c).getAxis(axisIndex).resetFilters(this.getDataSheet());
        }
    }

    public void loadSession(String pathToFile) {
        try {
            this.disposeAllChartFrames();
            this.currentSession = Session.readFromFile(pathToFile);
            this.setTitle("xdat   -   " + pathToFile);
            for (Chart chart : this.getCurrentSession().getCharts()) {
                try {
                    new ChartFrame(this, chart);
                }
                catch (NoParametersDefinedException e) {
                    JOptionPane.showMessageDialog(this, "Cannot create chart when no parameters are defined.", "No parameters defined!", 0);
                }
            }
            if (this.currentSession.getCurrentDataSheet() != null) {
                this.getMainMenuBar().setItemsRequiringDataSheetEnabled(true);
            } else {
                this.initialiseDataPanel();
                this.getMainMenuBar().setItemsRequiringDataSheetEnabled(false);
            }
        }
        catch (InvalidClassException | ClassNotFoundException e) {
            JOptionPane.showMessageDialog(this, "The file " + pathToFile + " is not a proper xdat version " + this.buildProperties.getVersion() + " Session file", "Load Session", 0);
        }
        catch (IOException e) {
            JOptionPane.showMessageDialog(this, "Error on loading session: " + e.getMessage(), "Load Session", 0);
        }
    }

    public void saveSessionAs(String pathToFile) {
        try {
            this.currentSession.saveToFile(pathToFile);
        }
        catch (IOException e) {
            JOptionPane.showMessageDialog(this, "IOException on saving session: " + e.getMessage(), "Save Session", 0);
        }
    }

    public MainMenuBar getMainMenuBar() {
        return this.mainMenuBar;
    }

    public DataSheetTablePanel getDataSheetTablePanel() {
        return this.dataSheetTablePanel;
    }

    public void addChartToComboboxes(ChartFrame chartFrame) {
        for (ParallelChartFrameComboModel comboModel : this.comboModels) {
            if (!chartFrame.getChart().getClass().equals(ParallelCoordinatesChart.class)) continue;
            comboModel.addElement(chartFrame.getChart().getTitle());
        }
    }

    public void removeChartFromComboboxes(ChartFrame chartFrame) {
        for (ParallelChartFrameComboModel comboModel : this.comboModels) {
            if (!chartFrame.getChart().getClass().equals(ParallelCoordinatesChart.class)) continue;
            comboModel.removeElement(chartFrame.getChart().getTitle());
        }
    }

    public void registerComboModel(ParallelChartFrameComboModel comboModel) {
        this.comboModels.add(comboModel);
    }

    public void unRegisterComboModel(ParallelChartFrameComboModel comboModel) {
        this.comboModels.remove(comboModel);
    }

    public ClusterFactory getClusterFactory() {
        return this.clusterFactory;
    }

    public SettingsGroup getGeneralSettingsGroup() {
        return this.generalSettingsGroup;
    }

    public SettingsGroup getParallelCoordinatesAxisSettingsGroup() {
        return this.parallelCoordinatesAxisSettingsGroup;
    }

    public void addDataSheetSubListener(DatasheetListener listener) {
        this.subListeners.add(listener);
    }

    public void removeDataSheetSubListener(DatasheetListener listener) {
        this.subListeners.remove(listener);
    }

    private void fireSubListeners(Consumer<DatasheetListener> action) {
        for (DatasheetListener l : this.subListeners) {
            action.accept(l);
        }
    }

    public void fireClustersChanged() {
        this.datasheetListener.onClustersChanged();
    }

    public void fireDataPanelUpdateRequired() {
        this.datasheetListener.onDataPanelUpdateRequired();
    }

    public void fireDataChanged(boolean[] axisAutofitRequired, boolean[] axisResetFilterRequired, boolean[] axisApplyFiltersRequired) {
        this.datasheetListener.onDataChanged(axisAutofitRequired, axisResetFilterRequired, axisApplyFiltersRequired, false);
    }
}

